package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthenticationLogs invokes the idaas_doraemon.ListAuthenticationLogs API synchronously
func (client *Client) ListAuthenticationLogs(request *ListAuthenticationLogsRequest) (response *ListAuthenticationLogsResponse, err error) {
	response = CreateListAuthenticationLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthenticationLogsWithChan invokes the idaas_doraemon.ListAuthenticationLogs API asynchronously
func (client *Client) ListAuthenticationLogsWithChan(request *ListAuthenticationLogsRequest) (<-chan *ListAuthenticationLogsResponse, <-chan error) {
	responseChan := make(chan *ListAuthenticationLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthenticationLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthenticationLogsWithCallback invokes the idaas_doraemon.ListAuthenticationLogs API asynchronously
func (client *Client) ListAuthenticationLogsWithCallback(request *ListAuthenticationLogsRequest, callback func(response *ListAuthenticationLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthenticationLogsResponse
		var err error
		defer close(result)
		response, err = client.ListAuthenticationLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthenticationLogsRequest is the request struct for api ListAuthenticationLogs
type ListAuthenticationLogsRequest struct {
	*requests.RpcRequest
	ToTime                requests.Integer `position:"Query" name:"ToTime"`
	UserId                string           `position:"Query" name:"UserId"`
	LogTag                string           `position:"Query" name:"LogTag"`
	PageNumber            requests.Integer `position:"Query" name:"PageNumber"`
	PageSize              requests.Integer `position:"Query" name:"PageSize"`
	CredentialId          string           `position:"Query" name:"CredentialId"`
	FromTime              requests.Integer `position:"Query" name:"FromTime"`
	AuthenticatorUuid     string           `position:"Query" name:"AuthenticatorUuid"`
	AuthenticatorType     string           `position:"Query" name:"AuthenticatorType"`
	ApplicationExternalId string           `position:"Query" name:"ApplicationExternalId"`
}

// ListAuthenticationLogsResponse is the response struct for api ListAuthenticationLogs
type ListAuthenticationLogsResponse struct {
	*responses.BaseResponse
	RequestId                string                         `json:"RequestId" xml:"RequestId"`
	TotalCount               int64                          `json:"TotalCount" xml:"TotalCount"`
	PageNumber               int64                          `json:"PageNumber" xml:"PageNumber"`
	PageSize                 int64                          `json:"PageSize" xml:"PageSize"`
	AuthenticationLogContent []AuthenticationLogContentItem `json:"AuthenticationLogContent" xml:"AuthenticationLogContent"`
}

// CreateListAuthenticationLogsRequest creates a request to invoke ListAuthenticationLogs API
func CreateListAuthenticationLogsRequest() (request *ListAuthenticationLogsRequest) {
	request = &ListAuthenticationLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ListAuthenticationLogs", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthenticationLogsResponse creates a response to parse from ListAuthenticationLogs response
func CreateListAuthenticationLogsResponse() (response *ListAuthenticationLogsResponse) {
	response = &ListAuthenticationLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
