package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHaVips invokes the ens.DeleteHaVips API synchronously
func (client *Client) DeleteHaVips(request *DeleteHaVipsRequest) (response *DeleteHaVipsResponse, err error) {
	response = CreateDeleteHaVipsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHaVipsWithChan invokes the ens.DeleteHaVips API asynchronously
func (client *Client) DeleteHaVipsWithChan(request *DeleteHaVipsRequest) (<-chan *DeleteHaVipsResponse, <-chan error) {
	responseChan := make(chan *DeleteHaVipsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHaVips(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHaVipsWithCallback invokes the ens.DeleteHaVips API asynchronously
func (client *Client) DeleteHaVipsWithCallback(request *DeleteHaVipsRequest, callback func(response *DeleteHaVipsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHaVipsResponse
		var err error
		defer close(result)
		response, err = client.DeleteHaVips(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHaVipsRequest is the request struct for api DeleteHaVips
type DeleteHaVipsRequest struct {
	*requests.RpcRequest
	HaVipIds *[]string `position:"Query" name:"HaVipIds"  type:"Json"`
}

// DeleteHaVipsResponse is the response struct for api DeleteHaVips
type DeleteHaVipsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteHaVipsRequest creates a request to invoke DeleteHaVips API
func CreateDeleteHaVipsRequest() (request *DeleteHaVipsRequest) {
	request = &DeleteHaVipsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteHaVips", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteHaVipsResponse creates a response to parse from DeleteHaVips response
func CreateDeleteHaVipsResponse() (response *DeleteHaVipsResponse) {
	response = &DeleteHaVipsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
