package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateARMServerInstances invokes the ens.CreateARMServerInstances API synchronously
func (client *Client) CreateARMServerInstances(request *CreateARMServerInstancesRequest) (response *CreateARMServerInstancesResponse, err error) {
	response = CreateCreateARMServerInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateARMServerInstancesWithChan invokes the ens.CreateARMServerInstances API asynchronously
func (client *Client) CreateARMServerInstancesWithChan(request *CreateARMServerInstancesRequest) (<-chan *CreateARMServerInstancesResponse, <-chan error) {
	responseChan := make(chan *CreateARMServerInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateARMServerInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateARMServerInstancesWithCallback invokes the ens.CreateARMServerInstances API asynchronously
func (client *Client) CreateARMServerInstancesWithCallback(request *CreateARMServerInstancesRequest, callback func(response *CreateARMServerInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateARMServerInstancesResponse
		var err error
		defer close(result)
		response, err = client.CreateARMServerInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateARMServerInstancesRequest is the request struct for api CreateARMServerInstances
type CreateARMServerInstancesRequest struct {
	*requests.RpcRequest
	KeyPairName    string           `position:"Query" name:"KeyPairName"`
	Resolution     string           `position:"Query" name:"Resolution"`
	Frequency      requests.Integer `position:"Query" name:"Frequency"`
	EnsRegionId    string           `position:"Query" name:"EnsRegionId"`
	Period         requests.Integer `position:"Query" name:"Period"`
	PeriodUnit     string           `position:"Query" name:"PeriodUnit"`
	AutoRenew      requests.Boolean `position:"Query" name:"AutoRenew"`
	ImageId        string           `position:"Query" name:"ImageId"`
	ServerType     string           `position:"Query" name:"ServerType"`
	AutoUseCoupon  requests.Boolean `position:"Query" name:"AutoUseCoupon"`
	InstanceType   string           `position:"Query" name:"InstanceType"`
	Amount         requests.Integer `position:"Query" name:"Amount"`
	EnvironmentVar string           `position:"Query" name:"EnvironmentVar"`
	NameSpace      string           `position:"Query" name:"NameSpace"`
	ServerName     string           `position:"Query" name:"ServerName"`
	PayType        string           `position:"Query" name:"PayType"`
}

// CreateARMServerInstancesResponse is the response struct for api CreateARMServerInstances
type CreateARMServerInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	OrderId     string   `json:"OrderId" xml:"OrderId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateARMServerInstancesRequest creates a request to invoke CreateARMServerInstances API
func CreateCreateARMServerInstancesRequest() (request *CreateARMServerInstancesRequest) {
	request = &CreateARMServerInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateARMServerInstances", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateARMServerInstancesResponse creates a response to parse from CreateARMServerInstances response
func CreateCreateARMServerInstancesResponse() (response *CreateARMServerInstancesResponse) {
	response = &CreateARMServerInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
