package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScalingGroupV2 invokes the emr.ListScalingGroupV2 API synchronously
func (client *Client) ListScalingGroupV2(request *ListScalingGroupV2Request) (response *ListScalingGroupV2Response, err error) {
	response = CreateListScalingGroupV2Response()
	err = client.DoAction(request, response)
	return
}

// ListScalingGroupV2WithChan invokes the emr.ListScalingGroupV2 API asynchronously
func (client *Client) ListScalingGroupV2WithChan(request *ListScalingGroupV2Request) (<-chan *ListScalingGroupV2Response, <-chan error) {
	responseChan := make(chan *ListScalingGroupV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScalingGroupV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScalingGroupV2WithCallback invokes the emr.ListScalingGroupV2 API asynchronously
func (client *Client) ListScalingGroupV2WithCallback(request *ListScalingGroupV2Request, callback func(response *ListScalingGroupV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScalingGroupV2Response
		var err error
		defer close(result)
		response, err = client.ListScalingGroupV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScalingGroupV2Request is the request struct for api ListScalingGroupV2
type ListScalingGroupV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	ClusterBizId    string           `position:"Query" name:"ClusterBizId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
}

// ListScalingGroupV2Response is the response struct for api ListScalingGroupV2
type ListScalingGroupV2Response struct {
	*responses.BaseResponse
	RequestId  string                    `json:"RequestId" xml:"RequestId"`
	PageNumber int                       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                       `json:"PageSize" xml:"PageSize"`
	TotalCount int                       `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                    `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListScalingGroupV2 `json:"Items" xml:"Items"`
}

// CreateListScalingGroupV2Request creates a request to invoke ListScalingGroupV2 API
func CreateListScalingGroupV2Request() (request *ListScalingGroupV2Request) {
	request = &ListScalingGroupV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListScalingGroupV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListScalingGroupV2Response creates a response to parse from ListScalingGroupV2 response
func CreateListScalingGroupV2Response() (response *ListScalingGroupV2Response) {
	response = &ListScalingGroupV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
