package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConnectedClusters invokes the elasticsearch.ListConnectedClusters API synchronously
func (client *Client) ListConnectedClusters(request *ListConnectedClustersRequest) (response *ListConnectedClustersResponse, err error) {
	response = CreateListConnectedClustersResponse()
	err = client.DoAction(request, response)
	return
}

// ListConnectedClustersWithChan invokes the elasticsearch.ListConnectedClusters API asynchronously
func (client *Client) ListConnectedClustersWithChan(request *ListConnectedClustersRequest) (<-chan *ListConnectedClustersResponse, <-chan error) {
	responseChan := make(chan *ListConnectedClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConnectedClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConnectedClustersWithCallback invokes the elasticsearch.ListConnectedClusters API asynchronously
func (client *Client) ListConnectedClustersWithCallback(request *ListConnectedClustersRequest, callback func(response *ListConnectedClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConnectedClustersResponse
		var err error
		defer close(result)
		response, err = client.ListConnectedClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConnectedClustersRequest is the request struct for api ListConnectedClusters
type ListConnectedClustersRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListConnectedClustersResponse is the response struct for api ListConnectedClusters
type ListConnectedClustersResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Result    ResultInListConnectedClusters `json:"Result" xml:"Result"`
}

// CreateListConnectedClustersRequest creates a request to invoke ListConnectedClusters API
func CreateListConnectedClustersRequest() (request *ListConnectedClustersRequest) {
	request = &ListConnectedClustersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListConnectedClusters", "/openapi/instances/[InstanceId]/connected-clusters", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListConnectedClustersResponse creates a response to parse from ListConnectedClusters response
func CreateListConnectedClustersResponse() (response *ListConnectedClustersResponse) {
	response = &ListConnectedClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
