package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEr invokes the eflo.DeleteEr API synchronously
func (client *Client) DeleteEr(request *DeleteErRequest) (response *DeleteErResponse, err error) {
	response = CreateDeleteErResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteErWithChan invokes the eflo.DeleteEr API asynchronously
func (client *Client) DeleteErWithChan(request *DeleteErRequest) (<-chan *DeleteErResponse, <-chan error) {
	responseChan := make(chan *DeleteErResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteErWithCallback invokes the eflo.DeleteEr API asynchronously
func (client *Client) DeleteErWithCallback(request *DeleteErRequest, callback func(response *DeleteErResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteErResponse
		var err error
		defer close(result)
		response, err = client.DeleteEr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteErRequest is the request struct for api DeleteEr
type DeleteErRequest struct {
	*requests.RpcRequest
	ErId string `position:"Body" name:"ErId"`
}

// DeleteErResponse is the response struct for api DeleteEr
type DeleteErResponse struct {
	*responses.BaseResponse
}

// CreateDeleteErRequest creates a request to invoke DeleteEr API
func CreateDeleteErRequest() (request *DeleteErRequest) {
	request = &DeleteErRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteEr", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteErResponse creates a response to parse from DeleteEr response
func CreateDeleteErResponse() (response *DeleteErResponse) {
	response = &DeleteErResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
