package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootNodes invokes the eflo_controller.RebootNodes API synchronously
func (client *Client) RebootNodes(request *RebootNodesRequest) (response *RebootNodesResponse, err error) {
	response = CreateRebootNodesResponse()
	err = client.DoAction(request, response)
	return
}

// RebootNodesWithChan invokes the eflo_controller.RebootNodes API asynchronously
func (client *Client) RebootNodesWithChan(request *RebootNodesRequest) (<-chan *RebootNodesResponse, <-chan error) {
	responseChan := make(chan *RebootNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootNodesWithCallback invokes the eflo_controller.RebootNodes API asynchronously
func (client *Client) RebootNodesWithCallback(request *RebootNodesRequest, callback func(response *RebootNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootNodesResponse
		var err error
		defer close(result)
		response, err = client.RebootNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootNodesRequest is the request struct for api RebootNodes
type RebootNodesRequest struct {
	*requests.RpcRequest
	IgnoreFailedNodeTasks requests.Boolean `position:"Body" name:"IgnoreFailedNodeTasks"`
	ClusterId             string           `position:"Body" name:"ClusterId"`
	Nodes                 *[]string        `position:"Body" name:"Nodes"  type:"Json"`
}

// RebootNodesResponse is the response struct for api RebootNodes
type RebootNodesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateRebootNodesRequest creates a request to invoke RebootNodes API
func CreateRebootNodesRequest() (request *RebootNodesRequest) {
	request = &RebootNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "RebootNodes", "", "")
	request.Method = requests.POST
	return
}

// CreateRebootNodesResponse creates a response to parse from RebootNodes response
func CreateRebootNodesResponse() (response *RebootNodesResponse) {
	response = &RebootNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
