package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateImageProtocol invokes the ecd.MigrateImageProtocol API synchronously
func (client *Client) MigrateImageProtocol(request *MigrateImageProtocolRequest) (response *MigrateImageProtocolResponse, err error) {
	response = CreateMigrateImageProtocolResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateImageProtocolWithChan invokes the ecd.MigrateImageProtocol API asynchronously
func (client *Client) MigrateImageProtocolWithChan(request *MigrateImageProtocolRequest) (<-chan *MigrateImageProtocolResponse, <-chan error) {
	responseChan := make(chan *MigrateImageProtocolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateImageProtocol(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateImageProtocolWithCallback invokes the ecd.MigrateImageProtocol API asynchronously
func (client *Client) MigrateImageProtocolWithCallback(request *MigrateImageProtocolRequest, callback func(response *MigrateImageProtocolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateImageProtocolResponse
		var err error
		defer close(result)
		response, err = client.MigrateImageProtocol(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateImageProtocolRequest is the request struct for api MigrateImageProtocol
type MigrateImageProtocolRequest struct {
	*requests.RpcRequest
	ImageId            *[]string `position:"Query" name:"ImageId"  type:"Repeated"`
	TargetProtocolType string    `position:"Query" name:"TargetProtocolType"`
}

// MigrateImageProtocolResponse is the response struct for api MigrateImageProtocol
type MigrateImageProtocolResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	FailedIds []string `json:"FailedIds" xml:"FailedIds"`
}

// CreateMigrateImageProtocolRequest creates a request to invoke MigrateImageProtocol API
func CreateMigrateImageProtocolRequest() (request *MigrateImageProtocolRequest) {
	request = &MigrateImageProtocolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "MigrateImageProtocol", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMigrateImageProtocolResponse creates a response to parse from MigrateImageProtocol response
func CreateMigrateImageProtocolResponse() (response *MigrateImageProtocolResponse) {
	response = &MigrateImageProtocolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
