package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDesensitizationRule invokes the dms_enterprise.ListDesensitizationRule API synchronously
func (client *Client) ListDesensitizationRule(request *ListDesensitizationRuleRequest) (response *ListDesensitizationRuleResponse, err error) {
	response = CreateListDesensitizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListDesensitizationRuleWithChan invokes the dms_enterprise.ListDesensitizationRule API asynchronously
func (client *Client) ListDesensitizationRuleWithChan(request *ListDesensitizationRuleRequest) (<-chan *ListDesensitizationRuleResponse, <-chan error) {
	responseChan := make(chan *ListDesensitizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDesensitizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDesensitizationRuleWithCallback invokes the dms_enterprise.ListDesensitizationRule API asynchronously
func (client *Client) ListDesensitizationRuleWithCallback(request *ListDesensitizationRuleRequest, callback func(response *ListDesensitizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDesensitizationRuleResponse
		var err error
		defer close(result)
		response, err = client.ListDesensitizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDesensitizationRuleRequest is the request struct for api ListDesensitizationRule
type ListDesensitizationRuleRequest struct {
	*requests.RpcRequest
	RuleName   string           `position:"Query" name:"RuleName"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	RuleType   string           `position:"Query" name:"RuleType"`
	FuncType   string           `position:"Query" name:"FuncType"`
	RuleId     requests.Integer `position:"Query" name:"RuleId"`
}

// ListDesensitizationRuleResponse is the response struct for api ListDesensitizationRule
type ListDesensitizationRuleResponse struct {
	*responses.BaseResponse
	TotalCount              int                   `json:"TotalCount" xml:"TotalCount"`
	RequestId               string                `json:"RequestId" xml:"RequestId"`
	ErrorCode               string                `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage            string                `json:"ErrorMessage" xml:"ErrorMessage"`
	Success                 bool                  `json:"Success" xml:"Success"`
	DesensitizationRuleList []DesensitizationRule `json:"DesensitizationRuleList" xml:"DesensitizationRuleList"`
}

// CreateListDesensitizationRuleRequest creates a request to invoke ListDesensitizationRule API
func CreateListDesensitizationRuleRequest() (request *ListDesensitizationRuleRequest) {
	request = &ListDesensitizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListDesensitizationRule", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDesensitizationRuleResponse creates a response to parse from ListDesensitizationRule response
func CreateListDesensitizationRuleResponse() (response *ListDesensitizationRuleResponse) {
	response = &ListDesensitizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
