package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSetDcdnWafDomainConfigs invokes the dcdn.BatchSetDcdnWafDomainConfigs API synchronously
func (client *Client) BatchSetDcdnWafDomainConfigs(request *BatchSetDcdnWafDomainConfigsRequest) (response *BatchSetDcdnWafDomainConfigsResponse, err error) {
	response = CreateBatchSetDcdnWafDomainConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSetDcdnWafDomainConfigsWithChan invokes the dcdn.BatchSetDcdnWafDomainConfigs API asynchronously
func (client *Client) BatchSetDcdnWafDomainConfigsWithChan(request *BatchSetDcdnWafDomainConfigsRequest) (<-chan *BatchSetDcdnWafDomainConfigsResponse, <-chan error) {
	responseChan := make(chan *BatchSetDcdnWafDomainConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSetDcdnWafDomainConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSetDcdnWafDomainConfigsWithCallback invokes the dcdn.BatchSetDcdnWafDomainConfigs API asynchronously
func (client *Client) BatchSetDcdnWafDomainConfigsWithCallback(request *BatchSetDcdnWafDomainConfigsRequest, callback func(response *BatchSetDcdnWafDomainConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSetDcdnWafDomainConfigsResponse
		var err error
		defer close(result)
		response, err = client.BatchSetDcdnWafDomainConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSetDcdnWafDomainConfigsRequest is the request struct for api BatchSetDcdnWafDomainConfigs
type BatchSetDcdnWafDomainConfigsRequest struct {
	*requests.RpcRequest
	DomainNames   string `position:"Body" name:"DomainNames"`
	ClientIpTag   string `position:"Body" name:"ClientIpTag"`
	DefenseStatus string `position:"Body" name:"DefenseStatus"`
}

// BatchSetDcdnWafDomainConfigsResponse is the response struct for api BatchSetDcdnWafDomainConfigs
type BatchSetDcdnWafDomainConfigsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchSetDcdnWafDomainConfigsRequest creates a request to invoke BatchSetDcdnWafDomainConfigs API
func CreateBatchSetDcdnWafDomainConfigsRequest() (request *BatchSetDcdnWafDomainConfigsRequest) {
	request = &BatchSetDcdnWafDomainConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchSetDcdnWafDomainConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchSetDcdnWafDomainConfigsResponse creates a response to parse from BatchSetDcdnWafDomainConfigs response
func CreateBatchSetDcdnWafDomainConfigsResponse() (response *BatchSetDcdnWafDomainConfigsResponse) {
	response = &BatchSetDcdnWafDomainConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
