package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStopGateway invokes the das.DeleteStopGateway API synchronously
func (client *Client) DeleteStopGateway(request *DeleteStopGatewayRequest) (response *DeleteStopGatewayResponse, err error) {
	response = CreateDeleteStopGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStopGatewayWithChan invokes the das.DeleteStopGateway API asynchronously
func (client *Client) DeleteStopGatewayWithChan(request *DeleteStopGatewayRequest) (<-chan *DeleteStopGatewayResponse, <-chan error) {
	responseChan := make(chan *DeleteStopGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStopGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStopGatewayWithCallback invokes the das.DeleteStopGateway API asynchronously
func (client *Client) DeleteStopGatewayWithCallback(request *DeleteStopGatewayRequest, callback func(response *DeleteStopGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStopGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeleteStopGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStopGatewayRequest is the request struct for api DeleteStopGateway
type DeleteStopGatewayRequest struct {
	*requests.RpcRequest
	GatewayId string `position:"Query" name:"GatewayId"`
}

// DeleteStopGatewayResponse is the response struct for api DeleteStopGateway
type DeleteStopGatewayResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDeleteStopGatewayRequest creates a request to invoke DeleteStopGateway API
func CreateDeleteStopGatewayRequest() (request *DeleteStopGatewayRequest) {
	request = &DeleteStopGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DeleteStopGateway", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteStopGatewayResponse creates a response to parse from DeleteStopGateway response
func CreateDeleteStopGatewayResponse() (response *DeleteStopGatewayResponse) {
	response = &DeleteStopGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
