package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClientUsers invokes the csas.ListClientUsers API synchronously
func (client *Client) ListClientUsers(request *ListClientUsersRequest) (response *ListClientUsersResponse, err error) {
	response = CreateListClientUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListClientUsersWithChan invokes the csas.ListClientUsers API asynchronously
func (client *Client) ListClientUsersWithChan(request *ListClientUsersRequest) (<-chan *ListClientUsersResponse, <-chan error) {
	responseChan := make(chan *ListClientUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClientUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClientUsersWithCallback invokes the csas.ListClientUsers API asynchronously
func (client *Client) ListClientUsersWithCallback(request *ListClientUsersRequest, callback func(response *ListClientUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClientUsersResponse
		var err error
		defer close(result)
		response, err = client.ListClientUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClientUsersRequest is the request struct for api ListClientUsers
type ListClientUsersRequest struct {
	*requests.RpcRequest
	MobileNumber string           `position:"Query" name:"MobileNumber"`
	DepartmentId string           `position:"Query" name:"DepartmentId"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	IdpConfigId  string           `position:"Query" name:"IdpConfigId"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Email        string           `position:"Query" name:"Email"`
	Username     string           `position:"Query" name:"Username"`
	Status       string           `position:"Query" name:"Status"`
}

// ListClientUsersResponse is the response struct for api ListClientUsers
type ListClientUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListClientUsersRequest creates a request to invoke ListClientUsers API
func CreateListClientUsersRequest() (request *ListClientUsersRequest) {
	request = &ListClientUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListClientUsers", "", "")
	request.Method = requests.GET
	return
}

// CreateListClientUsersResponse creates a response to parse from ListClientUsers response
func CreateListClientUsersResponse() (response *ListClientUsersResponse) {
	response = &ListClientUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
