package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPrivateAccessPolicy invokes the csas.GetPrivateAccessPolicy API synchronously
func (client *Client) GetPrivateAccessPolicy(request *GetPrivateAccessPolicyRequest) (response *GetPrivateAccessPolicyResponse, err error) {
	response = CreateGetPrivateAccessPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetPrivateAccessPolicyWithChan invokes the csas.GetPrivateAccessPolicy API asynchronously
func (client *Client) GetPrivateAccessPolicyWithChan(request *GetPrivateAccessPolicyRequest) (<-chan *GetPrivateAccessPolicyResponse, <-chan error) {
	responseChan := make(chan *GetPrivateAccessPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPrivateAccessPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPrivateAccessPolicyWithCallback invokes the csas.GetPrivateAccessPolicy API asynchronously
func (client *Client) GetPrivateAccessPolicyWithCallback(request *GetPrivateAccessPolicyRequest, callback func(response *GetPrivateAccessPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPrivateAccessPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetPrivateAccessPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPrivateAccessPolicyRequest is the request struct for api GetPrivateAccessPolicy
type GetPrivateAccessPolicyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	PolicyId string `position:"Query" name:"PolicyId"`
}

// GetPrivateAccessPolicyResponse is the response struct for api GetPrivateAccessPolicy
type GetPrivateAccessPolicyResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Policy    PolicyInGetPrivateAccessPolicy `json:"Policy" xml:"Policy"`
}

// CreateGetPrivateAccessPolicyRequest creates a request to invoke GetPrivateAccessPolicy API
func CreateGetPrivateAccessPolicyRequest() (request *GetPrivateAccessPolicyRequest) {
	request = &GetPrivateAccessPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetPrivateAccessPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateGetPrivateAccessPolicyResponse creates a response to parse from GetPrivateAccessPolicy response
func CreateGetPrivateAccessPolicyResponse() (response *GetPrivateAccessPolicyResponse) {
	response = &GetPrivateAccessPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
