package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UserDataDelete invokes the cloudwf.UserDataDelete API synchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatadelete.html
func (client *Client) UserDataDelete(request *UserDataDeleteRequest) (response *UserDataDeleteResponse, err error) {
	response = CreateUserDataDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// UserDataDeleteWithChan invokes the cloudwf.UserDataDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatadelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataDeleteWithChan(request *UserDataDeleteRequest) (<-chan *UserDataDeleteResponse, <-chan error) {
	responseChan := make(chan *UserDataDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UserDataDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UserDataDeleteWithCallback invokes the cloudwf.UserDataDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/userdatadelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UserDataDeleteWithCallback(request *UserDataDeleteRequest, callback func(response *UserDataDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UserDataDeleteResponse
		var err error
		defer close(result)
		response, err = client.UserDataDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UserDataDeleteRequest is the request struct for api UserDataDelete
type UserDataDeleteRequest struct {
	*requests.RpcRequest
	Iid requests.Integer `position:"Query" name:"Iid"`
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// UserDataDeleteResponse is the response struct for api UserDataDelete
type UserDataDeleteResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUserDataDeleteRequest creates a request to invoke UserDataDelete API
func CreateUserDataDeleteRequest() (request *UserDataDeleteRequest) {
	request = &UserDataDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "UserDataDelete", "cloudwf", "openAPI")
	return
}

// CreateUserDataDeleteResponse creates a response to parse from UserDataDelete response
func CreateUserDataDeleteResponse() (response *UserDataDeleteResponse) {
	response = &UserDataDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
