package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserAssetIPTrafficInfo invokes the cloudfw.DescribeUserAssetIPTrafficInfo API synchronously
func (client *Client) DescribeUserAssetIPTrafficInfo(request *DescribeUserAssetIPTrafficInfoRequest) (response *DescribeUserAssetIPTrafficInfoResponse, err error) {
	response = CreateDescribeUserAssetIPTrafficInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserAssetIPTrafficInfoWithChan invokes the cloudfw.DescribeUserAssetIPTrafficInfo API asynchronously
func (client *Client) DescribeUserAssetIPTrafficInfoWithChan(request *DescribeUserAssetIPTrafficInfoRequest) (<-chan *DescribeUserAssetIPTrafficInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeUserAssetIPTrafficInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserAssetIPTrafficInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserAssetIPTrafficInfoWithCallback invokes the cloudfw.DescribeUserAssetIPTrafficInfo API asynchronously
func (client *Client) DescribeUserAssetIPTrafficInfoWithCallback(request *DescribeUserAssetIPTrafficInfoRequest, callback func(response *DescribeUserAssetIPTrafficInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserAssetIPTrafficInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserAssetIPTrafficInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserAssetIPTrafficInfoRequest is the request struct for api DescribeUserAssetIPTrafficInfo
type DescribeUserAssetIPTrafficInfoRequest struct {
	*requests.RpcRequest
	TrafficTime string `position:"Query" name:"TrafficTime"`
	AssetIP     string `position:"Query" name:"AssetIP"`
	Lang        string `position:"Query" name:"Lang"`
}

// DescribeUserAssetIPTrafficInfoResponse is the response struct for api DescribeUserAssetIPTrafficInfo
type DescribeUserAssetIPTrafficInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	StartTime    int64  `json:"StartTime" xml:"StartTime"`
	EndTime      int64  `json:"EndTime" xml:"EndTime"`
	InBps        int64  `json:"InBps" xml:"InBps"`
	OutBps       int64  `json:"OutBps" xml:"OutBps"`
	InPps        int64  `json:"InPps" xml:"InPps"`
	OutPps       int64  `json:"OutPps" xml:"OutPps"`
	SessionCount int64  `json:"SessionCount" xml:"SessionCount"`
	NewConn      int64  `json:"NewConn" xml:"NewConn"`
}

// CreateDescribeUserAssetIPTrafficInfoRequest creates a request to invoke DescribeUserAssetIPTrafficInfo API
func CreateDescribeUserAssetIPTrafficInfoRequest() (request *DescribeUserAssetIPTrafficInfoRequest) {
	request = &DescribeUserAssetIPTrafficInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeUserAssetIPTrafficInfo", "cloudfirewall", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeUserAssetIPTrafficInfoResponse creates a response to parse from DescribeUserAssetIPTrafficInfo response
func CreateDescribeUserAssetIPTrafficInfoResponse() (response *DescribeUserAssetIPTrafficInfoResponse) {
	response = &DescribeUserAssetIPTrafficInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
