package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUpdateBackendTask invokes the cloudapi.DescribeUpdateBackendTask API synchronously
func (client *Client) DescribeUpdateBackendTask(request *DescribeUpdateBackendTaskRequest) (response *DescribeUpdateBackendTaskResponse, err error) {
	response = CreateDescribeUpdateBackendTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUpdateBackendTaskWithChan invokes the cloudapi.DescribeUpdateBackendTask API asynchronously
func (client *Client) DescribeUpdateBackendTaskWithChan(request *DescribeUpdateBackendTaskRequest) (<-chan *DescribeUpdateBackendTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeUpdateBackendTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUpdateBackendTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUpdateBackendTaskWithCallback invokes the cloudapi.DescribeUpdateBackendTask API asynchronously
func (client *Client) DescribeUpdateBackendTaskWithCallback(request *DescribeUpdateBackendTaskRequest, callback func(response *DescribeUpdateBackendTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUpdateBackendTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeUpdateBackendTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUpdateBackendTaskRequest is the request struct for api DescribeUpdateBackendTask
type DescribeUpdateBackendTaskRequest struct {
	*requests.RpcRequest
	OperationUid  string `position:"Query" name:"OperationUid"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeUpdateBackendTaskResponse is the response struct for api DescribeUpdateBackendTask
type DescribeUpdateBackendTaskResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	ApiUpdateBackendResults ApiUpdateBackendResults `json:"ApiUpdateBackendResults" xml:"ApiUpdateBackendResults"`
}

// CreateDescribeUpdateBackendTaskRequest creates a request to invoke DescribeUpdateBackendTask API
func CreateDescribeUpdateBackendTaskRequest() (request *DescribeUpdateBackendTaskRequest) {
	request = &DescribeUpdateBackendTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeUpdateBackendTask", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUpdateBackendTaskResponse creates a response to parse from DescribeUpdateBackendTask response
func CreateDescribeUpdateBackendTaskResponse() (response *DescribeUpdateBackendTaskResponse) {
	response = &DescribeUpdateBackendTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
