package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCityMapCameraStatistics invokes the cdrs.ListCityMapCameraStatistics API synchronously
func (client *Client) ListCityMapCameraStatistics(request *ListCityMapCameraStatisticsRequest) (response *ListCityMapCameraStatisticsResponse, err error) {
	response = CreateListCityMapCameraStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCityMapCameraStatisticsWithChan invokes the cdrs.ListCityMapCameraStatistics API asynchronously
func (client *Client) ListCityMapCameraStatisticsWithChan(request *ListCityMapCameraStatisticsRequest) (<-chan *ListCityMapCameraStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListCityMapCameraStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCityMapCameraStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCityMapCameraStatisticsWithCallback invokes the cdrs.ListCityMapCameraStatistics API asynchronously
func (client *Client) ListCityMapCameraStatisticsWithCallback(request *ListCityMapCameraStatisticsRequest, callback func(response *ListCityMapCameraStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCityMapCameraStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListCityMapCameraStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCityMapCameraStatisticsRequest is the request struct for api ListCityMapCameraStatistics
type ListCityMapCameraStatisticsRequest struct {
	*requests.RpcRequest
	EndTime          string           `position:"Body" name:"EndTime"`
	StartTime        string           `position:"Body" name:"StartTime"`
	PageNumber       requests.Integer `position:"Body" name:"PageNumber"`
	DataSourceIdList string           `position:"Body" name:"DataSourceIdList"`
	PageSize         requests.Integer `position:"Body" name:"PageSize"`
}

// ListCityMapCameraStatisticsResponse is the response struct for api ListCityMapCameraStatistics
type ListCityMapCameraStatisticsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListCityMapCameraStatisticsRequest creates a request to invoke ListCityMapCameraStatistics API
func CreateListCityMapCameraStatisticsRequest() (request *ListCityMapCameraStatisticsRequest) {
	request = &ListCityMapCameraStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListCityMapCameraStatistics", "", "")
	request.Method = requests.POST
	return
}

// CreateListCityMapCameraStatisticsResponse creates a response to parse from ListCityMapCameraStatistics response
func CreateListCityMapCameraStatisticsResponse() (response *ListCityMapCameraStatisticsResponse) {
	response = &ListCityMapCameraStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
