package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantConfig invokes the appstream_center.ModifyTenantConfig API synchronously
func (client *Client) ModifyTenantConfig(request *ModifyTenantConfigRequest) (response *ModifyTenantConfigResponse, err error) {
	response = CreateModifyTenantConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantConfigWithChan invokes the appstream_center.ModifyTenantConfig API asynchronously
func (client *Client) ModifyTenantConfigWithChan(request *ModifyTenantConfigRequest) (<-chan *ModifyTenantConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantConfigWithCallback invokes the appstream_center.ModifyTenantConfig API asynchronously
func (client *Client) ModifyTenantConfigWithCallback(request *ModifyTenantConfigRequest, callback func(response *ModifyTenantConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantConfigRequest is the request struct for api ModifyTenantConfig
type ModifyTenantConfigRequest struct {
	*requests.RpcRequest
	AppInstanceGroupExpireRemind requests.Boolean `position:"Body" name:"AppInstanceGroupExpireRemind"`
}

// ModifyTenantConfigResponse is the response struct for api ModifyTenantConfig
type ModifyTenantConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTenantConfigRequest creates a request to invoke ModifyTenantConfig API
func CreateModifyTenantConfigRequest() (request *ModifyTenantConfigRequest) {
	request = &ModifyTenantConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ModifyTenantConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyTenantConfigResponse creates a response to parse from ModifyTenantConfig response
func CreateModifyTenantConfigResponse() (response *ModifyTenantConfigResponse) {
	response = &ModifyTenantConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
