package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePdnsUdpIpSegment invokes the alidns.CreatePdnsUdpIpSegment API synchronously
func (client *Client) CreatePdnsUdpIpSegment(request *CreatePdnsUdpIpSegmentRequest) (response *CreatePdnsUdpIpSegmentResponse, err error) {
	response = CreateCreatePdnsUdpIpSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePdnsUdpIpSegmentWithChan invokes the alidns.CreatePdnsUdpIpSegment API asynchronously
func (client *Client) CreatePdnsUdpIpSegmentWithChan(request *CreatePdnsUdpIpSegmentRequest) (<-chan *CreatePdnsUdpIpSegmentResponse, <-chan error) {
	responseChan := make(chan *CreatePdnsUdpIpSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePdnsUdpIpSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePdnsUdpIpSegmentWithCallback invokes the alidns.CreatePdnsUdpIpSegment API asynchronously
func (client *Client) CreatePdnsUdpIpSegmentWithCallback(request *CreatePdnsUdpIpSegmentRequest, callback func(response *CreatePdnsUdpIpSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePdnsUdpIpSegmentResponse
		var err error
		defer close(result)
		response, err = client.CreatePdnsUdpIpSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePdnsUdpIpSegmentRequest is the request struct for api CreatePdnsUdpIpSegment
type CreatePdnsUdpIpSegmentRequest struct {
	*requests.RpcRequest
	Ip   string `position:"Query" name:"Ip"`
	Name string `position:"Query" name:"Name"`
	Lang string `position:"Query" name:"Lang"`
}

// CreatePdnsUdpIpSegmentResponse is the response struct for api CreatePdnsUdpIpSegment
type CreatePdnsUdpIpSegmentResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ValidMessage string `json:"ValidMessage" xml:"ValidMessage"`
}

// CreateCreatePdnsUdpIpSegmentRequest creates a request to invoke CreatePdnsUdpIpSegment API
func CreateCreatePdnsUdpIpSegmentRequest() (request *CreatePdnsUdpIpSegmentRequest) {
	request = &CreatePdnsUdpIpSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "CreatePdnsUdpIpSegment", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePdnsUdpIpSegmentResponse creates a response to parse from CreatePdnsUdpIpSegment response
func CreateCreatePdnsUdpIpSegmentResponse() (response *CreatePdnsUdpIpSegmentResponse) {
	response = &CreatePdnsUdpIpSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
