package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckExperimentRunnable invokes the ahas_openapi.CheckExperimentRunnable API synchronously
func (client *Client) CheckExperimentRunnable(request *CheckExperimentRunnableRequest) (response *CheckExperimentRunnableResponse, err error) {
	response = CreateCheckExperimentRunnableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckExperimentRunnableWithChan invokes the ahas_openapi.CheckExperimentRunnable API asynchronously
func (client *Client) CheckExperimentRunnableWithChan(request *CheckExperimentRunnableRequest) (<-chan *CheckExperimentRunnableResponse, <-chan error) {
	responseChan := make(chan *CheckExperimentRunnableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckExperimentRunnable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckExperimentRunnableWithCallback invokes the ahas_openapi.CheckExperimentRunnable API asynchronously
func (client *Client) CheckExperimentRunnableWithCallback(request *CheckExperimentRunnableRequest, callback func(response *CheckExperimentRunnableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckExperimentRunnableResponse
		var err error
		defer close(result)
		response, err = client.CheckExperimentRunnable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckExperimentRunnableRequest is the request struct for api CheckExperimentRunnable
type CheckExperimentRunnableRequest struct {
	*requests.RpcRequest
	AhasRegionId string `position:"Query" name:"AhasRegionId"`
	NameSpace    string `position:"Query" name:"NameSpace"`
	ExperimentId string `position:"Query" name:"ExperimentId"`
}

// CheckExperimentRunnableResponse is the response struct for api CheckExperimentRunnable
type CheckExperimentRunnableResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCheckExperimentRunnableRequest creates a request to invoke CheckExperimentRunnable API
func CreateCheckExperimentRunnableRequest() (request *CheckExperimentRunnableRequest) {
	request = &CheckExperimentRunnableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "CheckExperimentRunnable", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckExperimentRunnableResponse creates a response to parse from CheckExperimentRunnable response
func CreateCheckExperimentRunnableResponse() (response *CheckExperimentRunnableResponse) {
	response = &CheckExperimentRunnableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
