// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCheckLLMResponseStreamCommon = "CheckLLMResponseStream"

// CheckLLMResponseStreamCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CheckLLMResponseStreamCommon operation. The "output" return
// value will be populated with the CheckLLMResponseStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CheckLLMResponseStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after CheckLLMResponseStreamCommon Send returns without error.
//
// See CheckLLMResponseStreamCommon for more information on using the CheckLLMResponseStreamCommon
// API call, and error handling.
//
//    // Example sending a request using the CheckLLMResponseStreamCommonRequest method.
//    req, resp := client.CheckLLMResponseStreamCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) CheckLLMResponseStreamCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCheckLLMResponseStreamCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CheckLLMResponseStreamCommon API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation CheckLLMResponseStreamCommon for usage and error information.
func (c *WAF) CheckLLMResponseStreamCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CheckLLMResponseStreamCommonRequest(input)
	return out, req.Send()
}

// CheckLLMResponseStreamCommonWithContext is the same as CheckLLMResponseStreamCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CheckLLMResponseStreamCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CheckLLMResponseStreamCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CheckLLMResponseStreamCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCheckLLMResponseStream = "CheckLLMResponseStream"

// CheckLLMResponseStreamRequest generates a "volcengine/request.Request" representing the
// client's request for the CheckLLMResponseStream operation. The "output" return
// value will be populated with the CheckLLMResponseStreamCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CheckLLMResponseStreamCommon Request to send the API call to the service.
// the "output" return value is not valid until after CheckLLMResponseStreamCommon Send returns without error.
//
// See CheckLLMResponseStream for more information on using the CheckLLMResponseStream
// API call, and error handling.
//
//    // Example sending a request using the CheckLLMResponseStreamRequest method.
//    req, resp := client.CheckLLMResponseStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) CheckLLMResponseStreamRequest(input *CheckLLMResponseStreamInput) (req *request.Request, output *CheckLLMResponseStreamOutput) {
	op := &request.Operation{
		Name:       opCheckLLMResponseStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckLLMResponseStreamInput{}
	}

	output = &CheckLLMResponseStreamOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CheckLLMResponseStream API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation CheckLLMResponseStream for usage and error information.
func (c *WAF) CheckLLMResponseStream(input *CheckLLMResponseStreamInput) (*CheckLLMResponseStreamOutput, error) {
	req, out := c.CheckLLMResponseStreamRequest(input)
	return out, req.Send()
}

// CheckLLMResponseStreamWithContext is the same as CheckLLMResponseStream with the addition of
// the ability to pass a context and additional request options.
//
// See CheckLLMResponseStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CheckLLMResponseStreamWithContext(ctx volcengine.Context, input *CheckLLMResponseStreamInput, opts ...request.Option) (*CheckLLMResponseStreamOutput, error) {
	req, out := c.CheckLLMResponseStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CheckLLMResponseStreamInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Content is a required field
	Content *string `type:"string" json:",omitempty" required:"true"`

	// ContentType is a required field
	ContentType *int32 `type:"int32" json:",omitempty" required:"true"`

	ContextID *string `type:"string" json:",omitempty"`

	// Host is a required field
	Host *string `type:"string" json:",omitempty" required:"true"`

	// MsgClass is a required field
	MsgClass *int32 `max:"99" type:"int32" json:",omitempty" required:"true"`

	MsgID *string `type:"string" json:",omitempty"`

	// Region is a required field
	Region *string `type:"string" json:",omitempty" required:"true"`

	Timeout *int32 `type:"int32" json:",omitempty"`

	UseStream *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CheckLLMResponseStreamInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckLLMResponseStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckLLMResponseStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckLLMResponseStreamInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.MsgClass == nil {
		invalidParams.Add(request.NewErrParamRequired("MsgClass"))
	}
	if s.MsgClass != nil && *s.MsgClass > 99 {
		invalidParams.Add(request.NewErrParamMaxValue("MsgClass", 99))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CheckLLMResponseStreamInput) SetContent(v string) *CheckLLMResponseStreamInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CheckLLMResponseStreamInput) SetContentType(v int32) *CheckLLMResponseStreamInput {
	s.ContentType = &v
	return s
}

// SetContextID sets the ContextID field's value.
func (s *CheckLLMResponseStreamInput) SetContextID(v string) *CheckLLMResponseStreamInput {
	s.ContextID = &v
	return s
}

// SetHost sets the Host field's value.
func (s *CheckLLMResponseStreamInput) SetHost(v string) *CheckLLMResponseStreamInput {
	s.Host = &v
	return s
}

// SetMsgClass sets the MsgClass field's value.
func (s *CheckLLMResponseStreamInput) SetMsgClass(v int32) *CheckLLMResponseStreamInput {
	s.MsgClass = &v
	return s
}

// SetMsgID sets the MsgID field's value.
func (s *CheckLLMResponseStreamInput) SetMsgID(v string) *CheckLLMResponseStreamInput {
	s.MsgID = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CheckLLMResponseStreamInput) SetRegion(v string) *CheckLLMResponseStreamInput {
	s.Region = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CheckLLMResponseStreamInput) SetTimeout(v int32) *CheckLLMResponseStreamInput {
	s.Timeout = &v
	return s
}

// SetUseStream sets the UseStream field's value.
func (s *CheckLLMResponseStreamInput) SetUseStream(v int32) *CheckLLMResponseStreamInput {
	s.UseStream = &v
	return s
}

type CheckLLMResponseStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ContextID *string `type:"string" json:",omitempty"`

	Decision *DecisionForCheckLLMResponseStreamOutput `type:"structure" json:",omitempty"`

	MsgID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CheckLLMResponseStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckLLMResponseStreamOutput) GoString() string {
	return s.String()
}

// SetContextID sets the ContextID field's value.
func (s *CheckLLMResponseStreamOutput) SetContextID(v string) *CheckLLMResponseStreamOutput {
	s.ContextID = &v
	return s
}

// SetDecision sets the Decision field's value.
func (s *CheckLLMResponseStreamOutput) SetDecision(v *DecisionForCheckLLMResponseStreamOutput) *CheckLLMResponseStreamOutput {
	s.Decision = v
	return s
}

// SetMsgID sets the MsgID field's value.
func (s *CheckLLMResponseStreamOutput) SetMsgID(v string) *CheckLLMResponseStreamOutput {
	s.MsgID = &v
	return s
}

type CustomMatchForCheckLLMResponseStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Word *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CustomMatchForCheckLLMResponseStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomMatchForCheckLLMResponseStreamOutput) GoString() string {
	return s.String()
}

// SetWord sets the Word field's value.
func (s *CustomMatchForCheckLLMResponseStreamOutput) SetWord(v string) *CustomMatchForCheckLLMResponseStreamOutput {
	s.Word = &v
	return s
}

type DecisionForCheckLLMResponseStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *int32 `type:"int32" json:",omitempty"`

	CustomMatches []*CustomMatchForCheckLLMResponseStreamOutput `type:"list" json:",omitempty"`

	ErrCode *int32 `type:"int32" json:",omitempty"`

	ErrMsg *string `type:"string" json:",omitempty"`

	Labels []*string `type:"list" json:",omitempty"`

	Matches []*MatchForCheckLLMResponseStreamOutput `type:"list" json:",omitempty"`

	ReplaceDetail *ReplaceDetailForCheckLLMResponseStreamOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DecisionForCheckLLMResponseStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionForCheckLLMResponseStreamOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetAction(v int32) *DecisionForCheckLLMResponseStreamOutput {
	s.Action = &v
	return s
}

// SetCustomMatches sets the CustomMatches field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetCustomMatches(v []*CustomMatchForCheckLLMResponseStreamOutput) *DecisionForCheckLLMResponseStreamOutput {
	s.CustomMatches = v
	return s
}

// SetErrCode sets the ErrCode field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetErrCode(v int32) *DecisionForCheckLLMResponseStreamOutput {
	s.ErrCode = &v
	return s
}

// SetErrMsg sets the ErrMsg field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetErrMsg(v string) *DecisionForCheckLLMResponseStreamOutput {
	s.ErrMsg = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetLabels(v []*string) *DecisionForCheckLLMResponseStreamOutput {
	s.Labels = v
	return s
}

// SetMatches sets the Matches field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetMatches(v []*MatchForCheckLLMResponseStreamOutput) *DecisionForCheckLLMResponseStreamOutput {
	s.Matches = v
	return s
}

// SetReplaceDetail sets the ReplaceDetail field's value.
func (s *DecisionForCheckLLMResponseStreamOutput) SetReplaceDetail(v *ReplaceDetailForCheckLLMResponseStreamOutput) *DecisionForCheckLLMResponseStreamOutput {
	s.ReplaceDetail = v
	return s
}

type MatchForCheckLLMResponseStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Label *string `type:"string" json:",omitempty"`

	Word *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MatchForCheckLLMResponseStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchForCheckLLMResponseStreamOutput) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *MatchForCheckLLMResponseStreamOutput) SetLabel(v string) *MatchForCheckLLMResponseStreamOutput {
	s.Label = &v
	return s
}

// SetWord sets the Word field's value.
func (s *MatchForCheckLLMResponseStreamOutput) SetWord(v string) *MatchForCheckLLMResponseStreamOutput {
	s.Word = &v
	return s
}

type ReplaceDetailForCheckLLMResponseStreamOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Content *string `type:"string" json:",omitempty"`

	ContentType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReplaceDetailForCheckLLMResponseStreamOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceDetailForCheckLLMResponseStreamOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *ReplaceDetailForCheckLLMResponseStreamOutput) SetContent(v string) *ReplaceDetailForCheckLLMResponseStreamOutput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ReplaceDetailForCheckLLMResponseStreamOutput) SetContentType(v int32) *ReplaceDetailForCheckLLMResponseStreamOutput {
	s.ContentType = &v
	return s
}
