// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opTemporaryUpgradeEipAddressCommon = "TemporaryUpgradeEipAddress"

// TemporaryUpgradeEipAddressCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the TemporaryUpgradeEipAddressCommon operation. The "output" return
// value will be populated with the TemporaryUpgradeEipAddressCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned TemporaryUpgradeEipAddressCommon Request to send the API call to the service.
// the "output" return value is not valid until after TemporaryUpgradeEipAddressCommon Send returns without error.
//
// See TemporaryUpgradeEipAddressCommon for more information on using the TemporaryUpgradeEipAddressCommon
// API call, and error handling.
//
//    // Example sending a request using the TemporaryUpgradeEipAddressCommonRequest method.
//    req, resp := client.TemporaryUpgradeEipAddressCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) TemporaryUpgradeEipAddressCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opTemporaryUpgradeEipAddressCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// TemporaryUpgradeEipAddressCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation TemporaryUpgradeEipAddressCommon for usage and error information.
func (c *VPC) TemporaryUpgradeEipAddressCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.TemporaryUpgradeEipAddressCommonRequest(input)
	return out, req.Send()
}

// TemporaryUpgradeEipAddressCommonWithContext is the same as TemporaryUpgradeEipAddressCommon with the addition of
// the ability to pass a context and additional request options.
//
// See TemporaryUpgradeEipAddressCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) TemporaryUpgradeEipAddressCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.TemporaryUpgradeEipAddressCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTemporaryUpgradeEipAddress = "TemporaryUpgradeEipAddress"

// TemporaryUpgradeEipAddressRequest generates a "volcengine/request.Request" representing the
// client's request for the TemporaryUpgradeEipAddress operation. The "output" return
// value will be populated with the TemporaryUpgradeEipAddressCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned TemporaryUpgradeEipAddressCommon Request to send the API call to the service.
// the "output" return value is not valid until after TemporaryUpgradeEipAddressCommon Send returns without error.
//
// See TemporaryUpgradeEipAddress for more information on using the TemporaryUpgradeEipAddress
// API call, and error handling.
//
//    // Example sending a request using the TemporaryUpgradeEipAddressRequest method.
//    req, resp := client.TemporaryUpgradeEipAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) TemporaryUpgradeEipAddressRequest(input *TemporaryUpgradeEipAddressInput) (req *request.Request, output *TemporaryUpgradeEipAddressOutput) {
	op := &request.Operation{
		Name:       opTemporaryUpgradeEipAddress,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TemporaryUpgradeEipAddressInput{}
	}

	output = &TemporaryUpgradeEipAddressOutput{}
	req = c.newRequest(op, input, output)

	return
}

// TemporaryUpgradeEipAddress API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation TemporaryUpgradeEipAddress for usage and error information.
func (c *VPC) TemporaryUpgradeEipAddress(input *TemporaryUpgradeEipAddressInput) (*TemporaryUpgradeEipAddressOutput, error) {
	req, out := c.TemporaryUpgradeEipAddressRequest(input)
	return out, req.Send()
}

// TemporaryUpgradeEipAddressWithContext is the same as TemporaryUpgradeEipAddress with the addition of
// the ability to pass a context and additional request options.
//
// See TemporaryUpgradeEipAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) TemporaryUpgradeEipAddressWithContext(ctx volcengine.Context, input *TemporaryUpgradeEipAddressInput, opts ...request.Option) (*TemporaryUpgradeEipAddressOutput, error) {
	req, out := c.TemporaryUpgradeEipAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type TemporaryUpgradeEipAddressInput struct {
	_ struct{} `type:"structure"`

	// AllocationId is a required field
	AllocationId *string `min:"1" max:"128" type:"string" required:"true"`

	// Bandwidth is a required field
	Bandwidth *int64 `min:"1" type:"integer" required:"true"`

	// Period is a required field
	Period *int64 `min:"1" max:"720" type:"integer" required:"true"`
}

// String returns the string representation
func (s TemporaryUpgradeEipAddressInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporaryUpgradeEipAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemporaryUpgradeEipAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemporaryUpgradeEipAddressInput"}
	if s.AllocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AllocationId"))
	}
	if s.AllocationId != nil && len(*s.AllocationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllocationId", 1))
	}
	if s.AllocationId != nil && len(*s.AllocationId) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("AllocationId", 128, *s.AllocationId))
	}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.Bandwidth != nil && *s.Bandwidth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Bandwidth", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}
	if s.Period != nil && *s.Period > 720 {
		invalidParams.Add(request.NewErrParamMaxValue("Period", 720))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationId sets the AllocationId field's value.
func (s *TemporaryUpgradeEipAddressInput) SetAllocationId(v string) *TemporaryUpgradeEipAddressInput {
	s.AllocationId = &v
	return s
}

// SetBandwidth sets the Bandwidth field's value.
func (s *TemporaryUpgradeEipAddressInput) SetBandwidth(v int64) *TemporaryUpgradeEipAddressInput {
	s.Bandwidth = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *TemporaryUpgradeEipAddressInput) SetPeriod(v int64) *TemporaryUpgradeEipAddressInput {
	s.Period = &v
	return s
}

type TemporaryUpgradeEipAddressOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s TemporaryUpgradeEipAddressOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporaryUpgradeEipAddressOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *TemporaryUpgradeEipAddressOutput) SetRequestId(v string) *TemporaryUpgradeEipAddressOutput {
	s.RequestId = &v
	return s
}
