// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDisassociateEipAddressCommon = "DisassociateEipAddress"

// DisassociateEipAddressCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DisassociateEipAddressCommon operation. The "output" return
// value will be populated with the DisassociateEipAddressCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisassociateEipAddressCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisassociateEipAddressCommon Send returns without error.
//
// See DisassociateEipAddressCommon for more information on using the DisassociateEipAddressCommon
// API call, and error handling.
//
//    // Example sending a request using the DisassociateEipAddressCommonRequest method.
//    req, resp := client.DisassociateEipAddressCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DisassociateEipAddressCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDisassociateEipAddressCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DisassociateEipAddressCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DisassociateEipAddressCommon for usage and error information.
func (c *VPC) DisassociateEipAddressCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DisassociateEipAddressCommonRequest(input)
	return out, req.Send()
}

// DisassociateEipAddressCommonWithContext is the same as DisassociateEipAddressCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateEipAddressCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DisassociateEipAddressCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DisassociateEipAddressCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateEipAddress = "DisassociateEipAddress"

// DisassociateEipAddressRequest generates a "volcengine/request.Request" representing the
// client's request for the DisassociateEipAddress operation. The "output" return
// value will be populated with the DisassociateEipAddressCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisassociateEipAddressCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisassociateEipAddressCommon Send returns without error.
//
// See DisassociateEipAddress for more information on using the DisassociateEipAddress
// API call, and error handling.
//
//    // Example sending a request using the DisassociateEipAddressRequest method.
//    req, resp := client.DisassociateEipAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DisassociateEipAddressRequest(input *DisassociateEipAddressInput) (req *request.Request, output *DisassociateEipAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateEipAddress,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateEipAddressInput{}
	}

	output = &DisassociateEipAddressOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DisassociateEipAddress API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DisassociateEipAddress for usage and error information.
func (c *VPC) DisassociateEipAddress(input *DisassociateEipAddressInput) (*DisassociateEipAddressOutput, error) {
	req, out := c.DisassociateEipAddressRequest(input)
	return out, req.Send()
}

// DisassociateEipAddressWithContext is the same as DisassociateEipAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateEipAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DisassociateEipAddressWithContext(ctx volcengine.Context, input *DisassociateEipAddressInput, opts ...request.Option) (*DisassociateEipAddressOutput, error) {
	req, out := c.DisassociateEipAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DisassociateEipAddressInput struct {
	_ struct{} `type:"structure"`

	// AllocationId is a required field
	AllocationId *string `type:"string" required:"true"`

	ClientToken *string `type:"string"`

	InstanceId *string `type:"string"`

	InstanceType *string `type:"string" enum:"InstanceTypeForDisassociateEipAddressInput"`
}

// String returns the string representation
func (s DisassociateEipAddressInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateEipAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateEipAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateEipAddressInput"}
	if s.AllocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AllocationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationId sets the AllocationId field's value.
func (s *DisassociateEipAddressInput) SetAllocationId(v string) *DisassociateEipAddressInput {
	s.AllocationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateEipAddressInput) SetClientToken(v string) *DisassociateEipAddressInput {
	s.ClientToken = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DisassociateEipAddressInput) SetInstanceId(v string) *DisassociateEipAddressInput {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DisassociateEipAddressInput) SetInstanceType(v string) *DisassociateEipAddressInput {
	s.InstanceType = &v
	return s
}

type DisassociateEipAddressOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DisassociateEipAddressOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateEipAddressOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DisassociateEipAddressOutput) SetRequestId(v string) *DisassociateEipAddressOutput {
	s.RequestId = &v
	return s
}

const (
	// InstanceTypeForDisassociateEipAddressInputNat is a InstanceTypeForDisassociateEipAddressInput enum value
	InstanceTypeForDisassociateEipAddressInputNat = "Nat"

	// InstanceTypeForDisassociateEipAddressInputNetworkInterface is a InstanceTypeForDisassociateEipAddressInput enum value
	InstanceTypeForDisassociateEipAddressInputNetworkInterface = "NetworkInterface"

	// InstanceTypeForDisassociateEipAddressInputClbInstance is a InstanceTypeForDisassociateEipAddressInput enum value
	InstanceTypeForDisassociateEipAddressInputClbInstance = "ClbInstance"

	// InstanceTypeForDisassociateEipAddressInputEcsInstance is a InstanceTypeForDisassociateEipAddressInput enum value
	InstanceTypeForDisassociateEipAddressInputEcsInstance = "EcsInstance"
)
