// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribePrefixListEntriesCommon = "DescribePrefixListEntries"

// DescribePrefixListEntriesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribePrefixListEntriesCommon operation. The "output" return
// value will be populated with the DescribePrefixListEntriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribePrefixListEntriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribePrefixListEntriesCommon Send returns without error.
//
// See DescribePrefixListEntriesCommon for more information on using the DescribePrefixListEntriesCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribePrefixListEntriesCommonRequest method.
//    req, resp := client.DescribePrefixListEntriesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribePrefixListEntriesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribePrefixListEntriesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribePrefixListEntriesCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribePrefixListEntriesCommon for usage and error information.
func (c *VPC) DescribePrefixListEntriesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribePrefixListEntriesCommonRequest(input)
	return out, req.Send()
}

// DescribePrefixListEntriesCommonWithContext is the same as DescribePrefixListEntriesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePrefixListEntriesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribePrefixListEntriesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribePrefixListEntriesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePrefixListEntries = "DescribePrefixListEntries"

// DescribePrefixListEntriesRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribePrefixListEntries operation. The "output" return
// value will be populated with the DescribePrefixListEntriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribePrefixListEntriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribePrefixListEntriesCommon Send returns without error.
//
// See DescribePrefixListEntries for more information on using the DescribePrefixListEntries
// API call, and error handling.
//
//    // Example sending a request using the DescribePrefixListEntriesRequest method.
//    req, resp := client.DescribePrefixListEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribePrefixListEntriesRequest(input *DescribePrefixListEntriesInput) (req *request.Request, output *DescribePrefixListEntriesOutput) {
	op := &request.Operation{
		Name:       opDescribePrefixListEntries,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePrefixListEntriesInput{}
	}

	output = &DescribePrefixListEntriesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribePrefixListEntries API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribePrefixListEntries for usage and error information.
func (c *VPC) DescribePrefixListEntries(input *DescribePrefixListEntriesInput) (*DescribePrefixListEntriesOutput, error) {
	req, out := c.DescribePrefixListEntriesRequest(input)
	return out, req.Send()
}

// DescribePrefixListEntriesWithContext is the same as DescribePrefixListEntries with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePrefixListEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribePrefixListEntriesWithContext(ctx volcengine.Context, input *DescribePrefixListEntriesInput, opts ...request.Option) (*DescribePrefixListEntriesOutput, error) {
	req, out := c.DescribePrefixListEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribePrefixListEntriesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" max:"100" type:"integer"`

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `max:"100" type:"integer"`

	// PrefixListId is a required field
	PrefixListId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePrefixListEntriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePrefixListEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePrefixListEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePrefixListEntriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MaxResults != nil && *s.MaxResults > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxResults", 100))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.PrefixListId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrefixListId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePrefixListEntriesInput) SetMaxResults(v int64) *DescribePrefixListEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePrefixListEntriesInput) SetNextToken(v string) *DescribePrefixListEntriesInput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribePrefixListEntriesInput) SetPageNumber(v int64) *DescribePrefixListEntriesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribePrefixListEntriesInput) SetPageSize(v int64) *DescribePrefixListEntriesInput {
	s.PageSize = &v
	return s
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *DescribePrefixListEntriesInput) SetPrefixListId(v string) *DescribePrefixListEntriesInput {
	s.PrefixListId = &v
	return s
}

type DescribePrefixListEntriesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `type:"integer"`

	PrefixListEntries []*PrefixListEntryForDescribePrefixListEntriesOutput `type:"list"`

	RequestId *string `type:"string"`

	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribePrefixListEntriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePrefixListEntriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePrefixListEntriesOutput) SetNextToken(v string) *DescribePrefixListEntriesOutput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribePrefixListEntriesOutput) SetPageNumber(v int64) *DescribePrefixListEntriesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribePrefixListEntriesOutput) SetPageSize(v int64) *DescribePrefixListEntriesOutput {
	s.PageSize = &v
	return s
}

// SetPrefixListEntries sets the PrefixListEntries field's value.
func (s *DescribePrefixListEntriesOutput) SetPrefixListEntries(v []*PrefixListEntryForDescribePrefixListEntriesOutput) *DescribePrefixListEntriesOutput {
	s.PrefixListEntries = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribePrefixListEntriesOutput) SetRequestId(v string) *DescribePrefixListEntriesOutput {
	s.RequestId = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribePrefixListEntriesOutput) SetTotalCount(v int64) *DescribePrefixListEntriesOutput {
	s.TotalCount = &v
	return s
}

type PrefixListEntryForDescribePrefixListEntriesOutput struct {
	_ struct{} `type:"structure"`

	Cidr *string `type:"string"`

	Description *string `type:"string"`

	PrefixListId *string `type:"string"`
}

// String returns the string representation
func (s PrefixListEntryForDescribePrefixListEntriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixListEntryForDescribePrefixListEntriesOutput) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *PrefixListEntryForDescribePrefixListEntriesOutput) SetCidr(v string) *PrefixListEntryForDescribePrefixListEntriesOutput {
	s.Cidr = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PrefixListEntryForDescribePrefixListEntriesOutput) SetDescription(v string) *PrefixListEntryForDescribePrefixListEntriesOutput {
	s.Description = &v
	return s
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *PrefixListEntryForDescribePrefixListEntriesOutput) SetPrefixListId(v string) *PrefixListEntryForDescribePrefixListEntriesOutput {
	s.PrefixListId = &v
	return s
}
