// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vod20250101

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opStartExecutionCommon = "StartExecution"

// StartExecutionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the StartExecutionCommon operation. The "output" return
// value will be populated with the StartExecutionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartExecutionCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartExecutionCommon Send returns without error.
//
// See StartExecutionCommon for more information on using the StartExecutionCommon
// API call, and error handling.
//
//    // Example sending a request using the StartExecutionCommonRequest method.
//    req, resp := client.StartExecutionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOD20250101) StartExecutionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opStartExecutionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartExecutionCommon API operation for VOD20250101.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOD20250101's
// API operation StartExecutionCommon for usage and error information.
func (c *VOD20250101) StartExecutionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.StartExecutionCommonRequest(input)
	return out, req.Send()
}

// StartExecutionCommonWithContext is the same as StartExecutionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See StartExecutionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOD20250101) StartExecutionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.StartExecutionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExecution = "StartExecution"

// StartExecutionRequest generates a "volcengine/request.Request" representing the
// client's request for the StartExecution operation. The "output" return
// value will be populated with the StartExecutionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned StartExecutionCommon Request to send the API call to the service.
// the "output" return value is not valid until after StartExecutionCommon Send returns without error.
//
// See StartExecution for more information on using the StartExecution
// API call, and error handling.
//
//    // Example sending a request using the StartExecutionRequest method.
//    req, resp := client.StartExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOD20250101) StartExecutionRequest(input *StartExecutionInput) (req *request.Request, output *StartExecutionOutput) {
	op := &request.Operation{
		Name:       opStartExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExecutionInput{}
	}

	output = &StartExecutionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// StartExecution API operation for VOD20250101.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOD20250101's
// API operation StartExecution for usage and error information.
func (c *VOD20250101) StartExecution(input *StartExecutionInput) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	return out, req.Send()
}

// StartExecutionWithContext is the same as StartExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOD20250101) StartExecutionWithContext(ctx volcengine.Context, input *StartExecutionInput, opts ...request.Option) (*StartExecutionOutput, error) {
	req, out := c.StartExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AdAuditForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdvertiserId *string `type:"string" json:",omitempty"`

	BusinessType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AdAuditForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AdAuditForStartExecutionInput) GoString() string {
	return s.String()
}

// SetAdvertiserId sets the AdvertiserId field's value.
func (s *AdAuditForStartExecutionInput) SetAdvertiserId(v string) *AdAuditForStartExecutionInput {
	s.AdvertiserId = &v
	return s
}

// SetBusinessType sets the BusinessType field's value.
func (s *AdAuditForStartExecutionInput) SetBusinessType(v string) *AdAuditForStartExecutionInput {
	s.BusinessType = &v
	return s
}

type AreaForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BottomRightX *float64 `type:"double" json:",omitempty"`

	BottomRightY *float64 `type:"double" json:",omitempty"`

	TopLeftX *float64 `type:"double" json:",omitempty"`

	TopLeftY *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s AreaForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AreaForStartExecutionInput) GoString() string {
	return s.String()
}

// SetBottomRightX sets the BottomRightX field's value.
func (s *AreaForStartExecutionInput) SetBottomRightX(v float64) *AreaForStartExecutionInput {
	s.BottomRightX = &v
	return s
}

// SetBottomRightY sets the BottomRightY field's value.
func (s *AreaForStartExecutionInput) SetBottomRightY(v float64) *AreaForStartExecutionInput {
	s.BottomRightY = &v
	return s
}

// SetTopLeftX sets the TopLeftX field's value.
func (s *AreaForStartExecutionInput) SetTopLeftX(v float64) *AreaForStartExecutionInput {
	s.TopLeftX = &v
	return s
}

// SetTopLeftY sets the TopLeftY field's value.
func (s *AreaForStartExecutionInput) SetTopLeftY(v float64) *AreaForStartExecutionInput {
	s.TopLeftY = &v
	return s
}

type AsrForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	WithConfidence *bool `type:"boolean" json:",omitempty"`

	WithSpeakerInfo *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AsrForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsrForStartExecutionInput) GoString() string {
	return s.String()
}

// SetLanguage sets the Language field's value.
func (s *AsrForStartExecutionInput) SetLanguage(v string) *AsrForStartExecutionInput {
	s.Language = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AsrForStartExecutionInput) SetMode(v string) *AsrForStartExecutionInput {
	s.Mode = &v
	return s
}

// SetType sets the Type field's value.
func (s *AsrForStartExecutionInput) SetType(v string) *AsrForStartExecutionInput {
	s.Type = &v
	return s
}

// SetWithConfidence sets the WithConfidence field's value.
func (s *AsrForStartExecutionInput) SetWithConfidence(v bool) *AsrForStartExecutionInput {
	s.WithConfidence = &v
	return s
}

// SetWithSpeakerInfo sets the WithSpeakerInfo field's value.
func (s *AsrForStartExecutionInput) SetWithSpeakerInfo(v bool) *AsrForStartExecutionInput {
	s.WithSpeakerInfo = &v
	return s
}

type AudioExtractForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Voice *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AudioExtractForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioExtractForStartExecutionInput) GoString() string {
	return s.String()
}

// SetVoice sets the Voice field's value.
func (s *AudioExtractForStartExecutionInput) SetVoice(v bool) *AudioExtractForStartExecutionInput {
	s.Voice = &v
	return s
}

type AutoForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Locations []*LocationForStartExecutionInput `type:"list" json:",omitempty"`

	SubtitleFilter *SubtitleFilterForStartExecutionInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AutoForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoForStartExecutionInput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *AutoForStartExecutionInput) SetLocations(v []*LocationForStartExecutionInput) *AutoForStartExecutionInput {
	s.Locations = v
	return s
}

// SetSubtitleFilter sets the SubtitleFilter field's value.
func (s *AutoForStartExecutionInput) SetSubtitleFilter(v *SubtitleFilterForStartExecutionInput) *AutoForStartExecutionInput {
	s.SubtitleFilter = v
	return s
}

// SetType sets the Type field's value.
func (s *AutoForStartExecutionInput) SetType(v string) *AutoForStartExecutionInput {
	s.Type = &v
	return s
}

type ByteHDForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TemplateId *string `type:"string" json:",omitempty"`

	WatermarkTemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ByteHDForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteHDForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTemplateId sets the TemplateId field's value.
func (s *ByteHDForStartExecutionInput) SetTemplateId(v string) *ByteHDForStartExecutionInput {
	s.TemplateId = &v
	return s
}

// SetWatermarkTemplateId sets the WatermarkTemplateId field's value.
func (s *ByteHDForStartExecutionInput) SetWatermarkTemplateId(v string) *ByteHDForStartExecutionInput {
	s.WatermarkTemplateId = &v
	return s
}

type ControlForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CallbackArgs *string `type:"string" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	EnableLowPriority *bool `type:"boolean" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ControlForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ControlForStartExecutionInput) GoString() string {
	return s.String()
}

// SetCallbackArgs sets the CallbackArgs field's value.
func (s *ControlForStartExecutionInput) SetCallbackArgs(v string) *ControlForStartExecutionInput {
	s.CallbackArgs = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ControlForStartExecutionInput) SetClientToken(v string) *ControlForStartExecutionInput {
	s.ClientToken = &v
	return s
}

// SetEnableLowPriority sets the EnableLowPriority field's value.
func (s *ControlForStartExecutionInput) SetEnableLowPriority(v bool) *ControlForStartExecutionInput {
	s.EnableLowPriority = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ControlForStartExecutionInput) SetPriority(v int32) *ControlForStartExecutionInput {
	s.Priority = &v
	return s
}

type ConvertOperationForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Task *TaskForStartExecutionInput `type:"structure" json:",omitempty"`

	Template *TemplateForStartExecutionInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Workflow *WorkflowForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOperationForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOperationForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTask sets the Task field's value.
func (s *ConvertOperationForStartExecutionInput) SetTask(v *TaskForStartExecutionInput) *ConvertOperationForStartExecutionInput {
	s.Task = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *ConvertOperationForStartExecutionInput) SetTemplate(v *TemplateForStartExecutionInput) *ConvertOperationForStartExecutionInput {
	s.Template = v
	return s
}

// SetType sets the Type field's value.
func (s *ConvertOperationForStartExecutionInput) SetType(v string) *ConvertOperationForStartExecutionInput {
	s.Type = &v
	return s
}

// SetWorkflow sets the Workflow field's value.
func (s *ConvertOperationForStartExecutionInput) SetWorkflow(v *WorkflowForStartExecutionInput) *ConvertOperationForStartExecutionInput {
	s.Workflow = v
	return s
}

type ConvertSegmentForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	End *float64 `type:"double" json:",omitempty"`

	Start *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s ConvertSegmentForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertSegmentForStartExecutionInput) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *ConvertSegmentForStartExecutionInput) SetEnd(v float64) *ConvertSegmentForStartExecutionInput {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ConvertSegmentForStartExecutionInput) SetStart(v float64) *ConvertSegmentForStartExecutionInput {
	s.Start = &v
	return s
}

type DirectUrlForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	FileName *string `type:"string" json:",omitempty"`

	SpaceName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DirectUrlForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectUrlForStartExecutionInput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DirectUrlForStartExecutionInput) SetBucketName(v string) *DirectUrlForStartExecutionInput {
	s.BucketName = &v
	return s
}

// SetFileName sets the FileName field's value.
func (s *DirectUrlForStartExecutionInput) SetFileName(v string) *DirectUrlForStartExecutionInput {
	s.FileName = &v
	return s
}

// SetSpaceName sets the SpaceName field's value.
func (s *DirectUrlForStartExecutionInput) SetSpaceName(v string) *DirectUrlForStartExecutionInput {
	s.SpaceName = &v
	return s
}

type EnhanceForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnhanceForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnhanceForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTemplateId sets the TemplateId field's value.
func (s *EnhanceForStartExecutionInput) SetTemplateId(v string) *EnhanceForStartExecutionInput {
	s.TemplateId = &v
	return s
}

type EraseForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Auto *AutoForStartExecutionInput `type:"structure" json:",omitempty"`

	Manual *ManualForStartExecutionInput `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	WithEraseInfo *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s EraseForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EraseForStartExecutionInput) GoString() string {
	return s.String()
}

// SetAuto sets the Auto field's value.
func (s *EraseForStartExecutionInput) SetAuto(v *AutoForStartExecutionInput) *EraseForStartExecutionInput {
	s.Auto = v
	return s
}

// SetManual sets the Manual field's value.
func (s *EraseForStartExecutionInput) SetManual(v *ManualForStartExecutionInput) *EraseForStartExecutionInput {
	s.Manual = v
	return s
}

// SetMode sets the Mode field's value.
func (s *EraseForStartExecutionInput) SetMode(v string) *EraseForStartExecutionInput {
	s.Mode = &v
	return s
}

// SetWithEraseInfo sets the WithEraseInfo field's value.
func (s *EraseForStartExecutionInput) SetWithEraseInfo(v bool) *EraseForStartExecutionInput {
	s.WithEraseInfo = &v
	return s
}

type FileDeleteForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SkipError *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s FileDeleteForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FileDeleteForStartExecutionInput) GoString() string {
	return s.String()
}

// SetSkipError sets the SkipError field's value.
func (s *FileDeleteForStartExecutionInput) SetSkipError(v bool) *FileDeleteForStartExecutionInput {
	s.SkipError = &v
	return s
}

type FileIdForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileId *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FileIdForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FileIdForStartExecutionInput) GoString() string {
	return s.String()
}

// SetFileId sets the FileId field's value.
func (s *FileIdForStartExecutionInput) SetFileId(v string) *FileIdForStartExecutionInput {
	s.FileId = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *FileIdForStartExecutionInput) SetVid(v string) *FileIdForStartExecutionInput {
	s.Vid = &v
	return s
}

type HighlightForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	StorylineCuts *StorylineCutsForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s HighlightForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HighlightForStartExecutionInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *HighlightForStartExecutionInput) SetMode(v string) *HighlightForStartExecutionInput {
	s.Mode = &v
	return s
}

// SetStorylineCuts sets the StorylineCuts field's value.
func (s *HighlightForStartExecutionInput) SetStorylineCuts(v *StorylineCutsForStartExecutionInput) *HighlightForStartExecutionInput {
	s.StorylineCuts = v
	return s
}

type InputForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DirectUrl *DirectUrlForStartExecutionInput `type:"structure" json:",omitempty"`

	FileId *FileIdForStartExecutionInput `type:"structure" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InputForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InputForStartExecutionInput) GoString() string {
	return s.String()
}

// SetDirectUrl sets the DirectUrl field's value.
func (s *InputForStartExecutionInput) SetDirectUrl(v *DirectUrlForStartExecutionInput) *InputForStartExecutionInput {
	s.DirectUrl = v
	return s
}

// SetFileId sets the FileId field's value.
func (s *InputForStartExecutionInput) SetFileId(v *FileIdForStartExecutionInput) *InputForStartExecutionInput {
	s.FileId = v
	return s
}

// SetTag sets the Tag field's value.
func (s *InputForStartExecutionInput) SetTag(v string) *InputForStartExecutionInput {
	s.Tag = &v
	return s
}

// SetType sets the Type field's value.
func (s *InputForStartExecutionInput) SetType(v string) *InputForStartExecutionInput {
	s.Type = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *InputForStartExecutionInput) SetVid(v string) *InputForStartExecutionInput {
	s.Vid = &v
	return s
}

type LocationForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RatioLocation *RatioLocationForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s LocationForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LocationForStartExecutionInput) GoString() string {
	return s.String()
}

// SetRatioLocation sets the RatioLocation field's value.
func (s *LocationForStartExecutionInput) SetRatioLocation(v *RatioLocationForStartExecutionInput) *LocationForStartExecutionInput {
	s.RatioLocation = v
	return s
}

type ManualForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Locations []*LocationForStartExecutionInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ManualForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ManualForStartExecutionInput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *ManualForStartExecutionInput) SetLocations(v []*LocationForStartExecutionInput) *ManualForStartExecutionInput {
	s.Locations = v
	return s
}

type ModelForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AsrAppId *string `type:"string" json:",omitempty"`

	AsrAppType *string `type:"string" json:",omitempty"`

	DoubaoTextEndpoint *string `type:"string" json:",omitempty"`

	DoubaoVisionEndpoint *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModelForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelForStartExecutionInput) GoString() string {
	return s.String()
}

// SetAsrAppId sets the AsrAppId field's value.
func (s *ModelForStartExecutionInput) SetAsrAppId(v string) *ModelForStartExecutionInput {
	s.AsrAppId = &v
	return s
}

// SetAsrAppType sets the AsrAppType field's value.
func (s *ModelForStartExecutionInput) SetAsrAppType(v string) *ModelForStartExecutionInput {
	s.AsrAppType = &v
	return s
}

// SetDoubaoTextEndpoint sets the DoubaoTextEndpoint field's value.
func (s *ModelForStartExecutionInput) SetDoubaoTextEndpoint(v string) *ModelForStartExecutionInput {
	s.DoubaoTextEndpoint = &v
	return s
}

// SetDoubaoVisionEndpoint sets the DoubaoVisionEndpoint field's value.
func (s *ModelForStartExecutionInput) SetDoubaoVisionEndpoint(v string) *ModelForStartExecutionInput {
	s.DoubaoVisionEndpoint = &v
	return s
}

type MultiInputForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DirectUrl *DirectUrlForStartExecutionInput `type:"structure" json:",omitempty"`

	FileId *FileIdForStartExecutionInput `type:"structure" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Vid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MultiInputForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiInputForStartExecutionInput) GoString() string {
	return s.String()
}

// SetDirectUrl sets the DirectUrl field's value.
func (s *MultiInputForStartExecutionInput) SetDirectUrl(v *DirectUrlForStartExecutionInput) *MultiInputForStartExecutionInput {
	s.DirectUrl = v
	return s
}

// SetFileId sets the FileId field's value.
func (s *MultiInputForStartExecutionInput) SetFileId(v *FileIdForStartExecutionInput) *MultiInputForStartExecutionInput {
	s.FileId = v
	return s
}

// SetTag sets the Tag field's value.
func (s *MultiInputForStartExecutionInput) SetTag(v string) *MultiInputForStartExecutionInput {
	s.Tag = &v
	return s
}

// SetType sets the Type field's value.
func (s *MultiInputForStartExecutionInput) SetType(v string) *MultiInputForStartExecutionInput {
	s.Type = &v
	return s
}

// SetVid sets the Vid field's value.
func (s *MultiInputForStartExecutionInput) SetVid(v string) *MultiInputForStartExecutionInput {
	s.Vid = &v
	return s
}

type NodeForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Dependencies []*string `type:"list" json:",omitempty"`

	Input *MultiInputForStartExecutionInput `type:"structure" json:",omitempty"`

	MultiInputs []*MultiInputForStartExecutionInput `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Operation *OperationForStartExecutionInput `type:"structure" json:",omitempty"`

	Policy *PolicyForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s NodeForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeForStartExecutionInput) GoString() string {
	return s.String()
}

// SetDependencies sets the Dependencies field's value.
func (s *NodeForStartExecutionInput) SetDependencies(v []*string) *NodeForStartExecutionInput {
	s.Dependencies = v
	return s
}

// SetInput sets the Input field's value.
func (s *NodeForStartExecutionInput) SetInput(v *MultiInputForStartExecutionInput) *NodeForStartExecutionInput {
	s.Input = v
	return s
}

// SetMultiInputs sets the MultiInputs field's value.
func (s *NodeForStartExecutionInput) SetMultiInputs(v []*MultiInputForStartExecutionInput) *NodeForStartExecutionInput {
	s.MultiInputs = v
	return s
}

// SetName sets the Name field's value.
func (s *NodeForStartExecutionInput) SetName(v string) *NodeForStartExecutionInput {
	s.Name = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *NodeForStartExecutionInput) SetOperation(v *OperationForStartExecutionInput) *NodeForStartExecutionInput {
	s.Operation = v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *NodeForStartExecutionInput) SetPolicy(v *PolicyForStartExecutionInput) *NodeForStartExecutionInput {
	s.Policy = v
	return s
}

type OcrForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	WithImageSet *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OcrForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OcrForStartExecutionInput) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *OcrForStartExecutionInput) SetMode(v string) *OcrForStartExecutionInput {
	s.Mode = &v
	return s
}

// SetWithImageSet sets the WithImageSet field's value.
func (s *OcrForStartExecutionInput) SetWithImageSet(v bool) *OcrForStartExecutionInput {
	s.WithImageSet = &v
	return s
}

type OperationForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Task *TaskForStartExecutionInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OperationForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTask sets the Task field's value.
func (s *OperationForStartExecutionInput) SetTask(v *TaskForStartExecutionInput) *OperationForStartExecutionInput {
	s.Task = v
	return s
}

// SetType sets the Type field's value.
func (s *OperationForStartExecutionInput) SetType(v string) *OperationForStartExecutionInput {
	s.Type = &v
	return s
}

type PolicyForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NodeFail *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PolicyForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyForStartExecutionInput) GoString() string {
	return s.String()
}

// SetNodeFail sets the NodeFail field's value.
func (s *PolicyForStartExecutionInput) SetNodeFail(v string) *PolicyForStartExecutionInput {
	s.NodeFail = &v
	return s
}

type RatioLocationForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BottomRightX *float64 `type:"double" json:",omitempty"`

	BottomRightY *float64 `type:"double" json:",omitempty"`

	TopLeftX *float64 `type:"double" json:",omitempty"`

	TopLeftY *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s RatioLocationForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RatioLocationForStartExecutionInput) GoString() string {
	return s.String()
}

// SetBottomRightX sets the BottomRightX field's value.
func (s *RatioLocationForStartExecutionInput) SetBottomRightX(v float64) *RatioLocationForStartExecutionInput {
	s.BottomRightX = &v
	return s
}

// SetBottomRightY sets the BottomRightY field's value.
func (s *RatioLocationForStartExecutionInput) SetBottomRightY(v float64) *RatioLocationForStartExecutionInput {
	s.BottomRightY = &v
	return s
}

// SetTopLeftX sets the TopLeftX field's value.
func (s *RatioLocationForStartExecutionInput) SetTopLeftX(v float64) *RatioLocationForStartExecutionInput {
	s.TopLeftX = &v
	return s
}

// SetTopLeftY sets the TopLeftY field's value.
func (s *RatioLocationForStartExecutionInput) SetTopLeftY(v float64) *RatioLocationForStartExecutionInput {
	s.TopLeftY = &v
	return s
}

type SegmentForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NoFile *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s SegmentForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentForStartExecutionInput) GoString() string {
	return s.String()
}

// SetNoFile sets the NoFile field's value.
func (s *SegmentForStartExecutionInput) SetNoFile(v bool) *SegmentForStartExecutionInput {
	s.NoFile = &v
	return s
}

type SnapshotParamForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Area *AreaForStartExecutionInput `type:"structure" json:",omitempty"`

	Fps *float64 `type:"double" json:",omitempty"`

	Resolution *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SnapshotParamForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotParamForStartExecutionInput) GoString() string {
	return s.String()
}

// SetArea sets the Area field's value.
func (s *SnapshotParamForStartExecutionInput) SetArea(v *AreaForStartExecutionInput) *SnapshotParamForStartExecutionInput {
	s.Area = v
	return s
}

// SetFps sets the Fps field's value.
func (s *SnapshotParamForStartExecutionInput) SetFps(v float64) *SnapshotParamForStartExecutionInput {
	s.Fps = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *SnapshotParamForStartExecutionInput) SetResolution(v string) *SnapshotParamForStartExecutionInput {
	s.Resolution = &v
	return s
}

type StartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Control *ControlForStartExecutionInput `type:"structure" json:",omitempty"`

	Input *InputForStartExecutionInput `type:"structure" json:",omitempty"`

	MultiInputs []*MultiInputForStartExecutionInput `type:"list" json:",omitempty"`

	Operation *ConvertOperationForStartExecutionInput `type:"structure" json:",omitempty"`

	SpaceName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionInput) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *StartExecutionInput) SetControl(v *ControlForStartExecutionInput) *StartExecutionInput {
	s.Control = v
	return s
}

// SetInput sets the Input field's value.
func (s *StartExecutionInput) SetInput(v *InputForStartExecutionInput) *StartExecutionInput {
	s.Input = v
	return s
}

// SetMultiInputs sets the MultiInputs field's value.
func (s *StartExecutionInput) SetMultiInputs(v []*MultiInputForStartExecutionInput) *StartExecutionInput {
	s.MultiInputs = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *StartExecutionInput) SetOperation(v *ConvertOperationForStartExecutionInput) *StartExecutionInput {
	s.Operation = v
	return s
}

// SetSpaceName sets the SpaceName field's value.
func (s *StartExecutionInput) SetSpaceName(v string) *StartExecutionInput {
	s.SpaceName = &v
	return s
}

type StartExecutionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	RunId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StartExecutionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartExecutionOutput) GoString() string {
	return s.String()
}

// SetRunId sets the RunId field's value.
func (s *StartExecutionOutput) SetRunId(v string) *StartExecutionOutput {
	s.RunId = &v
	return s
}

type StorylineCutsForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxDuration *float64 `type:"double" json:",omitempty"`

	MaxNumber *float64 `type:"double" json:",omitempty"`

	MinDuration *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s StorylineCutsForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorylineCutsForStartExecutionInput) GoString() string {
	return s.String()
}

// SetMaxDuration sets the MaxDuration field's value.
func (s *StorylineCutsForStartExecutionInput) SetMaxDuration(v float64) *StorylineCutsForStartExecutionInput {
	s.MaxDuration = &v
	return s
}

// SetMaxNumber sets the MaxNumber field's value.
func (s *StorylineCutsForStartExecutionInput) SetMaxNumber(v float64) *StorylineCutsForStartExecutionInput {
	s.MaxNumber = &v
	return s
}

// SetMinDuration sets the MinDuration field's value.
func (s *StorylineCutsForStartExecutionInput) SetMinDuration(v float64) *StorylineCutsForStartExecutionInput {
	s.MinDuration = &v
	return s
}

type StorylineForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClipDuration *float64 `type:"double" json:",omitempty"`

	SampleMode *string `type:"string" json:",omitempty"`

	WithSnapshot *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s StorylineForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorylineForStartExecutionInput) GoString() string {
	return s.String()
}

// SetClipDuration sets the ClipDuration field's value.
func (s *StorylineForStartExecutionInput) SetClipDuration(v float64) *StorylineForStartExecutionInput {
	s.ClipDuration = &v
	return s
}

// SetSampleMode sets the SampleMode field's value.
func (s *StorylineForStartExecutionInput) SetSampleMode(v string) *StorylineForStartExecutionInput {
	s.SampleMode = &v
	return s
}

// SetWithSnapshot sets the WithSnapshot field's value.
func (s *StorylineForStartExecutionInput) SetWithSnapshot(v bool) *StorylineForStartExecutionInput {
	s.WithSnapshot = &v
	return s
}

type SubtitleFilterForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxTextHeightRatio *float64 `type:"double" json:",omitempty"`

	MinTextHeightRatio *float64 `type:"double" json:",omitempty"`

	RectangleCenterOffsetRatio *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s SubtitleFilterForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubtitleFilterForStartExecutionInput) GoString() string {
	return s.String()
}

// SetMaxTextHeightRatio sets the MaxTextHeightRatio field's value.
func (s *SubtitleFilterForStartExecutionInput) SetMaxTextHeightRatio(v float64) *SubtitleFilterForStartExecutionInput {
	s.MaxTextHeightRatio = &v
	return s
}

// SetMinTextHeightRatio sets the MinTextHeightRatio field's value.
func (s *SubtitleFilterForStartExecutionInput) SetMinTextHeightRatio(v float64) *SubtitleFilterForStartExecutionInput {
	s.MinTextHeightRatio = &v
	return s
}

// SetRectangleCenterOffsetRatio sets the RectangleCenterOffsetRatio field's value.
func (s *SubtitleFilterForStartExecutionInput) SetRectangleCenterOffsetRatio(v float64) *SubtitleFilterForStartExecutionInput {
	s.RectangleCenterOffsetRatio = &v
	return s
}

type TaskForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdAudit *AdAuditForStartExecutionInput `type:"structure" json:",omitempty"`

	Asr *AsrForStartExecutionInput `type:"structure" json:",omitempty"`

	AudioExtract *AudioExtractForStartExecutionInput `type:"structure" json:",omitempty"`

	Erase *EraseForStartExecutionInput `type:"structure" json:",omitempty"`

	FileDelete *FileDeleteForStartExecutionInput `type:"structure" json:",omitempty"`

	Highlight *HighlightForStartExecutionInput `type:"structure" json:",omitempty"`

	Ocr *OcrForStartExecutionInput `type:"structure" json:",omitempty"`

	Segment *SegmentForStartExecutionInput `type:"structure" json:",omitempty"`

	Storyline *StorylineForStartExecutionInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	VideoGeneration *VideoGenerationForStartExecutionInput `type:"structure" json:",omitempty"`

	VideoSummary *VideoSummaryForStartExecutionInput `type:"structure" json:",omitempty"`

	Vision *VisionForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TaskForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskForStartExecutionInput) GoString() string {
	return s.String()
}

// SetAdAudit sets the AdAudit field's value.
func (s *TaskForStartExecutionInput) SetAdAudit(v *AdAuditForStartExecutionInput) *TaskForStartExecutionInput {
	s.AdAudit = v
	return s
}

// SetAsr sets the Asr field's value.
func (s *TaskForStartExecutionInput) SetAsr(v *AsrForStartExecutionInput) *TaskForStartExecutionInput {
	s.Asr = v
	return s
}

// SetAudioExtract sets the AudioExtract field's value.
func (s *TaskForStartExecutionInput) SetAudioExtract(v *AudioExtractForStartExecutionInput) *TaskForStartExecutionInput {
	s.AudioExtract = v
	return s
}

// SetErase sets the Erase field's value.
func (s *TaskForStartExecutionInput) SetErase(v *EraseForStartExecutionInput) *TaskForStartExecutionInput {
	s.Erase = v
	return s
}

// SetFileDelete sets the FileDelete field's value.
func (s *TaskForStartExecutionInput) SetFileDelete(v *FileDeleteForStartExecutionInput) *TaskForStartExecutionInput {
	s.FileDelete = v
	return s
}

// SetHighlight sets the Highlight field's value.
func (s *TaskForStartExecutionInput) SetHighlight(v *HighlightForStartExecutionInput) *TaskForStartExecutionInput {
	s.Highlight = v
	return s
}

// SetOcr sets the Ocr field's value.
func (s *TaskForStartExecutionInput) SetOcr(v *OcrForStartExecutionInput) *TaskForStartExecutionInput {
	s.Ocr = v
	return s
}

// SetSegment sets the Segment field's value.
func (s *TaskForStartExecutionInput) SetSegment(v *SegmentForStartExecutionInput) *TaskForStartExecutionInput {
	s.Segment = v
	return s
}

// SetStoryline sets the Storyline field's value.
func (s *TaskForStartExecutionInput) SetStoryline(v *StorylineForStartExecutionInput) *TaskForStartExecutionInput {
	s.Storyline = v
	return s
}

// SetType sets the Type field's value.
func (s *TaskForStartExecutionInput) SetType(v string) *TaskForStartExecutionInput {
	s.Type = &v
	return s
}

// SetVideoGeneration sets the VideoGeneration field's value.
func (s *TaskForStartExecutionInput) SetVideoGeneration(v *VideoGenerationForStartExecutionInput) *TaskForStartExecutionInput {
	s.VideoGeneration = v
	return s
}

// SetVideoSummary sets the VideoSummary field's value.
func (s *TaskForStartExecutionInput) SetVideoSummary(v *VideoSummaryForStartExecutionInput) *TaskForStartExecutionInput {
	s.VideoSummary = v
	return s
}

// SetVision sets the Vision field's value.
func (s *TaskForStartExecutionInput) SetVision(v *VisionForStartExecutionInput) *TaskForStartExecutionInput {
	s.Vision = v
	return s
}

type TemplateForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ByteHD *ByteHDForStartExecutionInput `type:"structure" json:",omitempty"`

	Enhance *EnhanceForStartExecutionInput `type:"structure" json:",omitempty"`

	TranscodeAudio *TranscodeAudioForStartExecutionInput `type:"structure" json:",omitempty"`

	TranscodeVideo *TranscodeVideoForStartExecutionInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TemplateForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateForStartExecutionInput) GoString() string {
	return s.String()
}

// SetByteHD sets the ByteHD field's value.
func (s *TemplateForStartExecutionInput) SetByteHD(v *ByteHDForStartExecutionInput) *TemplateForStartExecutionInput {
	s.ByteHD = v
	return s
}

// SetEnhance sets the Enhance field's value.
func (s *TemplateForStartExecutionInput) SetEnhance(v *EnhanceForStartExecutionInput) *TemplateForStartExecutionInput {
	s.Enhance = v
	return s
}

// SetTranscodeAudio sets the TranscodeAudio field's value.
func (s *TemplateForStartExecutionInput) SetTranscodeAudio(v *TranscodeAudioForStartExecutionInput) *TemplateForStartExecutionInput {
	s.TranscodeAudio = v
	return s
}

// SetTranscodeVideo sets the TranscodeVideo field's value.
func (s *TemplateForStartExecutionInput) SetTranscodeVideo(v *TranscodeVideoForStartExecutionInput) *TemplateForStartExecutionInput {
	s.TranscodeVideo = v
	return s
}

// SetType sets the Type field's value.
func (s *TemplateForStartExecutionInput) SetType(v string) *TemplateForStartExecutionInput {
	s.Type = &v
	return s
}

type TranscodeAudioForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TranscodeAudioForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscodeAudioForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTemplateId sets the TemplateId field's value.
func (s *TranscodeAudioForStartExecutionInput) SetTemplateId(v string) *TranscodeAudioForStartExecutionInput {
	s.TemplateId = &v
	return s
}

type TranscodeVideoForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TemplateId *string `type:"string" json:",omitempty"`

	WatermarkTemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TranscodeVideoForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscodeVideoForStartExecutionInput) GoString() string {
	return s.String()
}

// SetTemplateId sets the TemplateId field's value.
func (s *TranscodeVideoForStartExecutionInput) SetTemplateId(v string) *TranscodeVideoForStartExecutionInput {
	s.TemplateId = &v
	return s
}

// SetWatermarkTemplateId sets the WatermarkTemplateId field's value.
func (s *TranscodeVideoForStartExecutionInput) SetWatermarkTemplateId(v string) *TranscodeVideoForStartExecutionInput {
	s.WatermarkTemplateId = &v
	return s
}

type VideoGenerationForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NewVid *bool `type:"boolean" json:",omitempty"`

	Prompt *string `type:"string" json:",omitempty"`

	VideoOption *VideoOptionForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s VideoGenerationForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoGenerationForStartExecutionInput) GoString() string {
	return s.String()
}

// SetNewVid sets the NewVid field's value.
func (s *VideoGenerationForStartExecutionInput) SetNewVid(v bool) *VideoGenerationForStartExecutionInput {
	s.NewVid = &v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *VideoGenerationForStartExecutionInput) SetPrompt(v string) *VideoGenerationForStartExecutionInput {
	s.Prompt = &v
	return s
}

// SetVideoOption sets the VideoOption field's value.
func (s *VideoGenerationForStartExecutionInput) SetVideoOption(v *VideoOptionForStartExecutionInput) *VideoGenerationForStartExecutionInput {
	s.VideoOption = v
	return s
}

type VideoOptionForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AspectRatio *string `type:"string" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	FixedCamera *bool `type:"boolean" json:",omitempty"`

	Fps *int32 `type:"int32" json:",omitempty"`

	Model *string `type:"string" json:",omitempty"`

	Resolution *string `type:"string" json:",omitempty"`

	Seed *string `type:"string" json:",omitempty"`

	Watermark *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s VideoOptionForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoOptionForStartExecutionInput) GoString() string {
	return s.String()
}

// SetAspectRatio sets the AspectRatio field's value.
func (s *VideoOptionForStartExecutionInput) SetAspectRatio(v string) *VideoOptionForStartExecutionInput {
	s.AspectRatio = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *VideoOptionForStartExecutionInput) SetDuration(v int32) *VideoOptionForStartExecutionInput {
	s.Duration = &v
	return s
}

// SetFixedCamera sets the FixedCamera field's value.
func (s *VideoOptionForStartExecutionInput) SetFixedCamera(v bool) *VideoOptionForStartExecutionInput {
	s.FixedCamera = &v
	return s
}

// SetFps sets the Fps field's value.
func (s *VideoOptionForStartExecutionInput) SetFps(v int32) *VideoOptionForStartExecutionInput {
	s.Fps = &v
	return s
}

// SetModel sets the Model field's value.
func (s *VideoOptionForStartExecutionInput) SetModel(v string) *VideoOptionForStartExecutionInput {
	s.Model = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *VideoOptionForStartExecutionInput) SetResolution(v string) *VideoOptionForStartExecutionInput {
	s.Resolution = &v
	return s
}

// SetSeed sets the Seed field's value.
func (s *VideoOptionForStartExecutionInput) SetSeed(v string) *VideoOptionForStartExecutionInput {
	s.Seed = &v
	return s
}

// SetWatermark sets the Watermark field's value.
func (s *VideoOptionForStartExecutionInput) SetWatermark(v bool) *VideoOptionForStartExecutionInput {
	s.Watermark = &v
	return s
}

type VideoSummaryForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BestSegmentDuration *int32 `type:"int32" json:",omitempty"`

	ExtraDescription *string `type:"string" json:",omitempty"`

	OnlyTimeline *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s VideoSummaryForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSummaryForStartExecutionInput) GoString() string {
	return s.String()
}

// SetBestSegmentDuration sets the BestSegmentDuration field's value.
func (s *VideoSummaryForStartExecutionInput) SetBestSegmentDuration(v int32) *VideoSummaryForStartExecutionInput {
	s.BestSegmentDuration = &v
	return s
}

// SetExtraDescription sets the ExtraDescription field's value.
func (s *VideoSummaryForStartExecutionInput) SetExtraDescription(v string) *VideoSummaryForStartExecutionInput {
	s.ExtraDescription = &v
	return s
}

// SetOnlyTimeline sets the OnlyTimeline field's value.
func (s *VideoSummaryForStartExecutionInput) SetOnlyTimeline(v bool) *VideoSummaryForStartExecutionInput {
	s.OnlyTimeline = &v
	return s
}

type VisionForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Model *ModelForStartExecutionInput `type:"structure" json:",omitempty"`

	Prompt *string `type:"string" json:",omitempty"`

	Segment *ConvertSegmentForStartExecutionInput `type:"structure" json:",omitempty"`

	SnapshotParam *SnapshotParamForStartExecutionInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s VisionForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VisionForStartExecutionInput) GoString() string {
	return s.String()
}

// SetModel sets the Model field's value.
func (s *VisionForStartExecutionInput) SetModel(v *ModelForStartExecutionInput) *VisionForStartExecutionInput {
	s.Model = v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *VisionForStartExecutionInput) SetPrompt(v string) *VisionForStartExecutionInput {
	s.Prompt = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *VisionForStartExecutionInput) SetSegment(v *ConvertSegmentForStartExecutionInput) *VisionForStartExecutionInput {
	s.Segment = v
	return s
}

// SetSnapshotParam sets the SnapshotParam field's value.
func (s *VisionForStartExecutionInput) SetSnapshotParam(v *SnapshotParamForStartExecutionInput) *VisionForStartExecutionInput {
	s.SnapshotParam = v
	return s
}

type WorkflowForStartExecutionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Nodes []*NodeForStartExecutionInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s WorkflowForStartExecutionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowForStartExecutionInput) GoString() string {
	return s.String()
}

// SetNodes sets the Nodes field's value.
func (s *WorkflowForStartExecutionInput) SetNodes(v []*NodeForStartExecutionInput) *WorkflowForStartExecutionInput {
	s.Nodes = v
	return s
}
