// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opNumberPoolListCommon = "NumberPoolList"

// NumberPoolListCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the NumberPoolListCommon operation. The "output" return
// value will be populated with the NumberPoolListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned NumberPoolListCommon Request to send the API call to the service.
// the "output" return value is not valid until after NumberPoolListCommon Send returns without error.
//
// See NumberPoolListCommon for more information on using the NumberPoolListCommon
// API call, and error handling.
//
//    // Example sending a request using the NumberPoolListCommonRequest method.
//    req, resp := client.NumberPoolListCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) NumberPoolListCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opNumberPoolListCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// NumberPoolListCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation NumberPoolListCommon for usage and error information.
func (c *VMS) NumberPoolListCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.NumberPoolListCommonRequest(input)
	return out, req.Send()
}

// NumberPoolListCommonWithContext is the same as NumberPoolListCommon with the addition of
// the ability to pass a context and additional request options.
//
// See NumberPoolListCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) NumberPoolListCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.NumberPoolListCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNumberPoolList = "NumberPoolList"

// NumberPoolListRequest generates a "volcengine/request.Request" representing the
// client's request for the NumberPoolList operation. The "output" return
// value will be populated with the NumberPoolListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned NumberPoolListCommon Request to send the API call to the service.
// the "output" return value is not valid until after NumberPoolListCommon Send returns without error.
//
// See NumberPoolList for more information on using the NumberPoolList
// API call, and error handling.
//
//    // Example sending a request using the NumberPoolListRequest method.
//    req, resp := client.NumberPoolListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) NumberPoolListRequest(input *NumberPoolListInput) (req *request.Request, output *NumberPoolListOutput) {
	op := &request.Operation{
		Name:       opNumberPoolList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NumberPoolListInput{}
	}

	output = &NumberPoolListOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// NumberPoolList API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation NumberPoolList for usage and error information.
func (c *VMS) NumberPoolList(input *NumberPoolListInput) (*NumberPoolListOutput, error) {
	req, out := c.NumberPoolListRequest(input)
	return out, req.Send()
}

// NumberPoolListWithContext is the same as NumberPoolList with the addition of
// the ability to pass a context and additional request options.
//
// See NumberPoolList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) NumberPoolListWithContext(ctx volcengine.Context, input *NumberPoolListInput, opts ...request.Option) (*NumberPoolListOutput, error) {
	req, out := c.NumberPoolListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type NumberPoolListInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Limit *int32 `type:"int32" json:",omitempty"`

	NumberPoolName *string `type:"string" json:",omitempty"`

	NumberPoolNo *string `type:"string" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	ServiceType *int32 `type:"int32" json:",omitempty"`

	SubServiceType *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s NumberPoolListInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberPoolListInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *NumberPoolListInput) SetLimit(v int32) *NumberPoolListInput {
	s.Limit = &v
	return s
}

// SetNumberPoolName sets the NumberPoolName field's value.
func (s *NumberPoolListInput) SetNumberPoolName(v string) *NumberPoolListInput {
	s.NumberPoolName = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *NumberPoolListInput) SetNumberPoolNo(v string) *NumberPoolListInput {
	s.NumberPoolNo = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *NumberPoolListInput) SetOffset(v int32) *NumberPoolListInput {
	s.Offset = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *NumberPoolListInput) SetServiceType(v int32) *NumberPoolListInput {
	s.ServiceType = &v
	return s
}

// SetSubServiceType sets the SubServiceType field's value.
func (s *NumberPoolListInput) SetSubServiceType(v int32) *NumberPoolListInput {
	s.SubServiceType = &v
	return s
}

type NumberPoolListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	Records []*RecordForNumberPoolListOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s NumberPoolListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberPoolListOutput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *NumberPoolListOutput) SetLimit(v int32) *NumberPoolListOutput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *NumberPoolListOutput) SetOffset(v int32) *NumberPoolListOutput {
	s.Offset = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *NumberPoolListOutput) SetRecords(v []*RecordForNumberPoolListOutput) *NumberPoolListOutput {
	s.Records = v
	return s
}

// SetTotal sets the Total field's value.
func (s *NumberPoolListOutput) SetTotal(v int32) *NumberPoolListOutput {
	s.Total = &v
	return s
}

type RecordForNumberPoolListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NumberCount *int32 `type:"int32" json:",omitempty"`

	NumberPoolName *string `type:"string" json:",omitempty"`

	NumberPoolNo *string `type:"string" json:",omitempty"`

	ServiceType *int32 `type:"int32" json:",omitempty"`

	ServiceTypeName *string `type:"string" json:",omitempty"`

	SubServiceType *int32 `type:"int32" json:",omitempty"`

	SubServiceTypeName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RecordForNumberPoolListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordForNumberPoolListOutput) GoString() string {
	return s.String()
}

// SetNumberCount sets the NumberCount field's value.
func (s *RecordForNumberPoolListOutput) SetNumberCount(v int32) *RecordForNumberPoolListOutput {
	s.NumberCount = &v
	return s
}

// SetNumberPoolName sets the NumberPoolName field's value.
func (s *RecordForNumberPoolListOutput) SetNumberPoolName(v string) *RecordForNumberPoolListOutput {
	s.NumberPoolName = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *RecordForNumberPoolListOutput) SetNumberPoolNo(v string) *RecordForNumberPoolListOutput {
	s.NumberPoolNo = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *RecordForNumberPoolListOutput) SetServiceType(v int32) *RecordForNumberPoolListOutput {
	s.ServiceType = &v
	return s
}

// SetServiceTypeName sets the ServiceTypeName field's value.
func (s *RecordForNumberPoolListOutput) SetServiceTypeName(v string) *RecordForNumberPoolListOutput {
	s.ServiceTypeName = &v
	return s
}

// SetSubServiceType sets the SubServiceType field's value.
func (s *RecordForNumberPoolListOutput) SetSubServiceType(v int32) *RecordForNumberPoolListOutput {
	s.SubServiceType = &v
	return s
}

// SetSubServiceTypeName sets the SubServiceTypeName field's value.
func (s *RecordForNumberPoolListOutput) SetSubServiceTypeName(v string) *RecordForNumberPoolListOutput {
	s.SubServiceTypeName = &v
	return s
}
