// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateTaskCommon = "CreateTask"

// CreateTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTaskCommon operation. The "output" return
// value will be populated with the CreateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTaskCommon Send returns without error.
//
// See CreateTaskCommon for more information on using the CreateTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateTaskCommonRequest method.
//    req, resp := client.CreateTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) CreateTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTaskCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation CreateTaskCommon for usage and error information.
func (c *VMS) CreateTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateTaskCommonRequest(input)
	return out, req.Send()
}

// CreateTaskCommonWithContext is the same as CreateTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) CreateTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTask = "CreateTask"

// CreateTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTask operation. The "output" return
// value will be populated with the CreateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTaskCommon Send returns without error.
//
// See CreateTask for more information on using the CreateTask
// API call, and error handling.
//
//    // Example sending a request using the CreateTaskRequest method.
//    req, resp := client.CreateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) CreateTaskRequest(input *CreateTaskInput) (req *request.Request, output *CreateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTaskInput{}
	}

	output = &CreateTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTask API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation CreateTask for usage and error information.
func (c *VMS) CreateTask(input *CreateTaskInput) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	return out, req.Send()
}

// CreateTaskWithContext is the same as CreateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) CreateTaskWithContext(ctx volcengine.Context, input *CreateTaskInput, opts ...request.Option) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioPostUrl *string `max:"512" type:"string" json:",omitempty"`

	CallRecordPostUrl *string `max:"512" type:"string" json:",omitempty"`

	// Concurrency is a required field
	Concurrency *int32 `type:"int32" json:",omitempty" required:"true"`

	// EndTime is a required field
	EndTime *string `type:"string" json:",omitempty" required:"true"`

	FinishWhenListEnd *bool `type:"boolean" json:",omitempty"`

	ForbidTimeList []*ForbidTimeListForCreateTaskInput `type:"list" json:",omitempty"`

	MaxRingDuration *int32 `type:"int32" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	NumberList []*string `type:"list" json:",omitempty"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	PhoneList []*PhoneListForCreateTaskInput `type:"list" json:",omitempty"`

	Resource *string `type:"string" json:",omitempty"`

	RingAgainInterval *int32 `type:"int32" json:",omitempty"`

	RingAgainTimes *int32 `type:"int32" json:",omitempty"`

	SelectNumberRule *int32 `type:"int32" json:",omitempty"`

	SelectNumberType *int32 `type:"int32" json:",omitempty"`

	SmsConfig []*SmsConfigForCreateTaskInput `type:"list" json:",omitempty"`

	Start *bool `type:"boolean" json:",omitempty"`

	// StartTime is a required field
	StartTime *string `type:"string" json:",omitempty" required:"true"`

	Type *int32 `type:"int32" json:",omitempty"`

	Unique *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskInput"}
	if s.AudioPostUrl != nil && len(*s.AudioPostUrl) > 512 {
		invalidParams.Add(request.NewErrParamMaxLen("AudioPostUrl", 512, *s.AudioPostUrl))
	}
	if s.CallRecordPostUrl != nil && len(*s.CallRecordPostUrl) > 512 {
		invalidParams.Add(request.NewErrParamMaxLen("CallRecordPostUrl", 512, *s.CallRecordPostUrl))
	}
	if s.Concurrency == nil {
		invalidParams.Add(request.NewErrParamRequired("Concurrency"))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.PhoneList != nil {
		for i, v := range s.PhoneList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhoneList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioPostUrl sets the AudioPostUrl field's value.
func (s *CreateTaskInput) SetAudioPostUrl(v string) *CreateTaskInput {
	s.AudioPostUrl = &v
	return s
}

// SetCallRecordPostUrl sets the CallRecordPostUrl field's value.
func (s *CreateTaskInput) SetCallRecordPostUrl(v string) *CreateTaskInput {
	s.CallRecordPostUrl = &v
	return s
}

// SetConcurrency sets the Concurrency field's value.
func (s *CreateTaskInput) SetConcurrency(v int32) *CreateTaskInput {
	s.Concurrency = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateTaskInput) SetEndTime(v string) *CreateTaskInput {
	s.EndTime = &v
	return s
}

// SetFinishWhenListEnd sets the FinishWhenListEnd field's value.
func (s *CreateTaskInput) SetFinishWhenListEnd(v bool) *CreateTaskInput {
	s.FinishWhenListEnd = &v
	return s
}

// SetForbidTimeList sets the ForbidTimeList field's value.
func (s *CreateTaskInput) SetForbidTimeList(v []*ForbidTimeListForCreateTaskInput) *CreateTaskInput {
	s.ForbidTimeList = v
	return s
}

// SetMaxRingDuration sets the MaxRingDuration field's value.
func (s *CreateTaskInput) SetMaxRingDuration(v int32) *CreateTaskInput {
	s.MaxRingDuration = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTaskInput) SetName(v string) *CreateTaskInput {
	s.Name = &v
	return s
}

// SetNumberList sets the NumberList field's value.
func (s *CreateTaskInput) SetNumberList(v []*string) *CreateTaskInput {
	s.NumberList = v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *CreateTaskInput) SetNumberPoolNo(v string) *CreateTaskInput {
	s.NumberPoolNo = &v
	return s
}

// SetPhoneList sets the PhoneList field's value.
func (s *CreateTaskInput) SetPhoneList(v []*PhoneListForCreateTaskInput) *CreateTaskInput {
	s.PhoneList = v
	return s
}

// SetResource sets the Resource field's value.
func (s *CreateTaskInput) SetResource(v string) *CreateTaskInput {
	s.Resource = &v
	return s
}

// SetRingAgainInterval sets the RingAgainInterval field's value.
func (s *CreateTaskInput) SetRingAgainInterval(v int32) *CreateTaskInput {
	s.RingAgainInterval = &v
	return s
}

// SetRingAgainTimes sets the RingAgainTimes field's value.
func (s *CreateTaskInput) SetRingAgainTimes(v int32) *CreateTaskInput {
	s.RingAgainTimes = &v
	return s
}

// SetSelectNumberRule sets the SelectNumberRule field's value.
func (s *CreateTaskInput) SetSelectNumberRule(v int32) *CreateTaskInput {
	s.SelectNumberRule = &v
	return s
}

// SetSelectNumberType sets the SelectNumberType field's value.
func (s *CreateTaskInput) SetSelectNumberType(v int32) *CreateTaskInput {
	s.SelectNumberType = &v
	return s
}

// SetSmsConfig sets the SmsConfig field's value.
func (s *CreateTaskInput) SetSmsConfig(v []*SmsConfigForCreateTaskInput) *CreateTaskInput {
	s.SmsConfig = v
	return s
}

// SetStart sets the Start field's value.
func (s *CreateTaskInput) SetStart(v bool) *CreateTaskInput {
	s.Start = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateTaskInput) SetStartTime(v string) *CreateTaskInput {
	s.StartTime = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTaskInput) SetType(v int32) *CreateTaskInput {
	s.Type = &v
	return s
}

// SetUnique sets the Unique field's value.
func (s *CreateTaskInput) SetUnique(v bool) *CreateTaskInput {
	s.Unique = &v
	return s
}

type CreateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	FailList []*FailListForCreateTaskOutput `type:"list" json:",omitempty"`

	TaskOpenId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskOutput) GoString() string {
	return s.String()
}

// SetFailList sets the FailList field's value.
func (s *CreateTaskOutput) SetFailList(v []*FailListForCreateTaskOutput) *CreateTaskOutput {
	s.FailList = v
	return s
}

// SetTaskOpenId sets the TaskOpenId field's value.
func (s *CreateTaskOutput) SetTaskOpenId(v string) *CreateTaskOutput {
	s.TaskOpenId = &v
	return s
}

type FailListForCreateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Desc *string `type:"string" json:",omitempty"`

	Index *int32 `type:"int32" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FailListForCreateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FailListForCreateTaskOutput) GoString() string {
	return s.String()
}

// SetDesc sets the Desc field's value.
func (s *FailListForCreateTaskOutput) SetDesc(v string) *FailListForCreateTaskOutput {
	s.Desc = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *FailListForCreateTaskOutput) SetIndex(v int32) *FailListForCreateTaskOutput {
	s.Index = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *FailListForCreateTaskOutput) SetPhone(v string) *FailListForCreateTaskOutput {
	s.Phone = &v
	return s
}

// SetType sets the Type field's value.
func (s *FailListForCreateTaskOutput) SetType(v string) *FailListForCreateTaskOutput {
	s.Type = &v
	return s
}

type ForbidTimeListForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Times []*string `type:"list" json:",omitempty"`

	Weekdays []*int32 `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ForbidTimeListForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbidTimeListForCreateTaskInput) GoString() string {
	return s.String()
}

// SetTimes sets the Times field's value.
func (s *ForbidTimeListForCreateTaskInput) SetTimes(v []*string) *ForbidTimeListForCreateTaskInput {
	s.Times = v
	return s
}

// SetWeekdays sets the Weekdays field's value.
func (s *ForbidTimeListForCreateTaskInput) SetWeekdays(v []*int32) *ForbidTimeListForCreateTaskInput {
	s.Weekdays = v
	return s
}

type PhoneListForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Ext *string `max:"255" type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	PhoneParamJson *string `type:"string" json:",omitempty"`

	SmsParamJson *string `type:"string" json:",omitempty"`

	TtsContent *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PhoneListForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneListForCreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneListForCreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneListForCreateTaskInput"}
	if s.Ext != nil && len(*s.Ext) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Ext", 255, *s.Ext))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExt sets the Ext field's value.
func (s *PhoneListForCreateTaskInput) SetExt(v string) *PhoneListForCreateTaskInput {
	s.Ext = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *PhoneListForCreateTaskInput) SetPhone(v string) *PhoneListForCreateTaskInput {
	s.Phone = &v
	return s
}

// SetPhoneParamJson sets the PhoneParamJson field's value.
func (s *PhoneListForCreateTaskInput) SetPhoneParamJson(v string) *PhoneListForCreateTaskInput {
	s.PhoneParamJson = &v
	return s
}

// SetSmsParamJson sets the SmsParamJson field's value.
func (s *PhoneListForCreateTaskInput) SetSmsParamJson(v string) *PhoneListForCreateTaskInput {
	s.SmsParamJson = &v
	return s
}

// SetTtsContent sets the TtsContent field's value.
func (s *PhoneListForCreateTaskInput) SetTtsContent(v string) *PhoneListForCreateTaskInput {
	s.TtsContent = &v
	return s
}

type SmsConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Sign *string `type:"string" json:",omitempty"`

	StatusSet []*int32 `type:"list" json:",omitempty"`

	TemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SmsConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SmsConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetSign sets the Sign field's value.
func (s *SmsConfigForCreateTaskInput) SetSign(v string) *SmsConfigForCreateTaskInput {
	s.Sign = &v
	return s
}

// SetStatusSet sets the StatusSet field's value.
func (s *SmsConfigForCreateTaskInput) SetStatusSet(v []*int32) *SmsConfigForCreateTaskInput {
	s.StatusSet = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *SmsConfigForCreateTaskInput) SetTemplateId(v string) *SmsConfigForCreateTaskInput {
	s.TemplateId = &v
	return s
}
