// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBindAXYBCommon = "BindAXYB"

// BindAXYBCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXYBCommon operation. The "output" return
// value will be populated with the BindAXYBCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXYBCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXYBCommon Send returns without error.
//
// See BindAXYBCommon for more information on using the BindAXYBCommon
// API call, and error handling.
//
//    // Example sending a request using the BindAXYBCommonRequest method.
//    req, resp := client.BindAXYBCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXYBCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBindAXYBCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXYBCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXYBCommon for usage and error information.
func (c *VMS) BindAXYBCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BindAXYBCommonRequest(input)
	return out, req.Send()
}

// BindAXYBCommonWithContext is the same as BindAXYBCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXYBCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXYBCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BindAXYBCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBindAXYB = "BindAXYB"

// BindAXYBRequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXYB operation. The "output" return
// value will be populated with the BindAXYBCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXYBCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXYBCommon Send returns without error.
//
// See BindAXYB for more information on using the BindAXYB
// API call, and error handling.
//
//    // Example sending a request using the BindAXYBRequest method.
//    req, resp := client.BindAXYBRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXYBRequest(input *BindAXYBInput) (req *request.Request, output *BindAXYBOutput) {
	op := &request.Operation{
		Name:       opBindAXYB,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BindAXYBInput{}
	}

	output = &BindAXYBOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXYB API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXYB for usage and error information.
func (c *VMS) BindAXYB(input *BindAXYBInput) (*BindAXYBOutput, error) {
	req, out := c.BindAXYBRequest(input)
	return out, req.Send()
}

// BindAXYBWithContext is the same as BindAXYB with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXYB for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXYBWithContext(ctx volcengine.Context, input *BindAXYBInput, opts ...request.Option) (*BindAXYBOutput, error) {
	req, out := c.BindAXYBRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BindAXYBInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	AutoCreateFlag *int32 `type:"int32" json:",omitempty"`

	CityCode *string `type:"string" json:",omitempty"`

	CityCodeByPhoneNo *string `type:"string" json:",omitempty" enum:"EnumOfCityCodeByPhoneNoForBindAXYBInput"`

	DegradeCityList []*string `type:"list" json:",omitempty"`

	// ExpireTime is a required field
	ExpireTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// NumberPoolNoY is a required field
	NumberPoolNoY *string `type:"string" json:",omitempty" required:"true"`

	// PhoneNoA is a required field
	PhoneNoA *string `type:"string" json:",omitempty" required:"true"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	PhoneNoX *string `type:"string" json:",omitempty"`

	PhoneNoY *string `type:"string" json:",omitempty"`

	RandomFlag *int32 `type:"int32" json:",omitempty"`

	RandomFlagY *int32 `type:"int32" json:",omitempty"`

	UserData *string `max:"2048" type:"string" json:",omitempty"`

	YCityCode *string `type:"string" json:",omitempty"`

	YCityCodeByPhoneNo *string `type:"string" json:",omitempty" enum:"EnumOfYCityCodeByPhoneNoForBindAXYBInput"`

	YDegradeCityList []*string `type:"list" json:",omitempty"`

	YbAudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	// YbEnableDuration is a required field
	YbEnableDuration *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s BindAXYBInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXYBInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BindAXYBInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BindAXYBInput"}
	if s.ExpireTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpireTime"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.NumberPoolNoY == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNoY"))
	}
	if s.PhoneNoA == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoA"))
	}
	if s.UserData != nil && len(*s.UserData) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("UserData", 2048, *s.UserData))
	}
	if s.YbEnableDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("YbEnableDuration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRecordFlag sets the AudioRecordFlag field's value.
func (s *BindAXYBInput) SetAudioRecordFlag(v int32) *BindAXYBInput {
	s.AudioRecordFlag = &v
	return s
}

// SetAutoCreateFlag sets the AutoCreateFlag field's value.
func (s *BindAXYBInput) SetAutoCreateFlag(v int32) *BindAXYBInput {
	s.AutoCreateFlag = &v
	return s
}

// SetCityCode sets the CityCode field's value.
func (s *BindAXYBInput) SetCityCode(v string) *BindAXYBInput {
	s.CityCode = &v
	return s
}

// SetCityCodeByPhoneNo sets the CityCodeByPhoneNo field's value.
func (s *BindAXYBInput) SetCityCodeByPhoneNo(v string) *BindAXYBInput {
	s.CityCodeByPhoneNo = &v
	return s
}

// SetDegradeCityList sets the DegradeCityList field's value.
func (s *BindAXYBInput) SetDegradeCityList(v []*string) *BindAXYBInput {
	s.DegradeCityList = v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *BindAXYBInput) SetExpireTime(v int64) *BindAXYBInput {
	s.ExpireTime = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *BindAXYBInput) SetNumberPoolNo(v string) *BindAXYBInput {
	s.NumberPoolNo = &v
	return s
}

// SetNumberPoolNoY sets the NumberPoolNoY field's value.
func (s *BindAXYBInput) SetNumberPoolNoY(v string) *BindAXYBInput {
	s.NumberPoolNoY = &v
	return s
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *BindAXYBInput) SetPhoneNoA(v string) *BindAXYBInput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindAXYBInput) SetPhoneNoB(v string) *BindAXYBInput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXYBInput) SetPhoneNoX(v string) *BindAXYBInput {
	s.PhoneNoX = &v
	return s
}

// SetPhoneNoY sets the PhoneNoY field's value.
func (s *BindAXYBInput) SetPhoneNoY(v string) *BindAXYBInput {
	s.PhoneNoY = &v
	return s
}

// SetRandomFlag sets the RandomFlag field's value.
func (s *BindAXYBInput) SetRandomFlag(v int32) *BindAXYBInput {
	s.RandomFlag = &v
	return s
}

// SetRandomFlagY sets the RandomFlagY field's value.
func (s *BindAXYBInput) SetRandomFlagY(v int32) *BindAXYBInput {
	s.RandomFlagY = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *BindAXYBInput) SetUserData(v string) *BindAXYBInput {
	s.UserData = &v
	return s
}

// SetYCityCode sets the YCityCode field's value.
func (s *BindAXYBInput) SetYCityCode(v string) *BindAXYBInput {
	s.YCityCode = &v
	return s
}

// SetYCityCodeByPhoneNo sets the YCityCodeByPhoneNo field's value.
func (s *BindAXYBInput) SetYCityCodeByPhoneNo(v string) *BindAXYBInput {
	s.YCityCodeByPhoneNo = &v
	return s
}

// SetYDegradeCityList sets the YDegradeCityList field's value.
func (s *BindAXYBInput) SetYDegradeCityList(v []*string) *BindAXYBInput {
	s.YDegradeCityList = v
	return s
}

// SetYbAudioRecordFlag sets the YbAudioRecordFlag field's value.
func (s *BindAXYBInput) SetYbAudioRecordFlag(v int32) *BindAXYBInput {
	s.YbAudioRecordFlag = &v
	return s
}

// SetYbEnableDuration sets the YbEnableDuration field's value.
func (s *BindAXYBInput) SetYbEnableDuration(v int32) *BindAXYBInput {
	s.YbEnableDuration = &v
	return s
}

type BindAXYBOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PhoneNoX *string `type:"string" json:",omitempty"`

	PhoneNoY *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubId *string `type:"string" json:",omitempty"`

	YbStatus *int32 `type:"int32" json:",omitempty"`

	YbSubId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindAXYBOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXYBOutput) GoString() string {
	return s.String()
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXYBOutput) SetPhoneNoX(v string) *BindAXYBOutput {
	s.PhoneNoX = &v
	return s
}

// SetPhoneNoY sets the PhoneNoY field's value.
func (s *BindAXYBOutput) SetPhoneNoY(v string) *BindAXYBOutput {
	s.PhoneNoY = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BindAXYBOutput) SetStatus(v int32) *BindAXYBOutput {
	s.Status = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *BindAXYBOutput) SetSubId(v string) *BindAXYBOutput {
	s.SubId = &v
	return s
}

// SetYbStatus sets the YbStatus field's value.
func (s *BindAXYBOutput) SetYbStatus(v int32) *BindAXYBOutput {
	s.YbStatus = &v
	return s
}

// SetYbSubId sets the YbSubId field's value.
func (s *BindAXYBOutput) SetYbSubId(v string) *BindAXYBOutput {
	s.YbSubId = &v
	return s
}

const (
	// EnumOfCityCodeByPhoneNoForBindAXYBInputA is a EnumOfCityCodeByPhoneNoForBindAXYBInput enum value
	EnumOfCityCodeByPhoneNoForBindAXYBInputA = "A"

	// EnumOfCityCodeByPhoneNoForBindAXYBInputB is a EnumOfCityCodeByPhoneNoForBindAXYBInput enum value
	EnumOfCityCodeByPhoneNoForBindAXYBInputB = "B"
)

const (
	// EnumOfYCityCodeByPhoneNoForBindAXYBInputA is a EnumOfYCityCodeByPhoneNoForBindAXYBInput enum value
	EnumOfYCityCodeByPhoneNoForBindAXYBInputA = "A"

	// EnumOfYCityCodeByPhoneNoForBindAXYBInputB is a EnumOfYCityCodeByPhoneNoForBindAXYBInput enum value
	EnumOfYCityCodeByPhoneNoForBindAXYBInputB = "B"
)
