// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBindAXNCommon = "BindAXN"

// BindAXNCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXNCommon operation. The "output" return
// value will be populated with the BindAXNCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXNCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXNCommon Send returns without error.
//
// See BindAXNCommon for more information on using the BindAXNCommon
// API call, and error handling.
//
//    // Example sending a request using the BindAXNCommonRequest method.
//    req, resp := client.BindAXNCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXNCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBindAXNCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXNCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXNCommon for usage and error information.
func (c *VMS) BindAXNCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BindAXNCommonRequest(input)
	return out, req.Send()
}

// BindAXNCommonWithContext is the same as BindAXNCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXNCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXNCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BindAXNCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBindAXN = "BindAXN"

// BindAXNRequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXN operation. The "output" return
// value will be populated with the BindAXNCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXNCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXNCommon Send returns without error.
//
// See BindAXN for more information on using the BindAXN
// API call, and error handling.
//
//    // Example sending a request using the BindAXNRequest method.
//    req, resp := client.BindAXNRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXNRequest(input *BindAXNInput) (req *request.Request, output *BindAXNOutput) {
	op := &request.Operation{
		Name:       opBindAXN,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BindAXNInput{}
	}

	output = &BindAXNOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXN API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXN for usage and error information.
func (c *VMS) BindAXN(input *BindAXNInput) (*BindAXNOutput, error) {
	req, out := c.BindAXNRequest(input)
	return out, req.Send()
}

// BindAXNWithContext is the same as BindAXN with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXN for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXNWithContext(ctx volcengine.Context, input *BindAXNInput, opts ...request.Option) (*BindAXNOutput, error) {
	req, out := c.BindAXNRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BindAXNInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	// ExpireTime is a required field
	ExpireTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// PhoneNoA is a required field
	PhoneNoA *string `type:"string" json:",omitempty" required:"true"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	// PhoneNoX is a required field
	PhoneNoX *string `type:"string" json:",omitempty" required:"true"`

	UserData *string `max:"2048" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindAXNInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXNInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BindAXNInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BindAXNInput"}
	if s.ExpireTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpireTime"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.PhoneNoA == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoA"))
	}
	if s.PhoneNoX == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoX"))
	}
	if s.UserData != nil && len(*s.UserData) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("UserData", 2048, *s.UserData))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRecordFlag sets the AudioRecordFlag field's value.
func (s *BindAXNInput) SetAudioRecordFlag(v int32) *BindAXNInput {
	s.AudioRecordFlag = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *BindAXNInput) SetExpireTime(v int64) *BindAXNInput {
	s.ExpireTime = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *BindAXNInput) SetNumberPoolNo(v string) *BindAXNInput {
	s.NumberPoolNo = &v
	return s
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *BindAXNInput) SetPhoneNoA(v string) *BindAXNInput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindAXNInput) SetPhoneNoB(v string) *BindAXNInput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXNInput) SetPhoneNoX(v string) *BindAXNInput {
	s.PhoneNoX = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *BindAXNInput) SetUserData(v string) *BindAXNInput {
	s.UserData = &v
	return s
}

type BindAXNOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PhoneNoA *string `type:"string" json:",omitempty"`

	PhoneNoACityCode *string `type:"string" json:",omitempty"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	PhoneNoBCityCode *string `type:"string" json:",omitempty"`

	PhoneNoX *string `type:"string" json:",omitempty"`

	PhoneNoXCityCode *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindAXNOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXNOutput) GoString() string {
	return s.String()
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *BindAXNOutput) SetPhoneNoA(v string) *BindAXNOutput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoACityCode sets the PhoneNoACityCode field's value.
func (s *BindAXNOutput) SetPhoneNoACityCode(v string) *BindAXNOutput {
	s.PhoneNoACityCode = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindAXNOutput) SetPhoneNoB(v string) *BindAXNOutput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoBCityCode sets the PhoneNoBCityCode field's value.
func (s *BindAXNOutput) SetPhoneNoBCityCode(v string) *BindAXNOutput {
	s.PhoneNoBCityCode = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXNOutput) SetPhoneNoX(v string) *BindAXNOutput {
	s.PhoneNoX = &v
	return s
}

// SetPhoneNoXCityCode sets the PhoneNoXCityCode field's value.
func (s *BindAXNOutput) SetPhoneNoXCityCode(v string) *BindAXNOutput {
	s.PhoneNoXCityCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BindAXNOutput) SetStatus(v int32) *BindAXNOutput {
	s.Status = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *BindAXNOutput) SetSubId(v string) *BindAXNOutput {
	s.SubId = &v
	return s
}
