// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vmp

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetAlertCommon = "GetAlert"

// GetAlertCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetAlertCommon operation. The "output" return
// value will be populated with the GetAlertCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetAlertCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetAlertCommon Send returns without error.
//
// See GetAlertCommon for more information on using the GetAlertCommon
// API call, and error handling.
//
//    // Example sending a request using the GetAlertCommonRequest method.
//    req, resp := client.GetAlertCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMP) GetAlertCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetAlertCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetAlertCommon API operation for VMP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMP's
// API operation GetAlertCommon for usage and error information.
func (c *VMP) GetAlertCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetAlertCommonRequest(input)
	return out, req.Send()
}

// GetAlertCommonWithContext is the same as GetAlertCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlertCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMP) GetAlertCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetAlertCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAlert = "GetAlert"

// GetAlertRequest generates a "volcengine/request.Request" representing the
// client's request for the GetAlert operation. The "output" return
// value will be populated with the GetAlertCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetAlertCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetAlertCommon Send returns without error.
//
// See GetAlert for more information on using the GetAlert
// API call, and error handling.
//
//    // Example sending a request using the GetAlertRequest method.
//    req, resp := client.GetAlertRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMP) GetAlertRequest(input *GetAlertInput) (req *request.Request, output *GetAlertOutput) {
	op := &request.Operation{
		Name:       opGetAlert,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAlertInput{}
	}

	output = &GetAlertOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetAlert API operation for VMP.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMP's
// API operation GetAlert for usage and error information.
func (c *VMP) GetAlert(input *GetAlertInput) (*GetAlertOutput, error) {
	req, out := c.GetAlertRequest(input)
	return out, req.Send()
}

// GetAlertWithContext is the same as GetAlert with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlert for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMP) GetAlertWithContext(ctx volcengine.Context, input *GetAlertInput, opts ...request.Option) (*GetAlertOutput, error) {
	req, out := c.GetAlertRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AlertingRuleQueryForGetAlertOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PromQL *string `type:"string" json:",omitempty"`

	WorkspaceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AlertingRuleQueryForGetAlertOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AlertingRuleQueryForGetAlertOutput) GoString() string {
	return s.String()
}

// SetPromQL sets the PromQL field's value.
func (s *AlertingRuleQueryForGetAlertOutput) SetPromQL(v string) *AlertingRuleQueryForGetAlertOutput {
	s.PromQL = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *AlertingRuleQueryForGetAlertOutput) SetWorkspaceId(v string) *AlertingRuleQueryForGetAlertOutput {
	s.WorkspaceId = &v
	return s
}

type GetAlertInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetAlertInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAlertInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAlertInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAlertInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetAlertInput) SetId(v string) *GetAlertInput {
	s.Id = &v
	return s
}

type GetAlertOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AlertingRuleId *string `type:"string" json:",omitempty"`

	AlertingRuleQuery *AlertingRuleQueryForGetAlertOutput `type:"structure" json:",omitempty"`

	AlertingRuleType *string `type:"string" json:",omitempty"`

	CurrentLevel *string `type:"string" json:",omitempty"`

	CurrentPhase *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	InitialAlertTimestamp *string `type:"string" json:",omitempty"`

	LastAlertTimestamp *string `type:"string" json:",omitempty"`

	Levels []*LevelForGetAlertOutput `type:"list" json:",omitempty"`

	ResolveTimestamp *string `type:"string" json:",omitempty"`

	Resource *ResourceForGetAlertOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetAlertOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAlertOutput) GoString() string {
	return s.String()
}

// SetAlertingRuleId sets the AlertingRuleId field's value.
func (s *GetAlertOutput) SetAlertingRuleId(v string) *GetAlertOutput {
	s.AlertingRuleId = &v
	return s
}

// SetAlertingRuleQuery sets the AlertingRuleQuery field's value.
func (s *GetAlertOutput) SetAlertingRuleQuery(v *AlertingRuleQueryForGetAlertOutput) *GetAlertOutput {
	s.AlertingRuleQuery = v
	return s
}

// SetAlertingRuleType sets the AlertingRuleType field's value.
func (s *GetAlertOutput) SetAlertingRuleType(v string) *GetAlertOutput {
	s.AlertingRuleType = &v
	return s
}

// SetCurrentLevel sets the CurrentLevel field's value.
func (s *GetAlertOutput) SetCurrentLevel(v string) *GetAlertOutput {
	s.CurrentLevel = &v
	return s
}

// SetCurrentPhase sets the CurrentPhase field's value.
func (s *GetAlertOutput) SetCurrentPhase(v string) *GetAlertOutput {
	s.CurrentPhase = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAlertOutput) SetId(v string) *GetAlertOutput {
	s.Id = &v
	return s
}

// SetInitialAlertTimestamp sets the InitialAlertTimestamp field's value.
func (s *GetAlertOutput) SetInitialAlertTimestamp(v string) *GetAlertOutput {
	s.InitialAlertTimestamp = &v
	return s
}

// SetLastAlertTimestamp sets the LastAlertTimestamp field's value.
func (s *GetAlertOutput) SetLastAlertTimestamp(v string) *GetAlertOutput {
	s.LastAlertTimestamp = &v
	return s
}

// SetLevels sets the Levels field's value.
func (s *GetAlertOutput) SetLevels(v []*LevelForGetAlertOutput) *GetAlertOutput {
	s.Levels = v
	return s
}

// SetResolveTimestamp sets the ResolveTimestamp field's value.
func (s *GetAlertOutput) SetResolveTimestamp(v string) *GetAlertOutput {
	s.ResolveTimestamp = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *GetAlertOutput) SetResource(v *ResourceForGetAlertOutput) *GetAlertOutput {
	s.Resource = v
	return s
}

type LabelForGetAlertOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LabelForGetAlertOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForGetAlertOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForGetAlertOutput) SetKey(v string) *LabelForGetAlertOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LabelForGetAlertOutput) SetValue(v string) *LabelForGetAlertOutput {
	s.Value = &v
	return s
}

type LevelForGetAlertOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Comparator *string `type:"string" json:",omitempty"`

	For *string `type:"string" json:",omitempty"`

	Level *string `type:"string" json:",omitempty"`

	Threshold *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s LevelForGetAlertOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LevelForGetAlertOutput) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *LevelForGetAlertOutput) SetComparator(v string) *LevelForGetAlertOutput {
	s.Comparator = &v
	return s
}

// SetFor sets the For field's value.
func (s *LevelForGetAlertOutput) SetFor(v string) *LevelForGetAlertOutput {
	s.For = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *LevelForGetAlertOutput) SetLevel(v string) *LevelForGetAlertOutput {
	s.Level = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *LevelForGetAlertOutput) SetThreshold(v float64) *LevelForGetAlertOutput {
	s.Threshold = &v
	return s
}

type ResourceForGetAlertOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Labels []*LabelForGetAlertOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForGetAlertOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForGetAlertOutput) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *ResourceForGetAlertOutput) SetLabels(v []*LabelForGetAlertOutput) *ResourceForGetAlertOutput {
	s.Labels = v
	return s
}
