// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateNodePoolConfigCommon = "UpdateNodePoolConfig"

// UpdateNodePoolConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateNodePoolConfigCommon operation. The "output" return
// value will be populated with the UpdateNodePoolConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNodePoolConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNodePoolConfigCommon Send returns without error.
//
// See UpdateNodePoolConfigCommon for more information on using the UpdateNodePoolConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateNodePoolConfigCommonRequest method.
//    req, resp := client.UpdateNodePoolConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) UpdateNodePoolConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateNodePoolConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNodePoolConfigCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation UpdateNodePoolConfigCommon for usage and error information.
func (c *VKE) UpdateNodePoolConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateNodePoolConfigCommonRequest(input)
	return out, req.Send()
}

// UpdateNodePoolConfigCommonWithContext is the same as UpdateNodePoolConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodePoolConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) UpdateNodePoolConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateNodePoolConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodePoolConfig = "UpdateNodePoolConfig"

// UpdateNodePoolConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateNodePoolConfig operation. The "output" return
// value will be populated with the UpdateNodePoolConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNodePoolConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNodePoolConfigCommon Send returns without error.
//
// See UpdateNodePoolConfig for more information on using the UpdateNodePoolConfig
// API call, and error handling.
//
//    // Example sending a request using the UpdateNodePoolConfigRequest method.
//    req, resp := client.UpdateNodePoolConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) UpdateNodePoolConfigRequest(input *UpdateNodePoolConfigInput) (req *request.Request, output *UpdateNodePoolConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNodePoolConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNodePoolConfigInput{}
	}

	output = &UpdateNodePoolConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNodePoolConfig API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation UpdateNodePoolConfig for usage and error information.
func (c *VKE) UpdateNodePoolConfig(input *UpdateNodePoolConfigInput) (*UpdateNodePoolConfigOutput, error) {
	req, out := c.UpdateNodePoolConfigRequest(input)
	return out, req.Send()
}

// UpdateNodePoolConfigWithContext is the same as UpdateNodePoolConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodePoolConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) UpdateNodePoolConfigWithContext(ctx volcengine.Context, input *UpdateNodePoolConfigInput, opts ...request.Option) (*UpdateNodePoolConfigOutput, error) {
	req, out := c.UpdateNodePoolConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AutoScalingForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DesiredReplicas *int32 `type:"int32" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	MaxReplicas *int32 `type:"int32" json:",omitempty"`

	MinReplicas *int32 `type:"int32" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	SubnetPolicy *string `type:"string" json:",omitempty" enum:"EnumOfSubnetPolicyForUpdateNodePoolConfigInput"`
}

// String returns the string representation
func (s AutoScalingForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetDesiredReplicas sets the DesiredReplicas field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetDesiredReplicas(v int32) *AutoScalingForUpdateNodePoolConfigInput {
	s.DesiredReplicas = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetEnabled(v bool) *AutoScalingForUpdateNodePoolConfigInput {
	s.Enabled = &v
	return s
}

// SetMaxReplicas sets the MaxReplicas field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetMaxReplicas(v int32) *AutoScalingForUpdateNodePoolConfigInput {
	s.MaxReplicas = &v
	return s
}

// SetMinReplicas sets the MinReplicas field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetMinReplicas(v int32) *AutoScalingForUpdateNodePoolConfigInput {
	s.MinReplicas = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetPriority(v int32) *AutoScalingForUpdateNodePoolConfigInput {
	s.Priority = &v
	return s
}

// SetSubnetPolicy sets the SubnetPolicy field's value.
func (s *AutoScalingForUpdateNodePoolConfigInput) SetSubnetPolicy(v string) *AutoScalingForUpdateNodePoolConfigInput {
	s.SubnetPolicy = &v
	return s
}

type DataVolumeForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystem *string `type:"string" json:",omitempty" enum:"EnumOfFileSystemForUpdateNodePoolConfigInput"`

	MountPoint *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	SnapshotId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForUpdateNodePoolConfigInput"`
}

// String returns the string representation
func (s DataVolumeForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataVolumeForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *DataVolumeForUpdateNodePoolConfigInput) SetFileSystem(v string) *DataVolumeForUpdateNodePoolConfigInput {
	s.FileSystem = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *DataVolumeForUpdateNodePoolConfigInput) SetMountPoint(v string) *DataVolumeForUpdateNodePoolConfigInput {
	s.MountPoint = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DataVolumeForUpdateNodePoolConfigInput) SetSize(v int32) *DataVolumeForUpdateNodePoolConfigInput {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *DataVolumeForUpdateNodePoolConfigInput) SetSnapshotId(v string) *DataVolumeForUpdateNodePoolConfigInput {
	s.SnapshotId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataVolumeForUpdateNodePoolConfigInput) SetType(v string) *DataVolumeForUpdateNodePoolConfigInput {
	s.Type = &v
	return s
}

type EvictionHardForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s EvictionHardForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EvictionHardForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

type FeatureGatesForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	QoSResourceManager *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s FeatureGatesForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureGatesForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetQoSResourceManager sets the QoSResourceManager field's value.
func (s *FeatureGatesForUpdateNodePoolConfigInput) SetQoSResourceManager(v bool) *FeatureGatesForUpdateNodePoolConfigInput {
	s.QoSResourceManager = &v
	return s
}

type KubeletConfigForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EvictionHard []*EvictionHardForUpdateNodePoolConfigInput `type:"list" json:",omitempty"`

	FeatureGates *FeatureGatesForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	KubeApiBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	KubeApiQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	RegistryBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	RegistryPullQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	SerializeImagePulls *bool `type:"boolean" json:",omitempty"`

	TopologyManagerPolicy *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInput"`

	TopologyManagerScope *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerScopeForUpdateNodePoolConfigInput"`
}

// String returns the string representation
func (s KubeletConfigForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubeletConfigForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KubeletConfigForUpdateNodePoolConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KubeletConfigForUpdateNodePoolConfigInput"}
	if s.KubeApiBurst != nil && *s.KubeApiBurst < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KubeApiBurst", 1))
	}
	if s.KubeApiBurst != nil && *s.KubeApiBurst > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("KubeApiBurst", 100))
	}
	if s.KubeApiQps != nil && *s.KubeApiQps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KubeApiQps", 1))
	}
	if s.KubeApiQps != nil && *s.KubeApiQps > 50 {
		invalidParams.Add(request.NewErrParamMaxValue("KubeApiQps", 50))
	}
	if s.RegistryBurst != nil && *s.RegistryBurst < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistryBurst", 1))
	}
	if s.RegistryBurst != nil && *s.RegistryBurst > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("RegistryBurst", 100))
	}
	if s.RegistryPullQps != nil && *s.RegistryPullQps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistryPullQps", 1))
	}
	if s.RegistryPullQps != nil && *s.RegistryPullQps > 50 {
		invalidParams.Add(request.NewErrParamMaxValue("RegistryPullQps", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvictionHard sets the EvictionHard field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetEvictionHard(v []*EvictionHardForUpdateNodePoolConfigInput) *KubeletConfigForUpdateNodePoolConfigInput {
	s.EvictionHard = v
	return s
}

// SetFeatureGates sets the FeatureGates field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetFeatureGates(v *FeatureGatesForUpdateNodePoolConfigInput) *KubeletConfigForUpdateNodePoolConfigInput {
	s.FeatureGates = v
	return s
}

// SetKubeApiBurst sets the KubeApiBurst field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetKubeApiBurst(v int32) *KubeletConfigForUpdateNodePoolConfigInput {
	s.KubeApiBurst = &v
	return s
}

// SetKubeApiQps sets the KubeApiQps field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetKubeApiQps(v int32) *KubeletConfigForUpdateNodePoolConfigInput {
	s.KubeApiQps = &v
	return s
}

// SetRegistryBurst sets the RegistryBurst field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetRegistryBurst(v int32) *KubeletConfigForUpdateNodePoolConfigInput {
	s.RegistryBurst = &v
	return s
}

// SetRegistryPullQps sets the RegistryPullQps field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetRegistryPullQps(v int32) *KubeletConfigForUpdateNodePoolConfigInput {
	s.RegistryPullQps = &v
	return s
}

// SetSerializeImagePulls sets the SerializeImagePulls field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetSerializeImagePulls(v bool) *KubeletConfigForUpdateNodePoolConfigInput {
	s.SerializeImagePulls = &v
	return s
}

// SetTopologyManagerPolicy sets the TopologyManagerPolicy field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetTopologyManagerPolicy(v string) *KubeletConfigForUpdateNodePoolConfigInput {
	s.TopologyManagerPolicy = &v
	return s
}

// SetTopologyManagerScope sets the TopologyManagerScope field's value.
func (s *KubeletConfigForUpdateNodePoolConfigInput) SetTopologyManagerScope(v string) *KubeletConfigForUpdateNodePoolConfigInput {
	s.TopologyManagerScope = &v
	return s
}

type KubernetesConfigForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoSyncDisabled *bool `type:"boolean" json:",omitempty"`

	Cordon *bool `type:"boolean" json:",omitempty"`

	KubeletConfig *KubeletConfigForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	Labels []*LabelForUpdateNodePoolConfigInput `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Taints []*TaintForUpdateNodePoolConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s KubernetesConfigForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesConfigForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KubernetesConfigForUpdateNodePoolConfigInput"}
	if s.KubeletConfig != nil {
		if err := s.KubeletConfig.Validate(); err != nil {
			invalidParams.AddNested("KubeletConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoSyncDisabled sets the AutoSyncDisabled field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetAutoSyncDisabled(v bool) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.AutoSyncDisabled = &v
	return s
}

// SetCordon sets the Cordon field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetCordon(v bool) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.Cordon = &v
	return s
}

// SetKubeletConfig sets the KubeletConfig field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetKubeletConfig(v *KubeletConfigForUpdateNodePoolConfigInput) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.KubeletConfig = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetLabels(v []*LabelForUpdateNodePoolConfigInput) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.Labels = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetNamePrefix(v string) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.NamePrefix = &v
	return s
}

// SetTaints sets the Taints field's value.
func (s *KubernetesConfigForUpdateNodePoolConfigInput) SetTaints(v []*TaintForUpdateNodePoolConfigInput) *KubernetesConfigForUpdateNodePoolConfigInput {
	s.Taints = v
	return s
}

type LabelForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LabelForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForUpdateNodePoolConfigInput) SetKey(v string) *LabelForUpdateNodePoolConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LabelForUpdateNodePoolConfigInput) SetValue(v string) *LabelForUpdateNodePoolConfigInput {
	s.Value = &v
	return s
}

type LoginForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Password *string `type:"string" json:",omitempty"`

	SshKeyPairName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LoginForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *LoginForUpdateNodePoolConfigInput) SetPassword(v string) *LoginForUpdateNodePoolConfigInput {
	s.Password = &v
	return s
}

// SetSshKeyPairName sets the SshKeyPairName field's value.
func (s *LoginForUpdateNodePoolConfigInput) SetSshKeyPairName(v string) *LoginForUpdateNodePoolConfigInput {
	s.SshKeyPairName = &v
	return s
}

type NodeConfigForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdditionalContainerStorageEnabled *bool `type:"boolean" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	AutoRenewPeriod *int32 `type:"int32" json:",omitempty"`

	DataVolumes []*DataVolumeForUpdateNodePoolConfigInput `type:"list" json:",omitempty"`

	HpcClusterIds []*string `type:"list" json:",omitempty"`

	ImageId *string `type:"string" json:",omitempty"`

	InitializeScript *string `type:"string" json:",omitempty"`

	InstanceTypeIds []*string `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	PublicAccessConfig *PublicAccessConfigForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	PublicAccessEnabled *bool `type:"boolean" json:",omitempty"`

	Security *SecurityForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	SystemVolume *SystemVolumeForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	Tags []*TagForUpdateNodePoolConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NodeConfigForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetAdditionalContainerStorageEnabled sets the AdditionalContainerStorageEnabled field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetAdditionalContainerStorageEnabled(v bool) *NodeConfigForUpdateNodePoolConfigInput {
	s.AdditionalContainerStorageEnabled = &v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetAutoRenew(v bool) *NodeConfigForUpdateNodePoolConfigInput {
	s.AutoRenew = &v
	return s
}

// SetAutoRenewPeriod sets the AutoRenewPeriod field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetAutoRenewPeriod(v int32) *NodeConfigForUpdateNodePoolConfigInput {
	s.AutoRenewPeriod = &v
	return s
}

// SetDataVolumes sets the DataVolumes field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetDataVolumes(v []*DataVolumeForUpdateNodePoolConfigInput) *NodeConfigForUpdateNodePoolConfigInput {
	s.DataVolumes = v
	return s
}

// SetHpcClusterIds sets the HpcClusterIds field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetHpcClusterIds(v []*string) *NodeConfigForUpdateNodePoolConfigInput {
	s.HpcClusterIds = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetImageId(v string) *NodeConfigForUpdateNodePoolConfigInput {
	s.ImageId = &v
	return s
}

// SetInitializeScript sets the InitializeScript field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetInitializeScript(v string) *NodeConfigForUpdateNodePoolConfigInput {
	s.InitializeScript = &v
	return s
}

// SetInstanceTypeIds sets the InstanceTypeIds field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetInstanceTypeIds(v []*string) *NodeConfigForUpdateNodePoolConfigInput {
	s.InstanceTypeIds = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetNamePrefix(v string) *NodeConfigForUpdateNodePoolConfigInput {
	s.NamePrefix = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetPeriod(v int32) *NodeConfigForUpdateNodePoolConfigInput {
	s.Period = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetProjectName(v string) *NodeConfigForUpdateNodePoolConfigInput {
	s.ProjectName = &v
	return s
}

// SetPublicAccessConfig sets the PublicAccessConfig field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetPublicAccessConfig(v *PublicAccessConfigForUpdateNodePoolConfigInput) *NodeConfigForUpdateNodePoolConfigInput {
	s.PublicAccessConfig = v
	return s
}

// SetPublicAccessEnabled sets the PublicAccessEnabled field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetPublicAccessEnabled(v bool) *NodeConfigForUpdateNodePoolConfigInput {
	s.PublicAccessEnabled = &v
	return s
}

// SetSecurity sets the Security field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetSecurity(v *SecurityForUpdateNodePoolConfigInput) *NodeConfigForUpdateNodePoolConfigInput {
	s.Security = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetSubnetIds(v []*string) *NodeConfigForUpdateNodePoolConfigInput {
	s.SubnetIds = v
	return s
}

// SetSystemVolume sets the SystemVolume field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetSystemVolume(v *SystemVolumeForUpdateNodePoolConfigInput) *NodeConfigForUpdateNodePoolConfigInput {
	s.SystemVolume = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NodeConfigForUpdateNodePoolConfigInput) SetTags(v []*TagForUpdateNodePoolConfigInput) *NodeConfigForUpdateNodePoolConfigInput {
	s.Tags = v
	return s
}

type PublicAccessConfigForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	BillingType *int32 `type:"int32" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty" enum:"EnumOfIspForUpdateNodePoolConfigInput"`
}

// String returns the string representation
func (s PublicAccessConfigForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccessConfigForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *PublicAccessConfigForUpdateNodePoolConfigInput) SetBandwidth(v int32) *PublicAccessConfigForUpdateNodePoolConfigInput {
	s.Bandwidth = &v
	return s
}

// SetBillingType sets the BillingType field's value.
func (s *PublicAccessConfigForUpdateNodePoolConfigInput) SetBillingType(v int32) *PublicAccessConfigForUpdateNodePoolConfigInput {
	s.BillingType = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *PublicAccessConfigForUpdateNodePoolConfigInput) SetIsp(v string) *PublicAccessConfigForUpdateNodePoolConfigInput {
	s.Isp = &v
	return s
}

type SecurityForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Login *LoginForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SecurityStrategies []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SecurityForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetLogin sets the Login field's value.
func (s *SecurityForUpdateNodePoolConfigInput) SetLogin(v *LoginForUpdateNodePoolConfigInput) *SecurityForUpdateNodePoolConfigInput {
	s.Login = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *SecurityForUpdateNodePoolConfigInput) SetSecurityGroupIds(v []*string) *SecurityForUpdateNodePoolConfigInput {
	s.SecurityGroupIds = v
	return s
}

// SetSecurityStrategies sets the SecurityStrategies field's value.
func (s *SecurityForUpdateNodePoolConfigInput) SetSecurityStrategies(v []*string) *SecurityForUpdateNodePoolConfigInput {
	s.SecurityStrategies = v
	return s
}

type SystemVolumeForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForUpdateNodePoolConfigInput"`
}

// String returns the string representation
func (s SystemVolumeForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemVolumeForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *SystemVolumeForUpdateNodePoolConfigInput) SetSize(v int32) *SystemVolumeForUpdateNodePoolConfigInput {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *SystemVolumeForUpdateNodePoolConfigInput) SetType(v string) *SystemVolumeForUpdateNodePoolConfigInput {
	s.Type = &v
	return s
}

type TagForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForUpdateNodePoolConfigInput) SetKey(v string) *TagForUpdateNodePoolConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForUpdateNodePoolConfigInput) SetValue(v string) *TagForUpdateNodePoolConfigInput {
	s.Value = &v
	return s
}

type TaintForUpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Effect *string `type:"string" json:",omitempty" enum:"EnumOfEffectForUpdateNodePoolConfigInput"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaintForUpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaintForUpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// SetEffect sets the Effect field's value.
func (s *TaintForUpdateNodePoolConfigInput) SetEffect(v string) *TaintForUpdateNodePoolConfigInput {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TaintForUpdateNodePoolConfigInput) SetKey(v string) *TaintForUpdateNodePoolConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TaintForUpdateNodePoolConfigInput) SetValue(v string) *TaintForUpdateNodePoolConfigInput {
	s.Value = &v
	return s
}

type UpdateNodePoolConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoScaling *AutoScalingForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	KubernetesConfig *KubernetesConfigForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeConfig *NodeConfigForUpdateNodePoolConfigInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s UpdateNodePoolConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodePoolConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodePoolConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodePoolConfigInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.KubernetesConfig != nil {
		if err := s.KubernetesConfig.Validate(); err != nil {
			invalidParams.AddNested("KubernetesConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScaling sets the AutoScaling field's value.
func (s *UpdateNodePoolConfigInput) SetAutoScaling(v *AutoScalingForUpdateNodePoolConfigInput) *UpdateNodePoolConfigInput {
	s.AutoScaling = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateNodePoolConfigInput) SetClientToken(v string) *UpdateNodePoolConfigInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *UpdateNodePoolConfigInput) SetClusterId(v string) *UpdateNodePoolConfigInput {
	s.ClusterId = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateNodePoolConfigInput) SetId(v string) *UpdateNodePoolConfigInput {
	s.Id = &v
	return s
}

// SetKubernetesConfig sets the KubernetesConfig field's value.
func (s *UpdateNodePoolConfigInput) SetKubernetesConfig(v *KubernetesConfigForUpdateNodePoolConfigInput) *UpdateNodePoolConfigInput {
	s.KubernetesConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateNodePoolConfigInput) SetName(v string) *UpdateNodePoolConfigInput {
	s.Name = &v
	return s
}

// SetNodeConfig sets the NodeConfig field's value.
func (s *UpdateNodePoolConfigInput) SetNodeConfig(v *NodeConfigForUpdateNodePoolConfigInput) *UpdateNodePoolConfigInput {
	s.NodeConfig = v
	return s
}

type UpdateNodePoolConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateNodePoolConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodePoolConfigOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfEffectForUpdateNodePoolConfigInputNoSchedule is a EnumOfEffectForUpdateNodePoolConfigInput enum value
	EnumOfEffectForUpdateNodePoolConfigInputNoSchedule = "NoSchedule"

	// EnumOfEffectForUpdateNodePoolConfigInputPreferNoSchedule is a EnumOfEffectForUpdateNodePoolConfigInput enum value
	EnumOfEffectForUpdateNodePoolConfigInputPreferNoSchedule = "PreferNoSchedule"

	// EnumOfEffectForUpdateNodePoolConfigInputNoExecute is a EnumOfEffectForUpdateNodePoolConfigInput enum value
	EnumOfEffectForUpdateNodePoolConfigInputNoExecute = "NoExecute"
)

const (
	// EnumOfFileSystemForUpdateNodePoolConfigInputExt4 is a EnumOfFileSystemForUpdateNodePoolConfigInput enum value
	EnumOfFileSystemForUpdateNodePoolConfigInputExt4 = "Ext4"

	// EnumOfFileSystemForUpdateNodePoolConfigInputXfs is a EnumOfFileSystemForUpdateNodePoolConfigInput enum value
	EnumOfFileSystemForUpdateNodePoolConfigInputXfs = "Xfs"
)

const (
	// EnumOfIspForUpdateNodePoolConfigInputBgp is a EnumOfIspForUpdateNodePoolConfigInput enum value
	EnumOfIspForUpdateNodePoolConfigInputBgp = "BGP"

	// EnumOfIspForUpdateNodePoolConfigInputChinaMobile is a EnumOfIspForUpdateNodePoolConfigInput enum value
	EnumOfIspForUpdateNodePoolConfigInputChinaMobile = "ChinaMobile"

	// EnumOfIspForUpdateNodePoolConfigInputChinaTelecom is a EnumOfIspForUpdateNodePoolConfigInput enum value
	EnumOfIspForUpdateNodePoolConfigInputChinaTelecom = "ChinaTelecom"

	// EnumOfIspForUpdateNodePoolConfigInputChinaUnicom is a EnumOfIspForUpdateNodePoolConfigInput enum value
	EnumOfIspForUpdateNodePoolConfigInputChinaUnicom = "ChinaUnicom"
)

const (
	// EnumOfSecurityStrategyListForUpdateNodePoolConfigInputHids is a EnumOfSecurityStrategyListForUpdateNodePoolConfigInput enum value
	EnumOfSecurityStrategyListForUpdateNodePoolConfigInputHids = "Hids"
)

const (
	// EnumOfSubnetPolicyForUpdateNodePoolConfigInputZoneBalance is a EnumOfSubnetPolicyForUpdateNodePoolConfigInput enum value
	EnumOfSubnetPolicyForUpdateNodePoolConfigInputZoneBalance = "ZoneBalance"

	// EnumOfSubnetPolicyForUpdateNodePoolConfigInputPriority is a EnumOfSubnetPolicyForUpdateNodePoolConfigInput enum value
	EnumOfSubnetPolicyForUpdateNodePoolConfigInputPriority = "Priority"
)

const (
	// EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputRestricted is a EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputRestricted = "restricted"

	// EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputBestEffort is a EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputBestEffort = "best-effort"

	// EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputNone is a EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputNone = "none"

	// EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputSingleNumaNode is a EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerPolicyForUpdateNodePoolConfigInputSingleNumaNode = "single-numa-node"
)

const (
	// EnumOfTopologyManagerScopeForUpdateNodePoolConfigInputPod is a EnumOfTopologyManagerScopeForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerScopeForUpdateNodePoolConfigInputPod = "pod"

	// EnumOfTopologyManagerScopeForUpdateNodePoolConfigInputContainer is a EnumOfTopologyManagerScopeForUpdateNodePoolConfigInput enum value
	EnumOfTopologyManagerScopeForUpdateNodePoolConfigInputContainer = "container"
)

const (
	// EnumOfTypeForUpdateNodePoolConfigInputEssdPl0 is a EnumOfTypeForUpdateNodePoolConfigInput enum value
	EnumOfTypeForUpdateNodePoolConfigInputEssdPl0 = "ESSD_PL0"

	// EnumOfTypeForUpdateNodePoolConfigInputEssdFlexPl is a EnumOfTypeForUpdateNodePoolConfigInput enum value
	EnumOfTypeForUpdateNodePoolConfigInputEssdFlexPl = "ESSD_FlexPL"
)
