// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNodePoolsCommon = "ListNodePools"

// ListNodePoolsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodePoolsCommon operation. The "output" return
// value will be populated with the ListNodePoolsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodePoolsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodePoolsCommon Send returns without error.
//
// See ListNodePoolsCommon for more information on using the ListNodePoolsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNodePoolsCommonRequest method.
//    req, resp := client.ListNodePoolsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) ListNodePoolsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNodePoolsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodePoolsCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation ListNodePoolsCommon for usage and error information.
func (c *VKE) ListNodePoolsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNodePoolsCommonRequest(input)
	return out, req.Send()
}

// ListNodePoolsCommonWithContext is the same as ListNodePoolsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodePoolsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) ListNodePoolsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNodePoolsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNodePools = "ListNodePools"

// ListNodePoolsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodePools operation. The "output" return
// value will be populated with the ListNodePoolsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodePoolsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodePoolsCommon Send returns without error.
//
// See ListNodePools for more information on using the ListNodePools
// API call, and error handling.
//
//    // Example sending a request using the ListNodePoolsRequest method.
//    req, resp := client.ListNodePoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) ListNodePoolsRequest(input *ListNodePoolsInput) (req *request.Request, output *ListNodePoolsOutput) {
	op := &request.Operation{
		Name:       opListNodePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNodePoolsInput{}
	}

	output = &ListNodePoolsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodePools API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation ListNodePools for usage and error information.
func (c *VKE) ListNodePools(input *ListNodePoolsInput) (*ListNodePoolsOutput, error) {
	req, out := c.ListNodePoolsRequest(input)
	return out, req.Send()
}

// ListNodePoolsWithContext is the same as ListNodePools with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodePools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) ListNodePoolsWithContext(ctx volcengine.Context, input *ListNodePoolsInput, opts ...request.Option) (*ListNodePoolsOutput, error) {
	req, out := c.ListNodePoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AutoScalingForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DesiredReplicas *int32 `type:"int32" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	MaxReplicas *int32 `type:"int32" json:",omitempty"`

	MinReplicas *int32 `type:"int32" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ScalingGroupId *string `type:"string" json:",omitempty"`

	SubnetPolicy *string `type:"string" json:",omitempty" enum:"EnumOfSubnetPolicyForListNodePoolsOutput"`
}

// String returns the string representation
func (s AutoScalingForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetDesiredReplicas sets the DesiredReplicas field's value.
func (s *AutoScalingForListNodePoolsOutput) SetDesiredReplicas(v int32) *AutoScalingForListNodePoolsOutput {
	s.DesiredReplicas = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AutoScalingForListNodePoolsOutput) SetEnabled(v bool) *AutoScalingForListNodePoolsOutput {
	s.Enabled = &v
	return s
}

// SetMaxReplicas sets the MaxReplicas field's value.
func (s *AutoScalingForListNodePoolsOutput) SetMaxReplicas(v int32) *AutoScalingForListNodePoolsOutput {
	s.MaxReplicas = &v
	return s
}

// SetMinReplicas sets the MinReplicas field's value.
func (s *AutoScalingForListNodePoolsOutput) SetMinReplicas(v int32) *AutoScalingForListNodePoolsOutput {
	s.MinReplicas = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *AutoScalingForListNodePoolsOutput) SetPriority(v int32) *AutoScalingForListNodePoolsOutput {
	s.Priority = &v
	return s
}

// SetScalingGroupId sets the ScalingGroupId field's value.
func (s *AutoScalingForListNodePoolsOutput) SetScalingGroupId(v string) *AutoScalingForListNodePoolsOutput {
	s.ScalingGroupId = &v
	return s
}

// SetSubnetPolicy sets the SubnetPolicy field's value.
func (s *AutoScalingForListNodePoolsOutput) SetSubnetPolicy(v string) *AutoScalingForListNodePoolsOutput {
	s.SubnetPolicy = &v
	return s
}

type ConditionForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConditionForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *ConditionForListNodePoolsOutput) SetType(v string) *ConditionForListNodePoolsOutput {
	s.Type = &v
	return s
}

type ConvertTagForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTagForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTagForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ConvertTagForListNodePoolsOutput) SetKey(v string) *ConvertTagForListNodePoolsOutput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConvertTagForListNodePoolsOutput) SetType(v string) *ConvertTagForListNodePoolsOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertTagForListNodePoolsOutput) SetValue(v string) *ConvertTagForListNodePoolsOutput {
	s.Value = &v
	return s
}

type DataVolumeForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystem *string `type:"string" json:",omitempty" enum:"EnumOfFileSystemForListNodePoolsOutput"`

	MountPoint *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	SnapshotId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForListNodePoolsOutput"`
}

// String returns the string representation
func (s DataVolumeForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataVolumeForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetFileSystem sets the FileSystem field's value.
func (s *DataVolumeForListNodePoolsOutput) SetFileSystem(v string) *DataVolumeForListNodePoolsOutput {
	s.FileSystem = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *DataVolumeForListNodePoolsOutput) SetMountPoint(v string) *DataVolumeForListNodePoolsOutput {
	s.MountPoint = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DataVolumeForListNodePoolsOutput) SetSize(v int32) *DataVolumeForListNodePoolsOutput {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *DataVolumeForListNodePoolsOutput) SetSnapshotId(v string) *DataVolumeForListNodePoolsOutput {
	s.SnapshotId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataVolumeForListNodePoolsOutput) SetType(v string) *DataVolumeForListNodePoolsOutput {
	s.Type = &v
	return s
}

type EvictionHardForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s EvictionHardForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EvictionHardForListNodePoolsOutput) GoString() string {
	return s.String()
}

type FeatureGatesForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	QoSResourceManager *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s FeatureGatesForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureGatesForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetQoSResourceManager sets the QoSResourceManager field's value.
func (s *FeatureGatesForListNodePoolsOutput) SetQoSResourceManager(v bool) *FeatureGatesForListNodePoolsOutput {
	s.QoSResourceManager = &v
	return s
}

type FilterForListNodePoolsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoScalingEnabled *bool `type:"boolean" json:"AutoScaling.Enabled,omitempty"`

	ClusterIds []*string `type:"list" json:",omitempty"`

	CreateClientToken *string `type:"string" json:",omitempty"`

	Ids []*string `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Statuses []*StatusForListNodePoolsInput `type:"list" json:",omitempty"`

	UpdateClientToken *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListNodePoolsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListNodePoolsInput) GoString() string {
	return s.String()
}

// SetAutoScalingEnabled sets the AutoScalingEnabled field's value.
func (s *FilterForListNodePoolsInput) SetAutoScalingEnabled(v bool) *FilterForListNodePoolsInput {
	s.AutoScalingEnabled = &v
	return s
}

// SetClusterIds sets the ClusterIds field's value.
func (s *FilterForListNodePoolsInput) SetClusterIds(v []*string) *FilterForListNodePoolsInput {
	s.ClusterIds = v
	return s
}

// SetCreateClientToken sets the CreateClientToken field's value.
func (s *FilterForListNodePoolsInput) SetCreateClientToken(v string) *FilterForListNodePoolsInput {
	s.CreateClientToken = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *FilterForListNodePoolsInput) SetIds(v []*string) *FilterForListNodePoolsInput {
	s.Ids = v
	return s
}

// SetName sets the Name field's value.
func (s *FilterForListNodePoolsInput) SetName(v string) *FilterForListNodePoolsInput {
	s.Name = &v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *FilterForListNodePoolsInput) SetStatuses(v []*StatusForListNodePoolsInput) *FilterForListNodePoolsInput {
	s.Statuses = v
	return s
}

// SetUpdateClientToken sets the UpdateClientToken field's value.
func (s *FilterForListNodePoolsInput) SetUpdateClientToken(v string) *FilterForListNodePoolsInput {
	s.UpdateClientToken = &v
	return s
}

type ItemForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoScaling *AutoScalingForListNodePoolsOutput `type:"structure" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	CreateClientToken *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	KubernetesConfig *KubernetesConfigForListNodePoolsOutput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeConfig *NodeConfigForListNodePoolsOutput `type:"structure" json:",omitempty"`

	NodeStatistics *NodeStatisticsForListNodePoolsOutput `type:"structure" json:",omitempty"`

	Status *StatusForListNodePoolsOutput `type:"structure" json:",omitempty"`

	Tags []*ConvertTagForListNodePoolsOutput `type:"list" json:",omitempty"`

	UpdateClientToken *string `type:"string" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetAutoScaling sets the AutoScaling field's value.
func (s *ItemForListNodePoolsOutput) SetAutoScaling(v *AutoScalingForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.AutoScaling = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ItemForListNodePoolsOutput) SetClusterId(v string) *ItemForListNodePoolsOutput {
	s.ClusterId = &v
	return s
}

// SetCreateClientToken sets the CreateClientToken field's value.
func (s *ItemForListNodePoolsOutput) SetCreateClientToken(v string) *ItemForListNodePoolsOutput {
	s.CreateClientToken = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListNodePoolsOutput) SetCreateTime(v string) *ItemForListNodePoolsOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ItemForListNodePoolsOutput) SetId(v string) *ItemForListNodePoolsOutput {
	s.Id = &v
	return s
}

// SetKubernetesConfig sets the KubernetesConfig field's value.
func (s *ItemForListNodePoolsOutput) SetKubernetesConfig(v *KubernetesConfigForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.KubernetesConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListNodePoolsOutput) SetName(v string) *ItemForListNodePoolsOutput {
	s.Name = &v
	return s
}

// SetNodeConfig sets the NodeConfig field's value.
func (s *ItemForListNodePoolsOutput) SetNodeConfig(v *NodeConfigForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.NodeConfig = v
	return s
}

// SetNodeStatistics sets the NodeStatistics field's value.
func (s *ItemForListNodePoolsOutput) SetNodeStatistics(v *NodeStatisticsForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.NodeStatistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListNodePoolsOutput) SetStatus(v *StatusForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ItemForListNodePoolsOutput) SetTags(v []*ConvertTagForListNodePoolsOutput) *ItemForListNodePoolsOutput {
	s.Tags = v
	return s
}

// SetUpdateClientToken sets the UpdateClientToken field's value.
func (s *ItemForListNodePoolsOutput) SetUpdateClientToken(v string) *ItemForListNodePoolsOutput {
	s.UpdateClientToken = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListNodePoolsOutput) SetUpdateTime(v string) *ItemForListNodePoolsOutput {
	s.UpdateTime = &v
	return s
}

type KubeletConfigForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EvictionHard []*EvictionHardForListNodePoolsOutput `type:"list" json:",omitempty"`

	FeatureGates *FeatureGatesForListNodePoolsOutput `type:"structure" json:",omitempty"`

	KubeApiBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	KubeApiQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	RegistryBurst *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	RegistryPullQps *int32 `min:"1" max:"50" type:"int32" json:",omitempty"`

	SerializeImagePulls *bool `type:"boolean" json:",omitempty"`

	TopologyManagerPolicy *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerPolicyForListNodePoolsOutput"`

	TopologyManagerScope *string `type:"string" json:",omitempty" enum:"EnumOfTopologyManagerScopeForListNodePoolsOutput"`
}

// String returns the string representation
func (s KubeletConfigForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubeletConfigForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetEvictionHard sets the EvictionHard field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetEvictionHard(v []*EvictionHardForListNodePoolsOutput) *KubeletConfigForListNodePoolsOutput {
	s.EvictionHard = v
	return s
}

// SetFeatureGates sets the FeatureGates field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetFeatureGates(v *FeatureGatesForListNodePoolsOutput) *KubeletConfigForListNodePoolsOutput {
	s.FeatureGates = v
	return s
}

// SetKubeApiBurst sets the KubeApiBurst field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetKubeApiBurst(v int32) *KubeletConfigForListNodePoolsOutput {
	s.KubeApiBurst = &v
	return s
}

// SetKubeApiQps sets the KubeApiQps field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetKubeApiQps(v int32) *KubeletConfigForListNodePoolsOutput {
	s.KubeApiQps = &v
	return s
}

// SetRegistryBurst sets the RegistryBurst field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetRegistryBurst(v int32) *KubeletConfigForListNodePoolsOutput {
	s.RegistryBurst = &v
	return s
}

// SetRegistryPullQps sets the RegistryPullQps field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetRegistryPullQps(v int32) *KubeletConfigForListNodePoolsOutput {
	s.RegistryPullQps = &v
	return s
}

// SetSerializeImagePulls sets the SerializeImagePulls field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetSerializeImagePulls(v bool) *KubeletConfigForListNodePoolsOutput {
	s.SerializeImagePulls = &v
	return s
}

// SetTopologyManagerPolicy sets the TopologyManagerPolicy field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetTopologyManagerPolicy(v string) *KubeletConfigForListNodePoolsOutput {
	s.TopologyManagerPolicy = &v
	return s
}

// SetTopologyManagerScope sets the TopologyManagerScope field's value.
func (s *KubeletConfigForListNodePoolsOutput) SetTopologyManagerScope(v string) *KubeletConfigForListNodePoolsOutput {
	s.TopologyManagerScope = &v
	return s
}

type KubernetesConfigForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoSyncDisabled *bool `type:"boolean" json:",omitempty"`

	Cordon *bool `type:"boolean" json:",omitempty"`

	KubeletConfig *KubeletConfigForListNodePoolsOutput `type:"structure" json:",omitempty"`

	Labels []*LabelForListNodePoolsOutput `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Taints []*TaintForListNodePoolsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s KubernetesConfigForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesConfigForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetAutoSyncDisabled sets the AutoSyncDisabled field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetAutoSyncDisabled(v bool) *KubernetesConfigForListNodePoolsOutput {
	s.AutoSyncDisabled = &v
	return s
}

// SetCordon sets the Cordon field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetCordon(v bool) *KubernetesConfigForListNodePoolsOutput {
	s.Cordon = &v
	return s
}

// SetKubeletConfig sets the KubeletConfig field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetKubeletConfig(v *KubeletConfigForListNodePoolsOutput) *KubernetesConfigForListNodePoolsOutput {
	s.KubeletConfig = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetLabels(v []*LabelForListNodePoolsOutput) *KubernetesConfigForListNodePoolsOutput {
	s.Labels = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetNamePrefix(v string) *KubernetesConfigForListNodePoolsOutput {
	s.NamePrefix = &v
	return s
}

// SetTaints sets the Taints field's value.
func (s *KubernetesConfigForListNodePoolsOutput) SetTaints(v []*TaintForListNodePoolsOutput) *KubernetesConfigForListNodePoolsOutput {
	s.Taints = v
	return s
}

type LabelForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LabelForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForListNodePoolsOutput) SetKey(v string) *LabelForListNodePoolsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LabelForListNodePoolsOutput) SetValue(v string) *LabelForListNodePoolsOutput {
	s.Value = &v
	return s
}

type ListNodePoolsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListNodePoolsInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Tags []*TagForListNodePoolsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListNodePoolsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodePoolsInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *ListNodePoolsInput) SetFilter(v *FilterForListNodePoolsInput) *ListNodePoolsInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNodePoolsInput) SetPageNumber(v int32) *ListNodePoolsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNodePoolsInput) SetPageSize(v int32) *ListNodePoolsInput {
	s.PageSize = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListNodePoolsInput) SetTags(v []*TagForListNodePoolsInput) *ListNodePoolsInput {
	s.Tags = v
	return s
}

type ListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListNodePoolsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListNodePoolsOutput) SetItems(v []*ItemForListNodePoolsOutput) *ListNodePoolsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNodePoolsOutput) SetPageNumber(v int32) *ListNodePoolsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNodePoolsOutput) SetPageSize(v int32) *ListNodePoolsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListNodePoolsOutput) SetTotalCount(v int32) *ListNodePoolsOutput {
	s.TotalCount = &v
	return s
}

type LoginForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SshKeyPairName *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LoginForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetSshKeyPairName sets the SshKeyPairName field's value.
func (s *LoginForListNodePoolsOutput) SetSshKeyPairName(v string) *LoginForListNodePoolsOutput {
	s.SshKeyPairName = &v
	return s
}

// SetType sets the Type field's value.
func (s *LoginForListNodePoolsOutput) SetType(v string) *LoginForListNodePoolsOutput {
	s.Type = &v
	return s
}

type NodeConfigForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdditionalContainerStorageEnabled *bool `type:"boolean" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	AutoRenewPeriod *int32 `type:"int32" json:",omitempty"`

	DataVolumes []*DataVolumeForListNodePoolsOutput `type:"list" json:",omitempty"`

	DeploymentSetGroupNumber *int32 `type:"int32" json:",omitempty"`

	DeploymentSetId *string `type:"string" json:",omitempty"`

	HpcClusterIds []*string `type:"list" json:",omitempty"`

	ImageId *string `type:"string" json:",omitempty"`

	InitializeScript *string `type:"string" json:",omitempty"`

	InstanceChargeType *string `type:"string" json:",omitempty" enum:"EnumOfInstanceChargeTypeForListNodePoolsOutput"`

	InstanceTypeIds []*string `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	PublicAccessConfig *PublicAccessConfigForListNodePoolsOutput `type:"structure" json:",omitempty"`

	PublicAccessEnabled *bool `type:"boolean" json:",omitempty"`

	Security *SecurityForListNodePoolsOutput `type:"structure" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	SystemVolume *SystemVolumeForListNodePoolsOutput `type:"structure" json:",omitempty"`

	Tags []*TagForListNodePoolsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NodeConfigForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetAdditionalContainerStorageEnabled sets the AdditionalContainerStorageEnabled field's value.
func (s *NodeConfigForListNodePoolsOutput) SetAdditionalContainerStorageEnabled(v bool) *NodeConfigForListNodePoolsOutput {
	s.AdditionalContainerStorageEnabled = &v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *NodeConfigForListNodePoolsOutput) SetAutoRenew(v bool) *NodeConfigForListNodePoolsOutput {
	s.AutoRenew = &v
	return s
}

// SetAutoRenewPeriod sets the AutoRenewPeriod field's value.
func (s *NodeConfigForListNodePoolsOutput) SetAutoRenewPeriod(v int32) *NodeConfigForListNodePoolsOutput {
	s.AutoRenewPeriod = &v
	return s
}

// SetDataVolumes sets the DataVolumes field's value.
func (s *NodeConfigForListNodePoolsOutput) SetDataVolumes(v []*DataVolumeForListNodePoolsOutput) *NodeConfigForListNodePoolsOutput {
	s.DataVolumes = v
	return s
}

// SetDeploymentSetGroupNumber sets the DeploymentSetGroupNumber field's value.
func (s *NodeConfigForListNodePoolsOutput) SetDeploymentSetGroupNumber(v int32) *NodeConfigForListNodePoolsOutput {
	s.DeploymentSetGroupNumber = &v
	return s
}

// SetDeploymentSetId sets the DeploymentSetId field's value.
func (s *NodeConfigForListNodePoolsOutput) SetDeploymentSetId(v string) *NodeConfigForListNodePoolsOutput {
	s.DeploymentSetId = &v
	return s
}

// SetHpcClusterIds sets the HpcClusterIds field's value.
func (s *NodeConfigForListNodePoolsOutput) SetHpcClusterIds(v []*string) *NodeConfigForListNodePoolsOutput {
	s.HpcClusterIds = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *NodeConfigForListNodePoolsOutput) SetImageId(v string) *NodeConfigForListNodePoolsOutput {
	s.ImageId = &v
	return s
}

// SetInitializeScript sets the InitializeScript field's value.
func (s *NodeConfigForListNodePoolsOutput) SetInitializeScript(v string) *NodeConfigForListNodePoolsOutput {
	s.InitializeScript = &v
	return s
}

// SetInstanceChargeType sets the InstanceChargeType field's value.
func (s *NodeConfigForListNodePoolsOutput) SetInstanceChargeType(v string) *NodeConfigForListNodePoolsOutput {
	s.InstanceChargeType = &v
	return s
}

// SetInstanceTypeIds sets the InstanceTypeIds field's value.
func (s *NodeConfigForListNodePoolsOutput) SetInstanceTypeIds(v []*string) *NodeConfigForListNodePoolsOutput {
	s.InstanceTypeIds = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *NodeConfigForListNodePoolsOutput) SetNamePrefix(v string) *NodeConfigForListNodePoolsOutput {
	s.NamePrefix = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *NodeConfigForListNodePoolsOutput) SetPeriod(v int32) *NodeConfigForListNodePoolsOutput {
	s.Period = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *NodeConfigForListNodePoolsOutput) SetProjectName(v string) *NodeConfigForListNodePoolsOutput {
	s.ProjectName = &v
	return s
}

// SetPublicAccessConfig sets the PublicAccessConfig field's value.
func (s *NodeConfigForListNodePoolsOutput) SetPublicAccessConfig(v *PublicAccessConfigForListNodePoolsOutput) *NodeConfigForListNodePoolsOutput {
	s.PublicAccessConfig = v
	return s
}

// SetPublicAccessEnabled sets the PublicAccessEnabled field's value.
func (s *NodeConfigForListNodePoolsOutput) SetPublicAccessEnabled(v bool) *NodeConfigForListNodePoolsOutput {
	s.PublicAccessEnabled = &v
	return s
}

// SetSecurity sets the Security field's value.
func (s *NodeConfigForListNodePoolsOutput) SetSecurity(v *SecurityForListNodePoolsOutput) *NodeConfigForListNodePoolsOutput {
	s.Security = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NodeConfigForListNodePoolsOutput) SetSubnetIds(v []*string) *NodeConfigForListNodePoolsOutput {
	s.SubnetIds = v
	return s
}

// SetSystemVolume sets the SystemVolume field's value.
func (s *NodeConfigForListNodePoolsOutput) SetSystemVolume(v *SystemVolumeForListNodePoolsOutput) *NodeConfigForListNodePoolsOutput {
	s.SystemVolume = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NodeConfigForListNodePoolsOutput) SetTags(v []*TagForListNodePoolsOutput) *NodeConfigForListNodePoolsOutput {
	s.Tags = v
	return s
}

type NodeStatisticsForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatingCount *int32 `type:"int32" json:",omitempty"`

	DeletingCount *int32 `type:"int32" json:",omitempty"`

	FailedCount *int32 `type:"int32" json:",omitempty"`

	RunningCount *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`

	UpdatingCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s NodeStatisticsForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeStatisticsForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetCreatingCount sets the CreatingCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetCreatingCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.CreatingCount = &v
	return s
}

// SetDeletingCount sets the DeletingCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetDeletingCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.DeletingCount = &v
	return s
}

// SetFailedCount sets the FailedCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetFailedCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.FailedCount = &v
	return s
}

// SetRunningCount sets the RunningCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetRunningCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.RunningCount = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetTotalCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.TotalCount = &v
	return s
}

// SetUpdatingCount sets the UpdatingCount field's value.
func (s *NodeStatisticsForListNodePoolsOutput) SetUpdatingCount(v int32) *NodeStatisticsForListNodePoolsOutput {
	s.UpdatingCount = &v
	return s
}

type PublicAccessConfigForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	BillingType *int32 `type:"int32" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PublicAccessConfigForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccessConfigForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *PublicAccessConfigForListNodePoolsOutput) SetBandwidth(v int32) *PublicAccessConfigForListNodePoolsOutput {
	s.Bandwidth = &v
	return s
}

// SetBillingType sets the BillingType field's value.
func (s *PublicAccessConfigForListNodePoolsOutput) SetBillingType(v int32) *PublicAccessConfigForListNodePoolsOutput {
	s.BillingType = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *PublicAccessConfigForListNodePoolsOutput) SetIsp(v string) *PublicAccessConfigForListNodePoolsOutput {
	s.Isp = &v
	return s
}

type SecurityForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Login *LoginForListNodePoolsOutput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SecurityStrategies []*string `type:"list" json:",omitempty"`

	SecurityStrategyEnabled *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s SecurityForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetLogin sets the Login field's value.
func (s *SecurityForListNodePoolsOutput) SetLogin(v *LoginForListNodePoolsOutput) *SecurityForListNodePoolsOutput {
	s.Login = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *SecurityForListNodePoolsOutput) SetSecurityGroupIds(v []*string) *SecurityForListNodePoolsOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSecurityStrategies sets the SecurityStrategies field's value.
func (s *SecurityForListNodePoolsOutput) SetSecurityStrategies(v []*string) *SecurityForListNodePoolsOutput {
	s.SecurityStrategies = v
	return s
}

// SetSecurityStrategyEnabled sets the SecurityStrategyEnabled field's value.
func (s *SecurityForListNodePoolsOutput) SetSecurityStrategyEnabled(v bool) *SecurityForListNodePoolsOutput {
	s.SecurityStrategyEnabled = &v
	return s
}

type StatusForListNodePoolsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConditionsType *string `type:"string" json:"Conditions.Type,omitempty" enum:"EnumOfConditionsTypeForListNodePoolsInput"`

	Phase *string `type:"string" json:",omitempty" enum:"EnumOfPhaseForListNodePoolsInput"`
}

// String returns the string representation
func (s StatusForListNodePoolsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListNodePoolsInput) GoString() string {
	return s.String()
}

// SetConditionsType sets the ConditionsType field's value.
func (s *StatusForListNodePoolsInput) SetConditionsType(v string) *StatusForListNodePoolsInput {
	s.ConditionsType = &v
	return s
}

// SetPhase sets the Phase field's value.
func (s *StatusForListNodePoolsInput) SetPhase(v string) *StatusForListNodePoolsInput {
	s.Phase = &v
	return s
}

type StatusForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Conditions []*ConditionForListNodePoolsOutput `type:"list" json:",omitempty"`

	Phase *string `type:"string" json:",omitempty" enum:"EnumOfPhaseForListNodePoolsOutput"`
}

// String returns the string representation
func (s StatusForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetConditions sets the Conditions field's value.
func (s *StatusForListNodePoolsOutput) SetConditions(v []*ConditionForListNodePoolsOutput) *StatusForListNodePoolsOutput {
	s.Conditions = v
	return s
}

// SetPhase sets the Phase field's value.
func (s *StatusForListNodePoolsOutput) SetPhase(v string) *StatusForListNodePoolsOutput {
	s.Phase = &v
	return s
}

type SystemVolumeForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForListNodePoolsOutput"`
}

// String returns the string representation
func (s SystemVolumeForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemVolumeForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *SystemVolumeForListNodePoolsOutput) SetSize(v int32) *SystemVolumeForListNodePoolsOutput {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *SystemVolumeForListNodePoolsOutput) SetType(v string) *SystemVolumeForListNodePoolsOutput {
	s.Type = &v
	return s
}

type TagForListNodePoolsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForListNodePoolsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForListNodePoolsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForListNodePoolsInput) SetKey(v string) *TagForListNodePoolsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForListNodePoolsInput) SetValue(v string) *TagForListNodePoolsInput {
	s.Value = &v
	return s
}

type TagForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForListNodePoolsOutput) SetKey(v string) *TagForListNodePoolsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForListNodePoolsOutput) SetValue(v string) *TagForListNodePoolsOutput {
	s.Value = &v
	return s
}

type TaintForListNodePoolsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Effect *string `type:"string" json:",omitempty" enum:"EnumOfEffectForListNodePoolsOutput"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaintForListNodePoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaintForListNodePoolsOutput) GoString() string {
	return s.String()
}

// SetEffect sets the Effect field's value.
func (s *TaintForListNodePoolsOutput) SetEffect(v string) *TaintForListNodePoolsOutput {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TaintForListNodePoolsOutput) SetKey(v string) *TaintForListNodePoolsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TaintForListNodePoolsOutput) SetValue(v string) *TaintForListNodePoolsOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfConditionsTypeForListNodePoolsInputOk is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputOk = "Ok"

	// EnumOfConditionsTypeForListNodePoolsInputStockOut is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputStockOut = "StockOut"

	// EnumOfConditionsTypeForListNodePoolsInputLimitedByQuota is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputLimitedByQuota = "LimitedByQuota"

	// EnumOfConditionsTypeForListNodePoolsInputBalance is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputBalance = "Balance"

	// EnumOfConditionsTypeForListNodePoolsInputVersionPartlyUpgraded is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputVersionPartlyUpgraded = "VersionPartlyUpgraded"

	// EnumOfConditionsTypeForListNodePoolsInputResourceCleanupFailed is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputResourceCleanupFailed = "ResourceCleanupFailed"

	// EnumOfConditionsTypeForListNodePoolsInputClusterNotRunning is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputClusterNotRunning = "ClusterNotRunning"

	// EnumOfConditionsTypeForListNodePoolsInputUnknown is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputUnknown = "Unknown"

	// EnumOfConditionsTypeForListNodePoolsInputProgressing is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputProgressing = "Progressing"

	// EnumOfConditionsTypeForListNodePoolsInputClusterVersionUpgrading is a EnumOfConditionsTypeForListNodePoolsInput enum value
	EnumOfConditionsTypeForListNodePoolsInputClusterVersionUpgrading = "ClusterVersionUpgrading"
)

const (
	// EnumOfEffectForListNodePoolsOutputNoSchedule is a EnumOfEffectForListNodePoolsOutput enum value
	EnumOfEffectForListNodePoolsOutputNoSchedule = "NoSchedule"

	// EnumOfEffectForListNodePoolsOutputPreferNoSchedule is a EnumOfEffectForListNodePoolsOutput enum value
	EnumOfEffectForListNodePoolsOutputPreferNoSchedule = "PreferNoSchedule"

	// EnumOfEffectForListNodePoolsOutputNoExecute is a EnumOfEffectForListNodePoolsOutput enum value
	EnumOfEffectForListNodePoolsOutputNoExecute = "NoExecute"
)

const (
	// EnumOfFileSystemForListNodePoolsOutputExt4 is a EnumOfFileSystemForListNodePoolsOutput enum value
	EnumOfFileSystemForListNodePoolsOutputExt4 = "Ext4"

	// EnumOfFileSystemForListNodePoolsOutputXfs is a EnumOfFileSystemForListNodePoolsOutput enum value
	EnumOfFileSystemForListNodePoolsOutputXfs = "Xfs"
)

const (
	// EnumOfInstanceChargeTypeForListNodePoolsOutputPostPaid is a EnumOfInstanceChargeTypeForListNodePoolsOutput enum value
	EnumOfInstanceChargeTypeForListNodePoolsOutputPostPaid = "PostPaid"

	// EnumOfInstanceChargeTypeForListNodePoolsOutputPrePaid is a EnumOfInstanceChargeTypeForListNodePoolsOutput enum value
	EnumOfInstanceChargeTypeForListNodePoolsOutputPrePaid = "PrePaid"
)

const (
	// EnumOfPhaseForListNodePoolsInputCreating is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputCreating = "Creating"

	// EnumOfPhaseForListNodePoolsInputRunning is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputRunning = "Running"

	// EnumOfPhaseForListNodePoolsInputUpdating is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputUpdating = "Updating"

	// EnumOfPhaseForListNodePoolsInputScaling is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputScaling = "Scaling"

	// EnumOfPhaseForListNodePoolsInputDeleting is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputDeleting = "Deleting"

	// EnumOfPhaseForListNodePoolsInputFailed is a EnumOfPhaseForListNodePoolsInput enum value
	EnumOfPhaseForListNodePoolsInputFailed = "Failed"
)

const (
	// EnumOfPhaseForListNodePoolsOutputCreating is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputCreating = "Creating"

	// EnumOfPhaseForListNodePoolsOutputRunning is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputRunning = "Running"

	// EnumOfPhaseForListNodePoolsOutputUpdating is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputUpdating = "Updating"

	// EnumOfPhaseForListNodePoolsOutputScaling is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputScaling = "Scaling"

	// EnumOfPhaseForListNodePoolsOutputDeleting is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputDeleting = "Deleting"

	// EnumOfPhaseForListNodePoolsOutputFailed is a EnumOfPhaseForListNodePoolsOutput enum value
	EnumOfPhaseForListNodePoolsOutputFailed = "Failed"
)

const (
	// EnumOfSecurityStrategyListForListNodePoolsOutputHids is a EnumOfSecurityStrategyListForListNodePoolsOutput enum value
	EnumOfSecurityStrategyListForListNodePoolsOutputHids = "Hids"
)

const (
	// EnumOfSubnetPolicyForListNodePoolsOutputZoneBalance is a EnumOfSubnetPolicyForListNodePoolsOutput enum value
	EnumOfSubnetPolicyForListNodePoolsOutputZoneBalance = "ZoneBalance"

	// EnumOfSubnetPolicyForListNodePoolsOutputPriority is a EnumOfSubnetPolicyForListNodePoolsOutput enum value
	EnumOfSubnetPolicyForListNodePoolsOutputPriority = "Priority"
)

const (
	// EnumOfTopologyManagerPolicyForListNodePoolsOutputRestricted is a EnumOfTopologyManagerPolicyForListNodePoolsOutput enum value
	EnumOfTopologyManagerPolicyForListNodePoolsOutputRestricted = "restricted"

	// EnumOfTopologyManagerPolicyForListNodePoolsOutputBestEffort is a EnumOfTopologyManagerPolicyForListNodePoolsOutput enum value
	EnumOfTopologyManagerPolicyForListNodePoolsOutputBestEffort = "best-effort"

	// EnumOfTopologyManagerPolicyForListNodePoolsOutputNone is a EnumOfTopologyManagerPolicyForListNodePoolsOutput enum value
	EnumOfTopologyManagerPolicyForListNodePoolsOutputNone = "none"

	// EnumOfTopologyManagerPolicyForListNodePoolsOutputSingleNumaNode is a EnumOfTopologyManagerPolicyForListNodePoolsOutput enum value
	EnumOfTopologyManagerPolicyForListNodePoolsOutputSingleNumaNode = "single-numa-node"
)

const (
	// EnumOfTopologyManagerScopeForListNodePoolsOutputPod is a EnumOfTopologyManagerScopeForListNodePoolsOutput enum value
	EnumOfTopologyManagerScopeForListNodePoolsOutputPod = "pod"

	// EnumOfTopologyManagerScopeForListNodePoolsOutputContainer is a EnumOfTopologyManagerScopeForListNodePoolsOutput enum value
	EnumOfTopologyManagerScopeForListNodePoolsOutputContainer = "container"
)

const (
	// EnumOfTypeForListNodePoolsOutputEssdPl0 is a EnumOfTypeForListNodePoolsOutput enum value
	EnumOfTypeForListNodePoolsOutputEssdPl0 = "ESSD_PL0"

	// EnumOfTypeForListNodePoolsOutputEssdFlexPl is a EnumOfTypeForListNodePoolsOutput enum value
	EnumOfTypeForListNodePoolsOutputEssdFlexPl = "ESSD_FlexPL"
)
