// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDataFlowTaskCommon = "CreateDataFlowTask"

// CreateDataFlowTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataFlowTaskCommon operation. The "output" return
// value will be populated with the CreateDataFlowTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataFlowTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataFlowTaskCommon Send returns without error.
//
// See CreateDataFlowTaskCommon for more information on using the CreateDataFlowTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDataFlowTaskCommonRequest method.
//    req, resp := client.CreateDataFlowTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateDataFlowTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDataFlowTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataFlowTaskCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateDataFlowTaskCommon for usage and error information.
func (c *VEPFS) CreateDataFlowTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDataFlowTaskCommonRequest(input)
	return out, req.Send()
}

// CreateDataFlowTaskCommonWithContext is the same as CreateDataFlowTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataFlowTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateDataFlowTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDataFlowTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataFlowTask = "CreateDataFlowTask"

// CreateDataFlowTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataFlowTask operation. The "output" return
// value will be populated with the CreateDataFlowTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataFlowTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataFlowTaskCommon Send returns without error.
//
// See CreateDataFlowTask for more information on using the CreateDataFlowTask
// API call, and error handling.
//
//    // Example sending a request using the CreateDataFlowTaskRequest method.
//    req, resp := client.CreateDataFlowTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateDataFlowTaskRequest(input *CreateDataFlowTaskInput) (req *request.Request, output *CreateDataFlowTaskOutput) {
	op := &request.Operation{
		Name:       opCreateDataFlowTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataFlowTaskInput{}
	}

	output = &CreateDataFlowTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataFlowTask API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateDataFlowTask for usage and error information.
func (c *VEPFS) CreateDataFlowTask(input *CreateDataFlowTaskInput) (*CreateDataFlowTaskOutput, error) {
	req, out := c.CreateDataFlowTaskRequest(input)
	return out, req.Send()
}

// CreateDataFlowTaskWithContext is the same as CreateDataFlowTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataFlowTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateDataFlowTaskWithContext(ctx volcengine.Context, input *CreateDataFlowTaskInput, opts ...request.Option) (*CreateDataFlowTaskOutput, error) {
	req, out := c.CreateDataFlowTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDataFlowTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DataStorage *string `type:"string" json:",omitempty"`

	DataStoragePath *string `type:"string" json:",omitempty"`

	// DataType is a required field
	DataType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfDataTypeForCreateDataFlowTaskInput"`

	EntryListFileInfo *EntryListFileInfoForCreateDataFlowTaskInput `type:"structure" json:",omitempty"`

	ExportSymlinkPolicy *string `type:"string" json:",omitempty" enum:"EnumOfExportSymlinkPolicyForCreateDataFlowTaskInput"`

	// FileSystemId is a required field
	FileSystemId *string `type:"string" json:",omitempty" required:"true"`

	FilesetId *string `type:"string" json:",omitempty"`

	SameNameFilePolicy *string `type:"string" json:",omitempty" enum:"EnumOfSameNameFilePolicyForCreateDataFlowTaskInput"`

	SubPath *string `type:"string" json:",omitempty"`

	// TaskAction is a required field
	TaskAction *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfTaskActionForCreateDataFlowTaskInput"`
}

// String returns the string representation
func (s CreateDataFlowTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataFlowTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataFlowTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataFlowTaskInput"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.TaskAction == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskAction"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataStorage sets the DataStorage field's value.
func (s *CreateDataFlowTaskInput) SetDataStorage(v string) *CreateDataFlowTaskInput {
	s.DataStorage = &v
	return s
}

// SetDataStoragePath sets the DataStoragePath field's value.
func (s *CreateDataFlowTaskInput) SetDataStoragePath(v string) *CreateDataFlowTaskInput {
	s.DataStoragePath = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CreateDataFlowTaskInput) SetDataType(v string) *CreateDataFlowTaskInput {
	s.DataType = &v
	return s
}

// SetEntryListFileInfo sets the EntryListFileInfo field's value.
func (s *CreateDataFlowTaskInput) SetEntryListFileInfo(v *EntryListFileInfoForCreateDataFlowTaskInput) *CreateDataFlowTaskInput {
	s.EntryListFileInfo = v
	return s
}

// SetExportSymlinkPolicy sets the ExportSymlinkPolicy field's value.
func (s *CreateDataFlowTaskInput) SetExportSymlinkPolicy(v string) *CreateDataFlowTaskInput {
	s.ExportSymlinkPolicy = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateDataFlowTaskInput) SetFileSystemId(v string) *CreateDataFlowTaskInput {
	s.FileSystemId = &v
	return s
}

// SetFilesetId sets the FilesetId field's value.
func (s *CreateDataFlowTaskInput) SetFilesetId(v string) *CreateDataFlowTaskInput {
	s.FilesetId = &v
	return s
}

// SetSameNameFilePolicy sets the SameNameFilePolicy field's value.
func (s *CreateDataFlowTaskInput) SetSameNameFilePolicy(v string) *CreateDataFlowTaskInput {
	s.SameNameFilePolicy = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *CreateDataFlowTaskInput) SetSubPath(v string) *CreateDataFlowTaskInput {
	s.SubPath = &v
	return s
}

// SetTaskAction sets the TaskAction field's value.
func (s *CreateDataFlowTaskInput) SetTaskAction(v string) *CreateDataFlowTaskInput {
	s.TaskAction = &v
	return s
}

type CreateDataFlowTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DataFlowTaskId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDataFlowTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataFlowTaskOutput) GoString() string {
	return s.String()
}

// SetDataFlowTaskId sets the DataFlowTaskId field's value.
func (s *CreateDataFlowTaskOutput) SetDataFlowTaskId(v string) *CreateDataFlowTaskOutput {
	s.DataFlowTaskId = &v
	return s
}

type EntryListFileInfoForCreateDataFlowTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileBucket *string `type:"string" json:",omitempty"`

	FileKey *string `type:"string" json:",omitempty"`

	FileName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EntryListFileInfoForCreateDataFlowTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EntryListFileInfoForCreateDataFlowTaskInput) GoString() string {
	return s.String()
}

// SetFileBucket sets the FileBucket field's value.
func (s *EntryListFileInfoForCreateDataFlowTaskInput) SetFileBucket(v string) *EntryListFileInfoForCreateDataFlowTaskInput {
	s.FileBucket = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *EntryListFileInfoForCreateDataFlowTaskInput) SetFileKey(v string) *EntryListFileInfoForCreateDataFlowTaskInput {
	s.FileKey = &v
	return s
}

// SetFileName sets the FileName field's value.
func (s *EntryListFileInfoForCreateDataFlowTaskInput) SetFileName(v string) *EntryListFileInfoForCreateDataFlowTaskInput {
	s.FileName = &v
	return s
}

const (
	// EnumOfDataTypeForCreateDataFlowTaskInputMetadata is a EnumOfDataTypeForCreateDataFlowTaskInput enum value
	EnumOfDataTypeForCreateDataFlowTaskInputMetadata = "Metadata"

	// EnumOfDataTypeForCreateDataFlowTaskInputMetaAndData is a EnumOfDataTypeForCreateDataFlowTaskInput enum value
	EnumOfDataTypeForCreateDataFlowTaskInputMetaAndData = "MetaAndData"
)

const (
	// EnumOfExportSymlinkPolicyForCreateDataFlowTaskInputSkip is a EnumOfExportSymlinkPolicyForCreateDataFlowTaskInput enum value
	EnumOfExportSymlinkPolicyForCreateDataFlowTaskInputSkip = "Skip"

	// EnumOfExportSymlinkPolicyForCreateDataFlowTaskInputNormalFile is a EnumOfExportSymlinkPolicyForCreateDataFlowTaskInput enum value
	EnumOfExportSymlinkPolicyForCreateDataFlowTaskInputNormalFile = "NormalFile"
)

const (
	// EnumOfSameNameFilePolicyForCreateDataFlowTaskInputSkip is a EnumOfSameNameFilePolicyForCreateDataFlowTaskInput enum value
	EnumOfSameNameFilePolicyForCreateDataFlowTaskInputSkip = "Skip"

	// EnumOfSameNameFilePolicyForCreateDataFlowTaskInputKeepLatest is a EnumOfSameNameFilePolicyForCreateDataFlowTaskInput enum value
	EnumOfSameNameFilePolicyForCreateDataFlowTaskInputKeepLatest = "KeepLatest"

	// EnumOfSameNameFilePolicyForCreateDataFlowTaskInputOverWrite is a EnumOfSameNameFilePolicyForCreateDataFlowTaskInput enum value
	EnumOfSameNameFilePolicyForCreateDataFlowTaskInputOverWrite = "OverWrite"
)

const (
	// EnumOfTaskActionForCreateDataFlowTaskInputImport is a EnumOfTaskActionForCreateDataFlowTaskInput enum value
	EnumOfTaskActionForCreateDataFlowTaskInputImport = "Import"

	// EnumOfTaskActionForCreateDataFlowTaskInputExport is a EnumOfTaskActionForCreateDataFlowTaskInput enum value
	EnumOfTaskActionForCreateDataFlowTaskInputExport = "Export"

	// EnumOfTaskActionForCreateDataFlowTaskInputInventory is a EnumOfTaskActionForCreateDataFlowTaskInput enum value
	EnumOfTaskActionForCreateDataFlowTaskInputInventory = "Inventory"
)
