// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package veiapi

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateDeploymentCommon = "UpdateDeployment"

// UpdateDeploymentCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateDeploymentCommon operation. The "output" return
// value will be populated with the UpdateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateDeploymentCommon Send returns without error.
//
// See UpdateDeploymentCommon for more information on using the UpdateDeploymentCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateDeploymentCommonRequest method.
//    req, resp := client.UpdateDeploymentCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) UpdateDeploymentCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateDeploymentCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateDeploymentCommon API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation UpdateDeploymentCommon for usage and error information.
func (c *VEIAPI) UpdateDeploymentCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateDeploymentCommonRequest(input)
	return out, req.Send()
}

// UpdateDeploymentCommonWithContext is the same as UpdateDeploymentCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeploymentCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) UpdateDeploymentCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateDeploymentCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeployment = "UpdateDeployment"

// UpdateDeploymentRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateDeployment operation. The "output" return
// value will be populated with the UpdateDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateDeploymentCommon Send returns without error.
//
// See UpdateDeployment for more information on using the UpdateDeployment
// API call, and error handling.
//
//    // Example sending a request using the UpdateDeploymentRequest method.
//    req, resp := client.UpdateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) UpdateDeploymentRequest(input *UpdateDeploymentInput) (req *request.Request, output *UpdateDeploymentOutput) {
	op := &request.Operation{
		Name:       opUpdateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentInput{}
	}

	output = &UpdateDeploymentOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateDeployment API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation UpdateDeployment for usage and error information.
func (c *VEIAPI) UpdateDeployment(input *UpdateDeploymentInput) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	return out, req.Send()
}

// UpdateDeploymentWithContext is the same as UpdateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) UpdateDeploymentWithContext(ctx volcengine.Context, input *UpdateDeploymentInput, opts ...request.Option) (*UpdateDeploymentOutput, error) {
	req, out := c.UpdateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConfigForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config_type *int32 `type:"int32" json:"config_type,omitempty"`

	Container_path *string `type:"string" json:"container_path,omitempty"`

	Name *string `min:"1" max:"63" type:"string" json:"name,omitempty"`
}

// String returns the string representation
func (s ConfigForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigForUpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigForUpdateDeploymentInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 63 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 63, *s.Name))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig_type sets the Config_type field's value.
func (s *ConfigForUpdateDeploymentInput) SetConfig_type(v int32) *ConfigForUpdateDeploymentInput {
	s.Config_type = &v
	return s
}

// SetContainer_path sets the Container_path field's value.
func (s *ConfigForUpdateDeploymentInput) SetContainer_path(v string) *ConfigForUpdateDeploymentInput {
	s.Container_path = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigForUpdateDeploymentInput) SetName(v string) *ConfigForUpdateDeploymentInput {
	s.Name = &v
	return s
}

type ConfigmapForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Configmap_name *string `type:"string" json:"configmap_name,omitempty"`
}

// String returns the string representation
func (s ConfigmapForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigmapForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetConfigmap_name sets the Configmap_name field's value.
func (s *ConfigmapForUpdateDeploymentInput) SetConfigmap_name(v string) *ConfigmapForUpdateDeploymentInput {
	s.Configmap_name = &v
	return s
}

type ContainerForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Args []*string `type:"list" json:"args,omitempty"`

	Command []*string `type:"list" json:"command,omitempty"`

	Configs []*ConfigForUpdateDeploymentInput `type:"list" json:"configs,omitempty"`

	Device_mounted *bool `type:"boolean" json:"device_mounted,omitempty"`

	Env []*EnvForUpdateDeploymentInput `type:"list" json:"env,omitempty"`

	Image *string `type:"string" json:"image,omitempty"`

	Inited *bool `type:"boolean" json:"inited,omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Ports []*PortForUpdateDeploymentInput `type:"list" json:"ports,omitempty"`

	Post_start []*string `type:"list" json:"post_start,omitempty"`

	Pre_stop []*string `type:"list" json:"pre_stop,omitempty"`

	Privileged *bool `type:"boolean" json:"privileged,omitempty"`

	Resources *ResourcesForUpdateDeploymentInput `type:"structure" json:"resources,omitempty"`

	Volume_devices []*Volume_deviceForUpdateDeploymentInput `type:"list" json:"volume_devices,omitempty"`

	Volume_mounts []*Volume_mountForUpdateDeploymentInput `type:"list" json:"volume_mounts,omitempty"`
}

// String returns the string representation
func (s ContainerForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerForUpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerForUpdateDeploymentInput"}
	if s.Configs != nil {
		for i, v := range s.Configs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ports != nil {
		for i, v := range s.Ports {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ports", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *ContainerForUpdateDeploymentInput) SetArgs(v []*string) *ContainerForUpdateDeploymentInput {
	s.Args = v
	return s
}

// SetCommand sets the Command field's value.
func (s *ContainerForUpdateDeploymentInput) SetCommand(v []*string) *ContainerForUpdateDeploymentInput {
	s.Command = v
	return s
}

// SetConfigs sets the Configs field's value.
func (s *ContainerForUpdateDeploymentInput) SetConfigs(v []*ConfigForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Configs = v
	return s
}

// SetDevice_mounted sets the Device_mounted field's value.
func (s *ContainerForUpdateDeploymentInput) SetDevice_mounted(v bool) *ContainerForUpdateDeploymentInput {
	s.Device_mounted = &v
	return s
}

// SetEnv sets the Env field's value.
func (s *ContainerForUpdateDeploymentInput) SetEnv(v []*EnvForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Env = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerForUpdateDeploymentInput) SetImage(v string) *ContainerForUpdateDeploymentInput {
	s.Image = &v
	return s
}

// SetInited sets the Inited field's value.
func (s *ContainerForUpdateDeploymentInput) SetInited(v bool) *ContainerForUpdateDeploymentInput {
	s.Inited = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerForUpdateDeploymentInput) SetName(v string) *ContainerForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *ContainerForUpdateDeploymentInput) SetPorts(v []*PortForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Ports = v
	return s
}

// SetPost_start sets the Post_start field's value.
func (s *ContainerForUpdateDeploymentInput) SetPost_start(v []*string) *ContainerForUpdateDeploymentInput {
	s.Post_start = v
	return s
}

// SetPre_stop sets the Pre_stop field's value.
func (s *ContainerForUpdateDeploymentInput) SetPre_stop(v []*string) *ContainerForUpdateDeploymentInput {
	s.Pre_stop = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerForUpdateDeploymentInput) SetPrivileged(v bool) *ContainerForUpdateDeploymentInput {
	s.Privileged = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ContainerForUpdateDeploymentInput) SetResources(v *ResourcesForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Resources = v
	return s
}

// SetVolume_devices sets the Volume_devices field's value.
func (s *ContainerForUpdateDeploymentInput) SetVolume_devices(v []*Volume_deviceForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Volume_devices = v
	return s
}

// SetVolume_mounts sets the Volume_mounts field's value.
func (s *ContainerForUpdateDeploymentInput) SetVolume_mounts(v []*Volume_mountForUpdateDeploymentInput) *ContainerForUpdateDeploymentInput {
	s.Volume_mounts = v
	return s
}

type DeploymentForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Node_list []*string `type:"list" json:"node_list,omitempty"`

	Replicas *int32 `max:"10" type:"int32" json:"replicas,omitempty"`

	Strategy *StrategyForUpdateDeploymentInput `type:"structure" json:"strategy,omitempty"`

	Template *TemplateForUpdateDeploymentInput `type:"structure" json:"template,omitempty"`
}

// String returns the string representation
func (s DeploymentForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentForUpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentForUpdateDeploymentInput"}
	if s.Replicas != nil && *s.Replicas > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("Replicas", 10))
	}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNode_list sets the Node_list field's value.
func (s *DeploymentForUpdateDeploymentInput) SetNode_list(v []*string) *DeploymentForUpdateDeploymentInput {
	s.Node_list = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *DeploymentForUpdateDeploymentInput) SetReplicas(v int32) *DeploymentForUpdateDeploymentInput {
	s.Replicas = &v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *DeploymentForUpdateDeploymentInput) SetStrategy(v *StrategyForUpdateDeploymentInput) *DeploymentForUpdateDeploymentInput {
	s.Strategy = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *DeploymentForUpdateDeploymentInput) SetTemplate(v *TemplateForUpdateDeploymentInput) *DeploymentForUpdateDeploymentInput {
	s.Template = v
	return s
}

type Empty_dirForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:"name,omitempty"`
}

// String returns the string representation
func (s Empty_dirForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Empty_dirForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Empty_dirForUpdateDeploymentInput) SetName(v string) *Empty_dirForUpdateDeploymentInput {
	s.Name = &v
	return s
}

type EnvForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Value *string `type:"string" json:"value,omitempty"`

	Value_type *int32 `type:"int32" json:"value_type,omitempty"`
}

// String returns the string representation
func (s EnvForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvForUpdateDeploymentInput) SetName(v string) *EnvForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForUpdateDeploymentInput) SetValue(v string) *EnvForUpdateDeploymentInput {
	s.Value = &v
	return s
}

// SetValue_type sets the Value_type field's value.
func (s *EnvForUpdateDeploymentInput) SetValue_type(v int32) *EnvForUpdateDeploymentInput {
	s.Value_type = &v
	return s
}

type Host_pathForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Host_path_type *int32 `type:"int32" json:"host_path_type,omitempty"`

	Path *string `type:"string" json:"path,omitempty"`
}

// String returns the string representation
func (s Host_pathForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Host_pathForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetHost_path_type sets the Host_path_type field's value.
func (s *Host_pathForUpdateDeploymentInput) SetHost_path_type(v int32) *Host_pathForUpdateDeploymentInput {
	s.Host_path_type = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Host_pathForUpdateDeploymentInput) SetPath(v string) *Host_pathForUpdateDeploymentInput {
	s.Path = &v
	return s
}

type PortForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Container_port *int32 `max:"65535" type:"int32" json:"container_port,omitempty"`

	Host_port *int32 `max:"65535" type:"int32" json:"host_port,omitempty"`

	Protocol *string `type:"string" json:"protocol,omitempty"`
}

// String returns the string representation
func (s PortForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortForUpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortForUpdateDeploymentInput"}
	if s.Container_port != nil && *s.Container_port > 65535 {
		invalidParams.Add(request.NewErrParamMaxValue("Container_port", 65535))
	}
	if s.Host_port != nil && *s.Host_port > 65535 {
		invalidParams.Add(request.NewErrParamMaxValue("Host_port", 65535))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainer_port sets the Container_port field's value.
func (s *PortForUpdateDeploymentInput) SetContainer_port(v int32) *PortForUpdateDeploymentInput {
	s.Container_port = &v
	return s
}

// SetHost_port sets the Host_port field's value.
func (s *PortForUpdateDeploymentInput) SetHost_port(v int32) *PortForUpdateDeploymentInput {
	s.Host_port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortForUpdateDeploymentInput) SetProtocol(v string) *PortForUpdateDeploymentInput {
	s.Protocol = &v
	return s
}

type PvcForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Pvc_name *string `type:"string" json:"pvc_name,omitempty"`
}

// String returns the string representation
func (s PvcForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PvcForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetPvc_name sets the Pvc_name field's value.
func (s *PvcForUpdateDeploymentInput) SetPvc_name(v string) *PvcForUpdateDeploymentInput {
	s.Pvc_name = &v
	return s
}

type ResourcesForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu_limit *float64 `type:"double" json:"cpu_limit,omitempty"`

	Cpu_request *float64 `type:"double" json:"cpu_request,omitempty"`

	Memory_limit *int64 `type:"int64" json:"memory_limit,omitempty"`

	Memory_limit_unit *string `type:"string" json:"memory_limit_unit,omitempty"`

	Memory_request *int64 `type:"int64" json:"memory_request,omitempty"`

	Memory_request_unit *string `type:"string" json:"memory_request_unit,omitempty"`
}

// String returns the string representation
func (s ResourcesForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcesForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetCpu_limit sets the Cpu_limit field's value.
func (s *ResourcesForUpdateDeploymentInput) SetCpu_limit(v float64) *ResourcesForUpdateDeploymentInput {
	s.Cpu_limit = &v
	return s
}

// SetCpu_request sets the Cpu_request field's value.
func (s *ResourcesForUpdateDeploymentInput) SetCpu_request(v float64) *ResourcesForUpdateDeploymentInput {
	s.Cpu_request = &v
	return s
}

// SetMemory_limit sets the Memory_limit field's value.
func (s *ResourcesForUpdateDeploymentInput) SetMemory_limit(v int64) *ResourcesForUpdateDeploymentInput {
	s.Memory_limit = &v
	return s
}

// SetMemory_limit_unit sets the Memory_limit_unit field's value.
func (s *ResourcesForUpdateDeploymentInput) SetMemory_limit_unit(v string) *ResourcesForUpdateDeploymentInput {
	s.Memory_limit_unit = &v
	return s
}

// SetMemory_request sets the Memory_request field's value.
func (s *ResourcesForUpdateDeploymentInput) SetMemory_request(v int64) *ResourcesForUpdateDeploymentInput {
	s.Memory_request = &v
	return s
}

// SetMemory_request_unit sets the Memory_request_unit field's value.
func (s *ResourcesForUpdateDeploymentInput) SetMemory_request_unit(v string) *ResourcesForUpdateDeploymentInput {
	s.Memory_request_unit = &v
	return s
}

type RollingForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Max_surge *int32 `type:"int32" json:"max_surge,omitempty"`

	Max_unavailable *int32 `type:"int32" json:"max_unavailable,omitempty"`
}

// String returns the string representation
func (s RollingForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RollingForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetMax_surge sets the Max_surge field's value.
func (s *RollingForUpdateDeploymentInput) SetMax_surge(v int32) *RollingForUpdateDeploymentInput {
	s.Max_surge = &v
	return s
}

// SetMax_unavailable sets the Max_unavailable field's value.
func (s *RollingForUpdateDeploymentInput) SetMax_unavailable(v int32) *RollingForUpdateDeploymentInput {
	s.Max_unavailable = &v
	return s
}

type SecretForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Secret_name *string `type:"string" json:"secret_name,omitempty"`
}

// String returns the string representation
func (s SecretForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetSecret_name sets the Secret_name field's value.
func (s *SecretForUpdateDeploymentInput) SetSecret_name(v string) *SecretForUpdateDeploymentInput {
	s.Secret_name = &v
	return s
}

type StrategyForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Rolling *RollingForUpdateDeploymentInput `type:"structure" json:"rolling,omitempty"`

	Strategy_type *int32 `type:"int32" json:"strategy_type,omitempty"`
}

// String returns the string representation
func (s StrategyForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetRolling sets the Rolling field's value.
func (s *StrategyForUpdateDeploymentInput) SetRolling(v *RollingForUpdateDeploymentInput) *StrategyForUpdateDeploymentInput {
	s.Rolling = v
	return s
}

// SetStrategy_type sets the Strategy_type field's value.
func (s *StrategyForUpdateDeploymentInput) SetStrategy_type(v int32) *StrategyForUpdateDeploymentInput {
	s.Strategy_type = &v
	return s
}

type TemplateForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Containers []*ContainerForUpdateDeploymentInput `type:"list" json:"containers,omitempty"`

	Dns_policy *int32 `type:"int32" json:"dns_policy,omitempty"`

	Image_secrets []*string `type:"list" json:"image_secrets,omitempty"`

	Volumes []*VolumeForUpdateDeploymentInput `type:"list" json:"volumes,omitempty"`
}

// String returns the string representation
func (s TemplateForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateForUpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateForUpdateDeploymentInput"}
	if s.Containers != nil {
		for i, v := range s.Containers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Containers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainers sets the Containers field's value.
func (s *TemplateForUpdateDeploymentInput) SetContainers(v []*ContainerForUpdateDeploymentInput) *TemplateForUpdateDeploymentInput {
	s.Containers = v
	return s
}

// SetDns_policy sets the Dns_policy field's value.
func (s *TemplateForUpdateDeploymentInput) SetDns_policy(v int32) *TemplateForUpdateDeploymentInput {
	s.Dns_policy = &v
	return s
}

// SetImage_secrets sets the Image_secrets field's value.
func (s *TemplateForUpdateDeploymentInput) SetImage_secrets(v []*string) *TemplateForUpdateDeploymentInput {
	s.Image_secrets = v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *TemplateForUpdateDeploymentInput) SetVolumes(v []*VolumeForUpdateDeploymentInput) *TemplateForUpdateDeploymentInput {
	s.Volumes = v
	return s
}

type UpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Deployment *DeploymentForUpdateDeploymentInput `type:"structure" json:"deployment,omitempty"`

	// Deployment_id is a required field
	Deployment_id *string `type:"string" json:"deployment_id,omitempty" required:"true"`

	// Name is a required field
	Name *string `type:"string" json:"name,omitempty" required:"true"`

	// Project_id is a required field
	Project_id *string `type:"string" json:"project_id,omitempty" required:"true"`
}

// String returns the string representation
func (s UpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentInput"}
	if s.Deployment_id == nil {
		invalidParams.Add(request.NewErrParamRequired("Deployment_id"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Project_id == nil {
		invalidParams.Add(request.NewErrParamRequired("Project_id"))
	}
	if s.Deployment != nil {
		if err := s.Deployment.Validate(); err != nil {
			invalidParams.AddNested("Deployment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeployment sets the Deployment field's value.
func (s *UpdateDeploymentInput) SetDeployment(v *DeploymentForUpdateDeploymentInput) *UpdateDeploymentInput {
	s.Deployment = v
	return s
}

// SetDeployment_id sets the Deployment_id field's value.
func (s *UpdateDeploymentInput) SetDeployment_id(v string) *UpdateDeploymentInput {
	s.Deployment_id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDeploymentInput) SetName(v string) *UpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *UpdateDeploymentInput) SetProject_id(v string) *UpdateDeploymentInput {
	s.Project_id = &v
	return s
}

type UpdateDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Deployment_id *string `type:"string" json:"deployment_id,omitempty"`

	Project_id *string `type:"string" json:"project_id,omitempty"`
}

// String returns the string representation
func (s UpdateDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeployment_id sets the Deployment_id field's value.
func (s *UpdateDeploymentOutput) SetDeployment_id(v string) *UpdateDeploymentOutput {
	s.Deployment_id = &v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *UpdateDeploymentOutput) SetProject_id(v string) *UpdateDeploymentOutput {
	s.Project_id = &v
	return s
}

type VolumeForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Configmap *ConfigmapForUpdateDeploymentInput `type:"structure" json:"configmap,omitempty"`

	Empty_dir *Empty_dirForUpdateDeploymentInput `type:"structure" json:"empty_dir,omitempty"`

	Host_path *Host_pathForUpdateDeploymentInput `type:"structure" json:"host_path,omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Pvc *PvcForUpdateDeploymentInput `type:"structure" json:"pvc,omitempty"`

	Secret *SecretForUpdateDeploymentInput `type:"structure" json:"secret,omitempty"`

	Source_type *int32 `type:"int32" json:"source_type,omitempty"`
}

// String returns the string representation
func (s VolumeForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetConfigmap sets the Configmap field's value.
func (s *VolumeForUpdateDeploymentInput) SetConfigmap(v *ConfigmapForUpdateDeploymentInput) *VolumeForUpdateDeploymentInput {
	s.Configmap = v
	return s
}

// SetEmpty_dir sets the Empty_dir field's value.
func (s *VolumeForUpdateDeploymentInput) SetEmpty_dir(v *Empty_dirForUpdateDeploymentInput) *VolumeForUpdateDeploymentInput {
	s.Empty_dir = v
	return s
}

// SetHost_path sets the Host_path field's value.
func (s *VolumeForUpdateDeploymentInput) SetHost_path(v *Host_pathForUpdateDeploymentInput) *VolumeForUpdateDeploymentInput {
	s.Host_path = v
	return s
}

// SetName sets the Name field's value.
func (s *VolumeForUpdateDeploymentInput) SetName(v string) *VolumeForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetPvc sets the Pvc field's value.
func (s *VolumeForUpdateDeploymentInput) SetPvc(v *PvcForUpdateDeploymentInput) *VolumeForUpdateDeploymentInput {
	s.Pvc = v
	return s
}

// SetSecret sets the Secret field's value.
func (s *VolumeForUpdateDeploymentInput) SetSecret(v *SecretForUpdateDeploymentInput) *VolumeForUpdateDeploymentInput {
	s.Secret = v
	return s
}

// SetSource_type sets the Source_type field's value.
func (s *VolumeForUpdateDeploymentInput) SetSource_type(v int32) *VolumeForUpdateDeploymentInput {
	s.Source_type = &v
	return s
}

type Volume_deviceForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Device_path *string `type:"string" json:"device_path,omitempty"`

	Name *string `type:"string" json:"name,omitempty"`
}

// String returns the string representation
func (s Volume_deviceForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume_deviceForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetDevice_path sets the Device_path field's value.
func (s *Volume_deviceForUpdateDeploymentInput) SetDevice_path(v string) *Volume_deviceForUpdateDeploymentInput {
	s.Device_path = &v
	return s
}

// SetName sets the Name field's value.
func (s *Volume_deviceForUpdateDeploymentInput) SetName(v string) *Volume_deviceForUpdateDeploymentInput {
	s.Name = &v
	return s
}

type Volume_mountForUpdateDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Mount_path *string `type:"string" json:"mount_path,omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Read_only *bool `type:"boolean" json:"read_only,omitempty"`

	Sub_path *string `type:"string" json:"sub_path,omitempty"`
}

// String returns the string representation
func (s Volume_mountForUpdateDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume_mountForUpdateDeploymentInput) GoString() string {
	return s.String()
}

// SetMount_path sets the Mount_path field's value.
func (s *Volume_mountForUpdateDeploymentInput) SetMount_path(v string) *Volume_mountForUpdateDeploymentInput {
	s.Mount_path = &v
	return s
}

// SetName sets the Name field's value.
func (s *Volume_mountForUpdateDeploymentInput) SetName(v string) *Volume_mountForUpdateDeploymentInput {
	s.Name = &v
	return s
}

// SetRead_only sets the Read_only field's value.
func (s *Volume_mountForUpdateDeploymentInput) SetRead_only(v bool) *Volume_mountForUpdateDeploymentInput {
	s.Read_only = &v
	return s
}

// SetSub_path sets the Sub_path field's value.
func (s *Volume_mountForUpdateDeploymentInput) SetSub_path(v string) *Volume_mountForUpdateDeploymentInput {
	s.Sub_path = &v
	return s
}
