// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package storageebs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifySnapshotAttributeCommon = "ModifySnapshotAttribute"

// ModifySnapshotAttributeCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifySnapshotAttributeCommon operation. The "output" return
// value will be populated with the ModifySnapshotAttributeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifySnapshotAttributeCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifySnapshotAttributeCommon Send returns without error.
//
// See ModifySnapshotAttributeCommon for more information on using the ModifySnapshotAttributeCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifySnapshotAttributeCommonRequest method.
//    req, resp := client.ModifySnapshotAttributeCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) ModifySnapshotAttributeCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifySnapshotAttributeCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifySnapshotAttributeCommon API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation ModifySnapshotAttributeCommon for usage and error information.
func (c *STORAGEEBS) ModifySnapshotAttributeCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifySnapshotAttributeCommonRequest(input)
	return out, req.Send()
}

// ModifySnapshotAttributeCommonWithContext is the same as ModifySnapshotAttributeCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySnapshotAttributeCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) ModifySnapshotAttributeCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifySnapshotAttributeCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySnapshotAttribute = "ModifySnapshotAttribute"

// ModifySnapshotAttributeRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifySnapshotAttribute operation. The "output" return
// value will be populated with the ModifySnapshotAttributeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifySnapshotAttributeCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifySnapshotAttributeCommon Send returns without error.
//
// See ModifySnapshotAttribute for more information on using the ModifySnapshotAttribute
// API call, and error handling.
//
//    // Example sending a request using the ModifySnapshotAttributeRequest method.
//    req, resp := client.ModifySnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) ModifySnapshotAttributeRequest(input *ModifySnapshotAttributeInput) (req *request.Request, output *ModifySnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotAttribute,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotAttributeInput{}
	}

	output = &ModifySnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifySnapshotAttribute API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation ModifySnapshotAttribute for usage and error information.
func (c *STORAGEEBS) ModifySnapshotAttribute(input *ModifySnapshotAttributeInput) (*ModifySnapshotAttributeOutput, error) {
	req, out := c.ModifySnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifySnapshotAttributeWithContext is the same as ModifySnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) ModifySnapshotAttributeWithContext(ctx volcengine.Context, input *ModifySnapshotAttributeInput, opts ...request.Option) (*ModifySnapshotAttributeOutput, error) {
	req, out := c.ModifySnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifySnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	RetentionDays *int32 `min:"1" max:"65536" type:"int32"`

	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`

	SnapshotName *string `type:"string"`
}

// String returns the string representation
func (s ModifySnapshotAttributeInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySnapshotAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySnapshotAttributeInput"}
	if s.RetentionDays != nil && *s.RetentionDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionDays", 1))
	}
	if s.RetentionDays != nil && *s.RetentionDays > 65536 {
		invalidParams.Add(request.NewErrParamMaxValue("RetentionDays", 65536))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ModifySnapshotAttributeInput) SetDescription(v string) *ModifySnapshotAttributeInput {
	s.Description = &v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *ModifySnapshotAttributeInput) SetRetentionDays(v int32) *ModifySnapshotAttributeInput {
	s.RetentionDays = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *ModifySnapshotAttributeInput) SetSnapshotId(v string) *ModifySnapshotAttributeInput {
	s.SnapshotId = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *ModifySnapshotAttributeInput) SetSnapshotName(v string) *ModifySnapshotAttributeInput {
	s.SnapshotName = &v
	return s
}

type ModifySnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ModifySnapshotAttributeOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotAttributeOutput) GoString() string {
	return s.String()
}
