// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opMessageSendCommon = "MessageSend"

// MessageSendCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the MessageSendCommon operation. The "output" return
// value will be populated with the MessageSendCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned MessageSendCommon Request to send the API call to the service.
// the "output" return value is not valid until after MessageSendCommon Send returns without error.
//
// See MessageSendCommon for more information on using the MessageSendCommon
// API call, and error handling.
//
//    // Example sending a request using the MessageSendCommonRequest method.
//    req, resp := client.MessageSendCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) MessageSendCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opMessageSendCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// MessageSendCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation MessageSendCommon for usage and error information.
func (c *ROCKETMQ) MessageSendCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.MessageSendCommonRequest(input)
	return out, req.Send()
}

// MessageSendCommonWithContext is the same as MessageSendCommon with the addition of
// the ability to pass a context and additional request options.
//
// See MessageSendCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) MessageSendCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.MessageSendCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMessageSend = "MessageSend"

// MessageSendRequest generates a "volcengine/request.Request" representing the
// client's request for the MessageSend operation. The "output" return
// value will be populated with the MessageSendCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned MessageSendCommon Request to send the API call to the service.
// the "output" return value is not valid until after MessageSendCommon Send returns without error.
//
// See MessageSend for more information on using the MessageSend
// API call, and error handling.
//
//    // Example sending a request using the MessageSendRequest method.
//    req, resp := client.MessageSendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) MessageSendRequest(input *MessageSendInput) (req *request.Request, output *MessageSendOutput) {
	op := &request.Operation{
		Name:       opMessageSend,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MessageSendInput{}
	}

	output = &MessageSendOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// MessageSend API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation MessageSend for usage and error information.
func (c *ROCKETMQ) MessageSend(input *MessageSendInput) (*MessageSendOutput, error) {
	req, out := c.MessageSendRequest(input)
	return out, req.Send()
}

// MessageSendWithContext is the same as MessageSend with the addition of
// the ability to pass a context and additional request options.
//
// See MessageSend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) MessageSendWithContext(ctx volcengine.Context, input *MessageSendInput, opts ...request.Option) (*MessageSendOutput, error) {
	req, out := c.MessageSendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type MessageSendInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Body is a required field
	Body *string `type:"string" json:",omitempty" required:"true"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	Key *string `type:"string" json:",omitempty"`

	Tag *string `type:"string" json:",omitempty"`

	// Topic is a required field
	Topic *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s MessageSendInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageSendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageSendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageSendInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Topic == nil {
		invalidParams.Add(request.NewErrParamRequired("Topic"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *MessageSendInput) SetBody(v string) *MessageSendInput {
	s.Body = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *MessageSendInput) SetInstanceId(v string) *MessageSendInput {
	s.InstanceId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MessageSendInput) SetKey(v string) *MessageSendInput {
	s.Key = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *MessageSendInput) SetTag(v string) *MessageSendInput {
	s.Tag = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *MessageSendInput) SetTopic(v string) *MessageSendInput {
	s.Topic = &v
	return s
}

type MessageSendOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MsgId *string `type:"string" json:",omitempty"`

	OffsetMsgId *string `type:"string" json:",omitempty"`

	QeueueOffset *int32 `type:"int32" json:",omitempty"`

	SendStatus *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MessageSendOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageSendOutput) GoString() string {
	return s.String()
}

// SetMsgId sets the MsgId field's value.
func (s *MessageSendOutput) SetMsgId(v string) *MessageSendOutput {
	s.MsgId = &v
	return s
}

// SetOffsetMsgId sets the OffsetMsgId field's value.
func (s *MessageSendOutput) SetOffsetMsgId(v string) *MessageSendOutput {
	s.OffsetMsgId = &v
	return s
}

// SetQeueueOffset sets the QeueueOffset field's value.
func (s *MessageSendOutput) SetQeueueOffset(v int32) *MessageSendOutput {
	s.QeueueOffset = &v
	return s
}

// SetSendStatus sets the SendStatus field's value.
func (s *MessageSendOutput) SetSendStatus(v string) *MessageSendOutput {
	s.SendStatus = &v
	return s
}
