// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicsCommon = "DescribeTopics"

// DescribeTopicsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicsCommon operation. The "output" return
// value will be populated with the DescribeTopicsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicsCommon Send returns without error.
//
// See DescribeTopicsCommon for more information on using the DescribeTopicsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicsCommonRequest method.
//    req, resp := client.DescribeTopicsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicsCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicsCommon for usage and error information.
func (c *ROCKETMQ) DescribeTopicsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicsCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicsCommonWithContext is the same as DescribeTopicsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopics = "DescribeTopics"

// DescribeTopicsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopics operation. The "output" return
// value will be populated with the DescribeTopicsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicsCommon Send returns without error.
//
// See DescribeTopics for more information on using the DescribeTopics
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicsRequest method.
//    req, resp := client.DescribeTopicsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicsRequest(input *DescribeTopicsInput) (req *request.Request, output *DescribeTopicsOutput) {
	op := &request.Operation{
		Name:       opDescribeTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsInput{}
	}

	output = &DescribeTopicsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopics API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopics for usage and error information.
func (c *ROCKETMQ) DescribeTopics(input *DescribeTopicsInput) (*DescribeTopicsOutput, error) {
	req, out := c.DescribeTopicsRequest(input)
	return out, req.Send()
}

// DescribeTopicsWithContext is the same as DescribeTopics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicsWithContext(ctx volcengine.Context, input *DescribeTopicsInput, opts ...request.Option) (*DescribeTopicsOutput, error) {
	req, out := c.DescribeTopicsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeTopicsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	MessageType *int32 `type:"int32" json:",omitempty"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty" required:"true"`

	SortBy *string `type:"string" json:",omitempty"`

	SortOrder *string `type:"string" json:",omitempty"`

	TopicName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicsInput) SetInstanceId(v string) *DescribeTopicsInput {
	s.InstanceId = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *DescribeTopicsInput) SetMessageType(v int32) *DescribeTopicsInput {
	s.MessageType = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicsInput) SetPageNumber(v int32) *DescribeTopicsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicsInput) SetPageSize(v int32) *DescribeTopicsInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *DescribeTopicsInput) SetSortBy(v string) *DescribeTopicsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *DescribeTopicsInput) SetSortOrder(v string) *DescribeTopicsInput {
	s.SortOrder = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicsInput) SetTopicName(v string) *DescribeTopicsInput {
	s.TopicName = &v
	return s
}

type DescribeTopicsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	TopicsInfo []*TopicsInfoForDescribeTopicsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicsOutput) SetInstanceId(v string) *DescribeTopicsOutput {
	s.InstanceId = &v
	return s
}

// SetTopicsInfo sets the TopicsInfo field's value.
func (s *DescribeTopicsOutput) SetTopicsInfo(v []*TopicsInfoForDescribeTopicsOutput) *DescribeTopicsOutput {
	s.TopicsInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicsOutput) SetTotal(v int32) *DescribeTopicsOutput {
	s.Total = &v
	return s
}

type TopicsInfoForDescribeTopicsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	MessageType *int32 `type:"int32" json:",omitempty"`

	QueueNumber *int32 `type:"int32" json:",omitempty"`

	TopicName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TopicsInfoForDescribeTopicsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsInfoForDescribeTopicsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetCreateTime(v string) *TopicsInfoForDescribeTopicsOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetDescription(v string) *TopicsInfoForDescribeTopicsOutput {
	s.Description = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetMessageType(v int32) *TopicsInfoForDescribeTopicsOutput {
	s.MessageType = &v
	return s
}

// SetQueueNumber sets the QueueNumber field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetQueueNumber(v int32) *TopicsInfoForDescribeTopicsOutput {
	s.QueueNumber = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetTopicName(v string) *TopicsInfoForDescribeTopicsOutput {
	s.TopicName = &v
	return s
}
