// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcecenter

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opSearchResourcesCommon = "SearchResources"

// SearchResourcesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the SearchResourcesCommon operation. The "output" return
// value will be populated with the SearchResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SearchResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after SearchResourcesCommon Send returns without error.
//
// See SearchResourcesCommon for more information on using the SearchResourcesCommon
// API call, and error handling.
//
//    // Example sending a request using the SearchResourcesCommonRequest method.
//    req, resp := client.SearchResourcesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RESOURCECENTER) SearchResourcesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opSearchResourcesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SearchResourcesCommon API operation for RESOURCECENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RESOURCECENTER's
// API operation SearchResourcesCommon for usage and error information.
func (c *RESOURCECENTER) SearchResourcesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.SearchResourcesCommonRequest(input)
	return out, req.Send()
}

// SearchResourcesCommonWithContext is the same as SearchResourcesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See SearchResourcesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RESOURCECENTER) SearchResourcesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.SearchResourcesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchResources = "SearchResources"

// SearchResourcesRequest generates a "volcengine/request.Request" representing the
// client's request for the SearchResources operation. The "output" return
// value will be populated with the SearchResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SearchResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after SearchResourcesCommon Send returns without error.
//
// See SearchResources for more information on using the SearchResources
// API call, and error handling.
//
//    // Example sending a request using the SearchResourcesRequest method.
//    req, resp := client.SearchResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RESOURCECENTER) SearchResourcesRequest(input *SearchResourcesInput) (req *request.Request, output *SearchResourcesOutput) {
	op := &request.Operation{
		Name:       opSearchResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchResourcesInput{}
	}

	output = &SearchResourcesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SearchResources API operation for RESOURCECENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RESOURCECENTER's
// API operation SearchResources for usage and error information.
func (c *RESOURCECENTER) SearchResources(input *SearchResourcesInput) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	return out, req.Send()
}

// SearchResourcesWithContext is the same as SearchResources with the addition of
// the ability to pass a context and additional request options.
//
// See SearchResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RESOURCECENTER) SearchResourcesWithContext(ctx volcengine.Context, input *SearchResourcesInput, opts ...request.Option) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForSearchResourcesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	MatchType *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForSearchResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForSearchResourcesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *FilterForSearchResourcesInput) SetKey(v string) *FilterForSearchResourcesInput {
	s.Key = &v
	return s
}

// SetMatchType sets the MatchType field's value.
func (s *FilterForSearchResourcesInput) SetMatchType(v string) *FilterForSearchResourcesInput {
	s.MatchType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *FilterForSearchResourcesInput) SetValues(v []*string) *FilterForSearchResourcesInput {
	s.Values = v
	return s
}

type ResourceForSearchResourcesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccountID *int32 `type:"int32" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	PrivateIpAddress []*string `type:"list" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	PublicIpAddress []*string `type:"list" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	ResourceID *string `type:"string" json:",omitempty"`

	ResourceName *string `type:"string" json:",omitempty"`

	ResourceType *string `type:"string" json:",omitempty"`

	Service *string `type:"string" json:",omitempty"`

	Tags []*TagForSearchResourcesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForSearchResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForSearchResourcesOutput) GoString() string {
	return s.String()
}

// SetAccountID sets the AccountID field's value.
func (s *ResourceForSearchResourcesOutput) SetAccountID(v int32) *ResourceForSearchResourcesOutput {
	s.AccountID = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ResourceForSearchResourcesOutput) SetCreateTime(v string) *ResourceForSearchResourcesOutput {
	s.CreateTime = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *ResourceForSearchResourcesOutput) SetPrivateIpAddress(v []*string) *ResourceForSearchResourcesOutput {
	s.PrivateIpAddress = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ResourceForSearchResourcesOutput) SetProjectName(v string) *ResourceForSearchResourcesOutput {
	s.ProjectName = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *ResourceForSearchResourcesOutput) SetPublicIpAddress(v []*string) *ResourceForSearchResourcesOutput {
	s.PublicIpAddress = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ResourceForSearchResourcesOutput) SetRegion(v string) *ResourceForSearchResourcesOutput {
	s.Region = &v
	return s
}

// SetResourceID sets the ResourceID field's value.
func (s *ResourceForSearchResourcesOutput) SetResourceID(v string) *ResourceForSearchResourcesOutput {
	s.ResourceID = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ResourceForSearchResourcesOutput) SetResourceName(v string) *ResourceForSearchResourcesOutput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceForSearchResourcesOutput) SetResourceType(v string) *ResourceForSearchResourcesOutput {
	s.ResourceType = &v
	return s
}

// SetService sets the Service field's value.
func (s *ResourceForSearchResourcesOutput) SetService(v string) *ResourceForSearchResourcesOutput {
	s.Service = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceForSearchResourcesOutput) SetTags(v []*TagForSearchResourcesOutput) *ResourceForSearchResourcesOutput {
	s.Tags = v
	return s
}

type SearchResourcesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter []*FilterForSearchResourcesInput `type:"list" json:",omitempty"`

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForSearchResourcesInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForSearchResourcesInput"`
}

// String returns the string representation
func (s SearchResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesInput) GoString() string {
	return s.String()
}

// SetFilter sets the Filter field's value.
func (s *SearchResourcesInput) SetFilter(v []*FilterForSearchResourcesInput) *SearchResourcesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchResourcesInput) SetMaxResults(v int32) *SearchResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesInput) SetNextToken(v string) *SearchResourcesInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *SearchResourcesInput) SetSortBy(v string) *SearchResourcesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SearchResourcesInput) SetSortOrder(v string) *SearchResourcesInput {
	s.SortOrder = &v
	return s
}

type SearchResourcesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	NextToken *string `type:"string" json:",omitempty"`

	Resources []*ResourceForSearchResourcesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SearchResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesOutput) SetNextToken(v string) *SearchResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *SearchResourcesOutput) SetResources(v []*ResourceForSearchResourcesOutput) *SearchResourcesOutput {
	s.Resources = v
	return s
}

type TagForSearchResourcesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForSearchResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForSearchResourcesOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForSearchResourcesOutput) SetKey(v string) *TagForSearchResourcesOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForSearchResourcesOutput) SetValue(v string) *TagForSearchResourcesOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfSortByForSearchResourcesInputCreateTime is a EnumOfSortByForSearchResourcesInput enum value
	EnumOfSortByForSearchResourcesInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForSearchResourcesInputAsc is a EnumOfSortOrderForSearchResourcesInput enum value
	EnumOfSortOrderForSearchResourcesInputAsc = "Asc"

	// EnumOfSortOrderForSearchResourcesInputDesc is a EnumOfSortOrderForSearchResourcesInput enum value
	EnumOfSortOrderForSearchResourcesInputDesc = "Desc"
)
