// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatezone

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateResolverRuleCommon = "CreateResolverRule"

// CreateResolverRuleCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResolverRuleCommon operation. The "output" return
// value will be populated with the CreateResolverRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResolverRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResolverRuleCommon Send returns without error.
//
// See CreateResolverRuleCommon for more information on using the CreateResolverRuleCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateResolverRuleCommonRequest method.
//    req, resp := client.CreateResolverRuleCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreateResolverRuleCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateResolverRuleCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResolverRuleCommon API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreateResolverRuleCommon for usage and error information.
func (c *PRIVATEZONE) CreateResolverRuleCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateResolverRuleCommonRequest(input)
	return out, req.Send()
}

// CreateResolverRuleCommonWithContext is the same as CreateResolverRuleCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverRuleCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreateResolverRuleCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateResolverRuleCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverRule = "CreateResolverRule"

// CreateResolverRuleRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResolverRule operation. The "output" return
// value will be populated with the CreateResolverRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResolverRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResolverRuleCommon Send returns without error.
//
// See CreateResolverRule for more information on using the CreateResolverRule
// API call, and error handling.
//
//    // Example sending a request using the CreateResolverRuleRequest method.
//    req, resp := client.CreateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreateResolverRuleRequest(input *CreateResolverRuleInput) (req *request.Request, output *CreateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opCreateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverRuleInput{}
	}

	output = &CreateResolverRuleOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResolverRule API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreateResolverRule for usage and error information.
func (c *PRIVATEZONE) CreateResolverRule(input *CreateResolverRuleInput) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	return out, req.Send()
}

// CreateResolverRuleWithContext is the same as CreateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreateResolverRuleWithContext(ctx volcengine.Context, input *CreateResolverRuleInput, opts ...request.Option) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateResolverRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndpointID *int32 `type:"int32" json:",omitempty"`

	EndpointTrn *string `type:"string" json:",omitempty"`

	ForwardIPs []*ForwardIPForCreateResolverRuleInput `type:"list" json:",omitempty"`

	Line *string `type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateResolverRuleInput `type:"list" json:",omitempty"`

	// Type is a required field
	Type *string `type:"string" json:",omitempty" required:"true"`

	VpcTrns []*string `type:"list" json:",omitempty"`

	Vpcs []*VpcForCreateResolverRuleInput `type:"list" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateResolverRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointID sets the EndpointID field's value.
func (s *CreateResolverRuleInput) SetEndpointID(v int32) *CreateResolverRuleInput {
	s.EndpointID = &v
	return s
}

// SetEndpointTrn sets the EndpointTrn field's value.
func (s *CreateResolverRuleInput) SetEndpointTrn(v string) *CreateResolverRuleInput {
	s.EndpointTrn = &v
	return s
}

// SetForwardIPs sets the ForwardIPs field's value.
func (s *CreateResolverRuleInput) SetForwardIPs(v []*ForwardIPForCreateResolverRuleInput) *CreateResolverRuleInput {
	s.ForwardIPs = v
	return s
}

// SetLine sets the Line field's value.
func (s *CreateResolverRuleInput) SetLine(v string) *CreateResolverRuleInput {
	s.Line = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverRuleInput) SetName(v string) *CreateResolverRuleInput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateResolverRuleInput) SetProjectName(v string) *CreateResolverRuleInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverRuleInput) SetTags(v []*TagForCreateResolverRuleInput) *CreateResolverRuleInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateResolverRuleInput) SetType(v string) *CreateResolverRuleInput {
	s.Type = &v
	return s
}

// SetVpcTrns sets the VpcTrns field's value.
func (s *CreateResolverRuleInput) SetVpcTrns(v []*string) *CreateResolverRuleInput {
	s.VpcTrns = v
	return s
}

// SetVpcs sets the Vpcs field's value.
func (s *CreateResolverRuleInput) SetVpcs(v []*VpcForCreateResolverRuleInput) *CreateResolverRuleInput {
	s.Vpcs = v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *CreateResolverRuleInput) SetZoneName(v string) *CreateResolverRuleInput {
	s.ZoneName = &v
	return s
}

type CreateResolverRuleOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	RuleID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CreateResolverRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetRuleID sets the RuleID field's value.
func (s *CreateResolverRuleOutput) SetRuleID(v int64) *CreateResolverRuleOutput {
	s.RuleID = &v
	return s
}

type ForwardIPForCreateResolverRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ForwardIPForCreateResolverRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardIPForCreateResolverRuleInput) GoString() string {
	return s.String()
}

// SetIP sets the IP field's value.
func (s *ForwardIPForCreateResolverRuleInput) SetIP(v string) *ForwardIPForCreateResolverRuleInput {
	s.IP = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ForwardIPForCreateResolverRuleInput) SetPort(v int32) *ForwardIPForCreateResolverRuleInput {
	s.Port = &v
	return s
}

type TagForCreateResolverRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateResolverRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateResolverRuleInput"}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateResolverRuleInput) SetKey(v string) *TagForCreateResolverRuleInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateResolverRuleInput) SetValue(v string) *TagForCreateResolverRuleInput {
	s.Value = &v
	return s
}

type VpcForCreateResolverRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VpcForCreateResolverRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcForCreateResolverRuleInput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *VpcForCreateResolverRuleInput) SetRegion(v string) *VpcForCreateResolverRuleInput {
	s.Region = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcForCreateResolverRuleInput) SetVpcId(v string) *VpcForCreateResolverRuleInput {
	s.VpcId = &v
	return s
}
