// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatezone

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateResolverEndpointCommon = "CreateResolverEndpoint"

// CreateResolverEndpointCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResolverEndpointCommon operation. The "output" return
// value will be populated with the CreateResolverEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResolverEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResolverEndpointCommon Send returns without error.
//
// See CreateResolverEndpointCommon for more information on using the CreateResolverEndpointCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateResolverEndpointCommonRequest method.
//    req, resp := client.CreateResolverEndpointCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreateResolverEndpointCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateResolverEndpointCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResolverEndpointCommon API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreateResolverEndpointCommon for usage and error information.
func (c *PRIVATEZONE) CreateResolverEndpointCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateResolverEndpointCommonRequest(input)
	return out, req.Send()
}

// CreateResolverEndpointCommonWithContext is the same as CreateResolverEndpointCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverEndpointCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreateResolverEndpointCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateResolverEndpointCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverEndpoint = "CreateResolverEndpoint"

// CreateResolverEndpointRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResolverEndpoint operation. The "output" return
// value will be populated with the CreateResolverEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResolverEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResolverEndpointCommon Send returns without error.
//
// See CreateResolverEndpoint for more information on using the CreateResolverEndpoint
// API call, and error handling.
//
//    // Example sending a request using the CreateResolverEndpointRequest method.
//    req, resp := client.CreateResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreateResolverEndpointRequest(input *CreateResolverEndpointInput) (req *request.Request, output *CreateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverEndpointInput{}
	}

	output = &CreateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResolverEndpoint API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreateResolverEndpoint for usage and error information.
func (c *PRIVATEZONE) CreateResolverEndpoint(input *CreateResolverEndpointInput) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	return out, req.Send()
}

// CreateResolverEndpointWithContext is the same as CreateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreateResolverEndpointWithContext(ctx volcengine.Context, input *CreateResolverEndpointInput, opts ...request.Option) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateResolverEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Direction *string `type:"string" json:",omitempty"`

	EndpointType *string `type:"string" json:",omitempty"`

	IpConfigs []*IpConfigForCreateResolverEndpointInput `type:"list" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	SecurityGroupID *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateResolverEndpointInput `type:"list" json:",omitempty"`

	// VpcID is a required field
	VpcID *string `type:"string" json:",omitempty" required:"true"`

	// VpcRegion is a required field
	VpcRegion *string `type:"string" json:",omitempty" required:"true"`

	VpcTrns []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateResolverEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverEndpointInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.VpcID == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcID"))
	}
	if s.VpcRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcRegion"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirection sets the Direction field's value.
func (s *CreateResolverEndpointInput) SetDirection(v string) *CreateResolverEndpointInput {
	s.Direction = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateResolverEndpointInput) SetEndpointType(v string) *CreateResolverEndpointInput {
	s.EndpointType = &v
	return s
}

// SetIpConfigs sets the IpConfigs field's value.
func (s *CreateResolverEndpointInput) SetIpConfigs(v []*IpConfigForCreateResolverEndpointInput) *CreateResolverEndpointInput {
	s.IpConfigs = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverEndpointInput) SetName(v string) *CreateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateResolverEndpointInput) SetProjectName(v string) *CreateResolverEndpointInput {
	s.ProjectName = &v
	return s
}

// SetSecurityGroupID sets the SecurityGroupID field's value.
func (s *CreateResolverEndpointInput) SetSecurityGroupID(v string) *CreateResolverEndpointInput {
	s.SecurityGroupID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverEndpointInput) SetTags(v []*TagForCreateResolverEndpointInput) *CreateResolverEndpointInput {
	s.Tags = v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *CreateResolverEndpointInput) SetVpcID(v string) *CreateResolverEndpointInput {
	s.VpcID = &v
	return s
}

// SetVpcRegion sets the VpcRegion field's value.
func (s *CreateResolverEndpointInput) SetVpcRegion(v string) *CreateResolverEndpointInput {
	s.VpcRegion = &v
	return s
}

// SetVpcTrns sets the VpcTrns field's value.
func (s *CreateResolverEndpointInput) SetVpcTrns(v []*string) *CreateResolverEndpointInput {
	s.VpcTrns = v
	return s
}

type CreateResolverEndpointOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	EndpointID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CreateResolverEndpointOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointID sets the EndpointID field's value.
func (s *CreateResolverEndpointOutput) SetEndpointID(v int64) *CreateResolverEndpointOutput {
	s.EndpointID = &v
	return s
}

type IpConfigForCreateResolverEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AzID *string `type:"string" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	IPv6 *string `type:"string" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpConfigForCreateResolverEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpConfigForCreateResolverEndpointInput) GoString() string {
	return s.String()
}

// SetAzID sets the AzID field's value.
func (s *IpConfigForCreateResolverEndpointInput) SetAzID(v string) *IpConfigForCreateResolverEndpointInput {
	s.AzID = &v
	return s
}

// SetIP sets the IP field's value.
func (s *IpConfigForCreateResolverEndpointInput) SetIP(v string) *IpConfigForCreateResolverEndpointInput {
	s.IP = &v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *IpConfigForCreateResolverEndpointInput) SetIPv6(v string) *IpConfigForCreateResolverEndpointInput {
	s.IPv6 = &v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *IpConfigForCreateResolverEndpointInput) SetSubnetID(v string) *IpConfigForCreateResolverEndpointInput {
	s.SubnetID = &v
	return s
}

type TagForCreateResolverEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateResolverEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateResolverEndpointInput"}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateResolverEndpointInput) SetKey(v string) *TagForCreateResolverEndpointInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateResolverEndpointInput) SetValue(v string) *TagForCreateResolverEndpointInput {
	s.Value = &v
	return s
}
