// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatezone

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreatePrivateZoneCommon = "CreatePrivateZone"

// CreatePrivateZoneCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreatePrivateZoneCommon operation. The "output" return
// value will be populated with the CreatePrivateZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreatePrivateZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreatePrivateZoneCommon Send returns without error.
//
// See CreatePrivateZoneCommon for more information on using the CreatePrivateZoneCommon
// API call, and error handling.
//
//    // Example sending a request using the CreatePrivateZoneCommonRequest method.
//    req, resp := client.CreatePrivateZoneCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreatePrivateZoneCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreatePrivateZoneCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreatePrivateZoneCommon API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreatePrivateZoneCommon for usage and error information.
func (c *PRIVATEZONE) CreatePrivateZoneCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreatePrivateZoneCommonRequest(input)
	return out, req.Send()
}

// CreatePrivateZoneCommonWithContext is the same as CreatePrivateZoneCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateZoneCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreatePrivateZoneCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreatePrivateZoneCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrivateZone = "CreatePrivateZone"

// CreatePrivateZoneRequest generates a "volcengine/request.Request" representing the
// client's request for the CreatePrivateZone operation. The "output" return
// value will be populated with the CreatePrivateZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreatePrivateZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreatePrivateZoneCommon Send returns without error.
//
// See CreatePrivateZone for more information on using the CreatePrivateZone
// API call, and error handling.
//
//    // Example sending a request using the CreatePrivateZoneRequest method.
//    req, resp := client.CreatePrivateZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) CreatePrivateZoneRequest(input *CreatePrivateZoneInput) (req *request.Request, output *CreatePrivateZoneOutput) {
	op := &request.Operation{
		Name:       opCreatePrivateZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateZoneInput{}
	}

	output = &CreatePrivateZoneOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreatePrivateZone API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation CreatePrivateZone for usage and error information.
func (c *PRIVATEZONE) CreatePrivateZone(input *CreatePrivateZoneInput) (*CreatePrivateZoneOutput, error) {
	req, out := c.CreatePrivateZoneRequest(input)
	return out, req.Send()
}

// CreatePrivateZoneWithContext is the same as CreatePrivateZone with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) CreatePrivateZoneWithContext(ctx volcengine.Context, input *CreatePrivateZoneInput, opts ...request.Option) (*CreatePrivateZoneOutput, error) {
	req, out := c.CreatePrivateZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreatePrivateZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	LineMode *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RecursionMode *bool `type:"boolean" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	Tags []*TagForCreatePrivateZoneInput `type:"list" json:",omitempty"`

	VpcTrns []*string `type:"list" json:",omitempty"`

	Vpcs []*VpcForCreatePrivateZoneInput `type:"list" json:",omitempty"`

	// ZoneName is a required field
	ZoneName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreatePrivateZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateZoneInput"}
	if s.ZoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePrivateZoneInput) SetClientToken(v string) *CreatePrivateZoneInput {
	s.ClientToken = &v
	return s
}

// SetLineMode sets the LineMode field's value.
func (s *CreatePrivateZoneInput) SetLineMode(v int32) *CreatePrivateZoneInput {
	s.LineMode = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreatePrivateZoneInput) SetProjectName(v string) *CreatePrivateZoneInput {
	s.ProjectName = &v
	return s
}

// SetRecursionMode sets the RecursionMode field's value.
func (s *CreatePrivateZoneInput) SetRecursionMode(v bool) *CreatePrivateZoneInput {
	s.RecursionMode = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *CreatePrivateZoneInput) SetRemark(v string) *CreatePrivateZoneInput {
	s.Remark = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePrivateZoneInput) SetTags(v []*TagForCreatePrivateZoneInput) *CreatePrivateZoneInput {
	s.Tags = v
	return s
}

// SetVpcTrns sets the VpcTrns field's value.
func (s *CreatePrivateZoneInput) SetVpcTrns(v []*string) *CreatePrivateZoneInput {
	s.VpcTrns = v
	return s
}

// SetVpcs sets the Vpcs field's value.
func (s *CreatePrivateZoneInput) SetVpcs(v []*VpcForCreatePrivateZoneInput) *CreatePrivateZoneInput {
	s.Vpcs = v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *CreatePrivateZoneInput) SetZoneName(v string) *CreatePrivateZoneInput {
	s.ZoneName = &v
	return s
}

type CreatePrivateZoneOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ZID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CreatePrivateZoneOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateZoneOutput) GoString() string {
	return s.String()
}

// SetZID sets the ZID field's value.
func (s *CreatePrivateZoneOutput) SetZID(v int64) *CreatePrivateZoneOutput {
	s.ZID = &v
	return s
}

type TagForCreatePrivateZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreatePrivateZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreatePrivateZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreatePrivateZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreatePrivateZoneInput"}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreatePrivateZoneInput) SetKey(v string) *TagForCreatePrivateZoneInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreatePrivateZoneInput) SetValue(v string) *TagForCreatePrivateZoneInput {
	s.Value = &v
	return s
}

type VpcForCreatePrivateZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VpcForCreatePrivateZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcForCreatePrivateZoneInput) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *VpcForCreatePrivateZoneInput) SetRegion(v string) *VpcForCreatePrivateZoneInput {
	s.Region = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcForCreatePrivateZoneInput) SetVpcId(v string) *VpcForCreatePrivateZoneInput {
	s.VpcId = &v
	return s
}
