// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package organization

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTagResourcesCommon = "ListTagResources"

// ListTagResourcesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTagResourcesCommon operation. The "output" return
// value will be populated with the ListTagResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTagResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTagResourcesCommon Send returns without error.
//
// See ListTagResourcesCommon for more information on using the ListTagResourcesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTagResourcesCommonRequest method.
//    req, resp := client.ListTagResourcesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) ListTagResourcesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTagResourcesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ListTagResourcesCommon API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation ListTagResourcesCommon for usage and error information.
func (c *ORGANIZATION) ListTagResourcesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTagResourcesCommonRequest(input)
	return out, req.Send()
}

// ListTagResourcesCommonWithContext is the same as ListTagResourcesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagResourcesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) ListTagResourcesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTagResourcesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagResources = "ListTagResources"

// ListTagResourcesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTagResources operation. The "output" return
// value will be populated with the ListTagResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTagResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTagResourcesCommon Send returns without error.
//
// See ListTagResources for more information on using the ListTagResources
// API call, and error handling.
//
//    // Example sending a request using the ListTagResourcesRequest method.
//    req, resp := client.ListTagResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) ListTagResourcesRequest(input *ListTagResourcesInput) (req *request.Request, output *ListTagResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagResources,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagResourcesInput{}
	}

	output = &ListTagResourcesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ListTagResources API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation ListTagResources for usage and error information.
func (c *ORGANIZATION) ListTagResources(input *ListTagResourcesInput) (*ListTagResourcesOutput, error) {
	req, out := c.ListTagResourcesRequest(input)
	return out, req.Send()
}

// ListTagResourcesWithContext is the same as ListTagResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) ListTagResourcesWithContext(ctx volcengine.Context, input *ListTagResourcesInput, opts ...request.Option) (*ListTagResourcesOutput, error) {
	req, out := c.ListTagResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListTagResourcesInput struct {
	_ struct{} `type:"structure"`

	PageNumber *int32 `min:"1" type:"int32"`

	PageSize *int32 `min:"1" max:"100" type:"int32"`

	ResourceIds []*string `type:"list"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"EnumOfResourceTypeForListTagResourcesInput"`

	TagFilters []*TagFilterForListTagResourcesInput `type:"list"`
}

// String returns the string representation
func (s ListTagResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagResourcesInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTagResourcesInput) SetPageNumber(v int32) *ListTagResourcesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTagResourcesInput) SetPageSize(v int32) *ListTagResourcesInput {
	s.PageSize = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListTagResourcesInput) SetResourceIds(v []*string) *ListTagResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListTagResourcesInput) SetResourceType(v string) *ListTagResourcesInput {
	s.ResourceType = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ListTagResourcesInput) SetTagFilters(v []*TagFilterForListTagResourcesInput) *ListTagResourcesInput {
	s.TagFilters = v
	return s
}

type ListTagResourcesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	ResourceTags []*ResourceTagForListTagResourcesOutput `type:"list"`

	TotalCount *int64 `type:"int64"`
}

// String returns the string representation
func (s ListTagResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagResourcesOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTagResourcesOutput) SetPageNumber(v int32) *ListTagResourcesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTagResourcesOutput) SetPageSize(v int32) *ListTagResourcesOutput {
	s.PageSize = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ListTagResourcesOutput) SetResourceTags(v []*ResourceTagForListTagResourcesOutput) *ListTagResourcesOutput {
	s.ResourceTags = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListTagResourcesOutput) SetTotalCount(v int64) *ListTagResourcesOutput {
	s.TotalCount = &v
	return s
}

type ResourceTagForListTagResourcesOutput struct {
	_ struct{} `type:"structure"`

	ResourceId *string `type:"string"`

	ResourceType *string `type:"string" enum:"EnumOfResourceTypeForListTagResourcesOutput"`

	TagKey *string `type:"string"`

	TagValue *string `type:"string"`
}

// String returns the string representation
func (s ResourceTagForListTagResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForListTagResourcesOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceTagForListTagResourcesOutput) SetResourceId(v string) *ResourceTagForListTagResourcesOutput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceTagForListTagResourcesOutput) SetResourceType(v string) *ResourceTagForListTagResourcesOutput {
	s.ResourceType = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *ResourceTagForListTagResourcesOutput) SetTagKey(v string) *ResourceTagForListTagResourcesOutput {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *ResourceTagForListTagResourcesOutput) SetTagValue(v string) *ResourceTagForListTagResourcesOutput {
	s.TagValue = &v
	return s
}

type TagFilterForListTagResourcesInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilterForListTagResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForListTagResourcesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForListTagResourcesInput) SetKey(v string) *TagFilterForListTagResourcesInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForListTagResourcesInput) SetValues(v []*string) *TagFilterForListTagResourcesInput {
	s.Values = v
	return s
}

const (
	// EnumOfResourceTypeForListTagResourcesInputAccount is a EnumOfResourceTypeForListTagResourcesInput enum value
	EnumOfResourceTypeForListTagResourcesInputAccount = "account"

	// EnumOfResourceTypeForListTagResourcesInputUnit is a EnumOfResourceTypeForListTagResourcesInput enum value
	EnumOfResourceTypeForListTagResourcesInputUnit = "unit"
)

const (
	// EnumOfResourceTypeForListTagResourcesOutputAccount is a EnumOfResourceTypeForListTagResourcesOutput enum value
	EnumOfResourceTypeForListTagResourcesOutputAccount = "account"

	// EnumOfResourceTypeForListTagResourcesOutputUnit is a EnumOfResourceTypeForListTagResourcesOutput enum value
	EnumOfResourceTypeForListTagResourcesOutputUnit = "unit"
)
