// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstanceDetailCommon = "DescribeDBInstanceDetail"

// DescribeDBInstanceDetailCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceDetailCommon operation. The "output" return
// value will be populated with the DescribeDBInstanceDetailCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceDetailCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceDetailCommon Send returns without error.
//
// See DescribeDBInstanceDetailCommon for more information on using the DescribeDBInstanceDetailCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceDetailCommonRequest method.
//    req, resp := client.DescribeDBInstanceDetailCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeDBInstanceDetailCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceDetailCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceDetailCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeDBInstanceDetailCommon for usage and error information.
func (c *MONGODB) DescribeDBInstanceDetailCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceDetailCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceDetailCommonWithContext is the same as DescribeDBInstanceDetailCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceDetailCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeDBInstanceDetailCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstanceDetailCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstanceDetail = "DescribeDBInstanceDetail"

// DescribeDBInstanceDetailRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstanceDetail operation. The "output" return
// value will be populated with the DescribeDBInstanceDetailCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstanceDetailCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstanceDetailCommon Send returns without error.
//
// See DescribeDBInstanceDetail for more information on using the DescribeDBInstanceDetail
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstanceDetailRequest method.
//    req, resp := client.DescribeDBInstanceDetailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeDBInstanceDetailRequest(input *DescribeDBInstanceDetailInput) (req *request.Request, output *DescribeDBInstanceDetailOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstanceDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstanceDetailInput{}
	}

	output = &DescribeDBInstanceDetailOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstanceDetail API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeDBInstanceDetail for usage and error information.
func (c *MONGODB) DescribeDBInstanceDetail(input *DescribeDBInstanceDetailInput) (*DescribeDBInstanceDetailOutput, error) {
	req, out := c.DescribeDBInstanceDetailRequest(input)
	return out, req.Send()
}

// DescribeDBInstanceDetailWithContext is the same as DescribeDBInstanceDetail with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstanceDetail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeDBInstanceDetailWithContext(ctx volcengine.Context, input *DescribeDBInstanceDetailInput, opts ...request.Option) (*DescribeDBInstanceDetailOutput, error) {
	req, out := c.DescribeDBInstanceDetailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConfigServerForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConfigServerNodeId *string `type:"string" json:",omitempty"`

	NodeRole *string `type:"string" json:",omitempty" enum:"EnumOfNodeRoleForDescribeDBInstanceDetailOutput"`

	NodeStatus *string `type:"string" json:",omitempty" enum:"EnumOfNodeStatusForDescribeDBInstanceDetailOutput"`

	TotalMemoryGB *float64 `type:"double" json:",omitempty"`

	TotalvCPU *float64 `type:"double" json:",omitempty"`

	UsedMemoryGB *float64 `type:"double" json:",omitempty"`

	UsedvCPU *float64 `type:"double" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConfigServerForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigServerForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetConfigServerNodeId sets the ConfigServerNodeId field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetConfigServerNodeId(v string) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.ConfigServerNodeId = &v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetNodeRole(v string) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.NodeRole = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetNodeStatus(v string) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.NodeStatus = &v
	return s
}

// SetTotalMemoryGB sets the TotalMemoryGB field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetTotalMemoryGB(v float64) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.TotalMemoryGB = &v
	return s
}

// SetTotalvCPU sets the TotalvCPU field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetTotalvCPU(v float64) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.TotalvCPU = &v
	return s
}

// SetUsedMemoryGB sets the UsedMemoryGB field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetUsedMemoryGB(v float64) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.UsedMemoryGB = &v
	return s
}

// SetUsedvCPU sets the UsedvCPU field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetUsedvCPU(v float64) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.UsedvCPU = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ConfigServerForDescribeDBInstanceDetailOutput) SetZoneId(v string) *ConfigServerForDescribeDBInstanceDetailOutput {
	s.ZoneId = &v
	return s
}

type DBInstanceForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ChargeStatus *string `type:"string" json:",omitempty" enum:"EnumOfChargeStatusForDescribeDBInstanceDetailOutput"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeDBInstanceDetailOutput"`

	ClosedTime *string `type:"string" json:",omitempty"`

	ConfigServers []*ConfigServerForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	ConfigServersId *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	DBEngine *string `type:"string" json:",omitempty" enum:"EnumOfDBEngineForDescribeDBInstanceDetailOutput"`

	DBEngineVersion *string `type:"string" json:",omitempty" enum:"EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput"`

	DBEngineVersionStr *string `type:"string" json:",omitempty"`

	ExpiredTime *string `type:"string" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceStatus *string `type:"string" json:",omitempty" enum:"EnumOfInstanceStatusForDescribeDBInstanceDetailOutput"`

	InstanceType *string `type:"string" json:",omitempty" enum:"EnumOfInstanceTypeForDescribeDBInstanceDetailOutput"`

	Mongos []*MongoForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	MongosId *string `type:"string" json:",omitempty"`

	Nodes []*NodeForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	PrivateEndpoint *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	ReadOnlyNodeNumber *int32 `type:"int32" json:",omitempty"`

	ReclaimTime *string `type:"string" json:",omitempty"`

	Shards []*ShardForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	StorageType *string `type:"string" json:",omitempty" enum:"EnumOfStorageTypeForDescribeDBInstanceDetailOutput"`

	SubnetId *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DBInstanceForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetAutoRenew(v bool) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.AutoRenew = &v
	return s
}

// SetChargeStatus sets the ChargeStatus field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetChargeStatus(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ChargeStatus = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetChargeType(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ChargeType = &v
	return s
}

// SetClosedTime sets the ClosedTime field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetClosedTime(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ClosedTime = &v
	return s
}

// SetConfigServers sets the ConfigServers field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetConfigServers(v []*ConfigServerForDescribeDBInstanceDetailOutput) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ConfigServers = v
	return s
}

// SetConfigServersId sets the ConfigServersId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetConfigServersId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ConfigServersId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetCreateTime(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.CreateTime = &v
	return s
}

// SetDBEngine sets the DBEngine field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetDBEngine(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.DBEngine = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetDBEngineVersion(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.DBEngineVersion = &v
	return s
}

// SetDBEngineVersionStr sets the DBEngineVersionStr field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetDBEngineVersionStr(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.DBEngineVersionStr = &v
	return s
}

// SetExpiredTime sets the ExpiredTime field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetExpiredTime(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ExpiredTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetInstanceId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetInstanceName(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetInstanceStatus(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.InstanceStatus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetInstanceType(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.InstanceType = &v
	return s
}

// SetMongos sets the Mongos field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetMongos(v []*MongoForDescribeDBInstanceDetailOutput) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.Mongos = v
	return s
}

// SetMongosId sets the MongosId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetMongosId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.MongosId = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetNodes(v []*NodeForDescribeDBInstanceDetailOutput) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.Nodes = v
	return s
}

// SetPrivateEndpoint sets the PrivateEndpoint field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetPrivateEndpoint(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.PrivateEndpoint = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetProjectName(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ProjectName = &v
	return s
}

// SetReadOnlyNodeNumber sets the ReadOnlyNodeNumber field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetReadOnlyNodeNumber(v int32) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ReadOnlyNodeNumber = &v
	return s
}

// SetReclaimTime sets the ReclaimTime field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetReclaimTime(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ReclaimTime = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetShards(v []*ShardForDescribeDBInstanceDetailOutput) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.Shards = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetStorageType(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetSubnetId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetTags(v []*TagForDescribeDBInstanceDetailOutput) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetUpdateTime(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.UpdateTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetVpcId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *DBInstanceForDescribeDBInstanceDetailOutput) SetZoneId(v string) *DBInstanceForDescribeDBInstanceDetailOutput {
	s.ZoneId = &v
	return s
}

type DescribeDBInstanceDetailInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeDBInstanceDetailInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstanceDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstanceDetailInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstanceDetailInput) SetInstanceId(v string) *DescribeDBInstanceDetailInput {
	s.InstanceId = &v
	return s
}

type DescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DBInstance *DBInstanceForDescribeDBInstanceDetailOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *DescribeDBInstanceDetailOutput) SetDBInstance(v *DBInstanceForDescribeDBInstanceDetailOutput) *DescribeDBInstanceDetailOutput {
	s.DBInstance = v
	return s
}

type MongoForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MongosNodeId *string `type:"string" json:",omitempty"`

	NodeSpec *string `type:"string" json:",omitempty"`

	NodeStatus *string `type:"string" json:",omitempty" enum:"EnumOfNodeStatusForDescribeDBInstanceDetailOutput"`

	TotalMemoryGB *float64 `type:"double" json:",omitempty"`

	TotalvCPU *float64 `type:"double" json:",omitempty"`

	UsedMemoryGB *float64 `type:"double" json:",omitempty"`

	UsedvCPU *float64 `type:"double" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MongoForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MongoForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetMongosNodeId sets the MongosNodeId field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetMongosNodeId(v string) *MongoForDescribeDBInstanceDetailOutput {
	s.MongosNodeId = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetNodeSpec(v string) *MongoForDescribeDBInstanceDetailOutput {
	s.NodeSpec = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetNodeStatus(v string) *MongoForDescribeDBInstanceDetailOutput {
	s.NodeStatus = &v
	return s
}

// SetTotalMemoryGB sets the TotalMemoryGB field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetTotalMemoryGB(v float64) *MongoForDescribeDBInstanceDetailOutput {
	s.TotalMemoryGB = &v
	return s
}

// SetTotalvCPU sets the TotalvCPU field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetTotalvCPU(v float64) *MongoForDescribeDBInstanceDetailOutput {
	s.TotalvCPU = &v
	return s
}

// SetUsedMemoryGB sets the UsedMemoryGB field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetUsedMemoryGB(v float64) *MongoForDescribeDBInstanceDetailOutput {
	s.UsedMemoryGB = &v
	return s
}

// SetUsedvCPU sets the UsedvCPU field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetUsedvCPU(v float64) *MongoForDescribeDBInstanceDetailOutput {
	s.UsedvCPU = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *MongoForDescribeDBInstanceDetailOutput) SetZoneId(v string) *MongoForDescribeDBInstanceDetailOutput {
	s.ZoneId = &v
	return s
}

type NodeForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NodeDelayTime *int32 `type:"int32" json:",omitempty"`

	NodeId *string `type:"string" json:",omitempty"`

	NodeRole *string `type:"string" json:",omitempty" enum:"EnumOfNodeRoleForDescribeDBInstanceDetailOutput"`

	NodeSpec *string `type:"string" json:",omitempty"`

	NodeStatus *string `type:"string" json:",omitempty" enum:"EnumOfNodeStatusForDescribeDBInstanceDetailOutput"`

	TotalMemoryGB *float64 `type:"double" json:",omitempty"`

	TotalStorageGB *float64 `type:"double" json:",omitempty"`

	TotalvCPU *float64 `type:"double" json:",omitempty"`

	UsedMemoryGB *float64 `type:"double" json:",omitempty"`

	UsedStorageGB *float64 `type:"double" json:",omitempty"`

	UsedvCPU *float64 `type:"double" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetNodeDelayTime sets the NodeDelayTime field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeDelayTime(v int32) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeDelayTime = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeId(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeId = &v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeRole(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeRole = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeSpec(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeSpec = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetNodeStatus(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.NodeStatus = &v
	return s
}

// SetTotalMemoryGB sets the TotalMemoryGB field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetTotalMemoryGB(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.TotalMemoryGB = &v
	return s
}

// SetTotalStorageGB sets the TotalStorageGB field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetTotalStorageGB(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.TotalStorageGB = &v
	return s
}

// SetTotalvCPU sets the TotalvCPU field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetTotalvCPU(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.TotalvCPU = &v
	return s
}

// SetUsedMemoryGB sets the UsedMemoryGB field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetUsedMemoryGB(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.UsedMemoryGB = &v
	return s
}

// SetUsedStorageGB sets the UsedStorageGB field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetUsedStorageGB(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.UsedStorageGB = &v
	return s
}

// SetUsedvCPU sets the UsedvCPU field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetUsedvCPU(v float64) *NodeForDescribeDBInstanceDetailOutput {
	s.UsedvCPU = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeForDescribeDBInstanceDetailOutput) SetZoneId(v string) *NodeForDescribeDBInstanceDetailOutput {
	s.ZoneId = &v
	return s
}

type ShardForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Nodes []*NodeForDescribeDBInstanceDetailOutput `type:"list" json:",omitempty"`

	ShardId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ShardForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ShardForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetNodes sets the Nodes field's value.
func (s *ShardForDescribeDBInstanceDetailOutput) SetNodes(v []*NodeForDescribeDBInstanceDetailOutput) *ShardForDescribeDBInstanceDetailOutput {
	s.Nodes = v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *ShardForDescribeDBInstanceDetailOutput) SetShardId(v string) *ShardForDescribeDBInstanceDetailOutput {
	s.ShardId = &v
	return s
}

type TagForDescribeDBInstanceDetailOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeDBInstanceDetailOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeDBInstanceDetailOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeDBInstanceDetailOutput) SetKey(v string) *TagForDescribeDBInstanceDetailOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeDBInstanceDetailOutput) SetValue(v string) *TagForDescribeDBInstanceDetailOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputNormal is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputNormal = "Normal"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputOverdue is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputOverdue = "Overdue"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputWaitingPaid is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputWaitingPaid = "WaitingPaid"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputUnDeploy is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputUnDeploy = "UnDeploy"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputRenewing is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputRenewing = "Renewing"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputOwing is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputOwing = "Owing"

	// EnumOfChargeStatusForDescribeDBInstanceDetailOutputUnsubscribing is a EnumOfChargeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeStatusForDescribeDBInstanceDetailOutputUnsubscribing = "Unsubscribing"
)

const (
	// EnumOfChargeTypeForDescribeDBInstanceDetailOutputNotEnabled is a EnumOfChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeTypeForDescribeDBInstanceDetailOutputNotEnabled = "NotEnabled"

	// EnumOfChargeTypeForDescribeDBInstanceDetailOutputPostPaid is a EnumOfChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeTypeForDescribeDBInstanceDetailOutputPostPaid = "PostPaid"

	// EnumOfChargeTypeForDescribeDBInstanceDetailOutputPrepaid is a EnumOfChargeTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfChargeTypeForDescribeDBInstanceDetailOutputPrepaid = "Prepaid"
)

const (
	// EnumOfDBEngineForDescribeDBInstanceDetailOutputMongoDb is a EnumOfDBEngineForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineForDescribeDBInstanceDetailOutputMongoDb = "MongoDB"
)

const (
	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb40 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb40 = "MongoDB_4_0"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb42 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb42 = "MongoDB_4_2"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb44 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb44 = "MongoDB_4_4"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb50 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb50 = "MongoDB_5_0"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb60 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDb60 = "MongoDB_6_0"

	// EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDbInner40 is a EnumOfDBEngineVersionForDescribeDBInstanceDetailOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstanceDetailOutputMongoDbInner40 = "MongoDB_Inner_4_0"
)

const (
	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreating = "Creating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRunning is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRunning = "Running"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleting is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleting = "Deleting"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDestroying is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDestroying = "Destroying"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestarting is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestarting = "Restarting"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRebuilding is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRebuilding = "Rebuilding"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpdating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpdating = "Updating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputMigrating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputMigrating = "Migrating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestoring is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRestoring = "Restoring"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputImporting is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputImporting = "Importing"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputError is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputError = "Error"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputScaling is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputScaling = "Scaling"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpgrading is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUpgrading = "Upgrading"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleted is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDeleted = "Deleted"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRecycled is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRecycled = "Recycled"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosed is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosed = "Closed"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreateFailed is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCreateFailed = "CreateFailed"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetCreating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetCreating = "NetCreating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetReleasing is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetReleasing = "NetReleasing"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputWaitingPaid is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputWaitingPaid = "WaitingPaid"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosing is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputClosing = "Closing"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputReleased is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputReleased = "Released"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDestroyed is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputDestroyed = "Destroyed"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputReclaiming is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputReclaiming = "Reclaiming"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputResuming is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputResuming = "Resuming"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputAllowListMaintaining is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputAllowListMaintaining = "AllowListMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTaskFailedAvailable is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTaskFailedAvailable = "TaskFailed_Available"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUnavailable is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputUnavailable = "Unavailable"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetworkMaintaining is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputNetworkMaintaining = "NetworkMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTdemaintaining is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTdemaintaining = "TDEMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputSslupdating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputSslupdating = "SSLUpdating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputSwitchMastering is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputSwitchMastering = "SwitchMastering"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTemporary is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputTemporary = "Temporary"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRoleChanging is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputRoleChanging = "RoleChanging"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCrossClusterMigrating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCrossClusterMigrating = "CrossClusterMigrating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCrossNodeMigrating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputCrossNodeMigrating = "CrossNodeMigrating"

	// EnumOfInstanceStatusForDescribeDBInstanceDetailOutputMultiAzMigrating is a EnumOfInstanceStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceStatusForDescribeDBInstanceDetailOutputMultiAzMigrating = "MultiAzMigrating"
)

const (
	// EnumOfInstanceTypeForDescribeDBInstanceDetailOutputReplicaSet is a EnumOfInstanceTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceTypeForDescribeDBInstanceDetailOutputReplicaSet = "ReplicaSet"

	// EnumOfInstanceTypeForDescribeDBInstanceDetailOutputShardedCluster is a EnumOfInstanceTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfInstanceTypeForDescribeDBInstanceDetailOutputShardedCluster = "ShardedCluster"
)

const (
	// EnumOfNodeRoleForDescribeDBInstanceDetailOutputPrimary is a EnumOfNodeRoleForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeRoleForDescribeDBInstanceDetailOutputPrimary = "Primary"

	// EnumOfNodeRoleForDescribeDBInstanceDetailOutputSecondary is a EnumOfNodeRoleForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeRoleForDescribeDBInstanceDetailOutputSecondary = "Secondary"

	// EnumOfNodeRoleForDescribeDBInstanceDetailOutputHidden is a EnumOfNodeRoleForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeRoleForDescribeDBInstanceDetailOutputHidden = "Hidden"

	// EnumOfNodeRoleForDescribeDBInstanceDetailOutputReadOnly is a EnumOfNodeRoleForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeRoleForDescribeDBInstanceDetailOutputReadOnly = "ReadOnly"
)

const (
	// EnumOfNodeStatusForDescribeDBInstanceDetailOutputRunning is a EnumOfNodeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeStatusForDescribeDBInstanceDetailOutputRunning = "Running"

	// EnumOfNodeStatusForDescribeDBInstanceDetailOutputError is a EnumOfNodeStatusForDescribeDBInstanceDetailOutput enum value
	EnumOfNodeStatusForDescribeDBInstanceDetailOutputError = "Error"
)

const (
	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputLocalSsd is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputLocalSsd = "LocalSSD"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputLocalHdd is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputLocalHdd = "LocalHDD"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdFlexPl is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdFlexPl = "ESSD_FlexPL"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl0 is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl0 = "ESSD_PL0"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl1 is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl1 = "ESSD_PL1"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl2 is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssdPl2 = "ESSD_PL2"

	// EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssd is a EnumOfStorageTypeForDescribeDBInstanceDetailOutput enum value
	EnumOfStorageTypeForDescribeDBInstanceDetailOutputEssd = "ESSD"
)
