// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDBInstanceCommon = "CreateDBInstance"

// CreateDBInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDBInstanceCommon operation. The "output" return
// value will be populated with the CreateDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDBInstanceCommon Send returns without error.
//
// See CreateDBInstanceCommon for more information on using the CreateDBInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDBInstanceCommonRequest method.
//    req, resp := client.CreateDBInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) CreateDBInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDBInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDBInstanceCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation CreateDBInstanceCommon for usage and error information.
func (c *MONGODB) CreateDBInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDBInstanceCommonRequest(input)
	return out, req.Send()
}

// CreateDBInstanceCommonWithContext is the same as CreateDBInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) CreateDBInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDBInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the CreateDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDBInstanceCommon Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDBInstance API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation CreateDBInstance for usage and error information.
func (c *MONGODB) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) CreateDBInstanceWithContext(ctx volcengine.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDBInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowListIds []*string `type:"list" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForCreateDBInstanceInput"`

	ConfigServerNodeSpec *string `type:"string" json:",omitempty"`

	ConfigServerStorageSpaceGB *int32 `type:"int32" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	DBEngine *string `type:"string" json:",omitempty" enum:"EnumOfDBEngineForCreateDBInstanceInput"`

	DBEngineVersion *string `type:"string" json:",omitempty" enum:"EnumOfDBEngineVersionForCreateDBInstanceInput"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty" enum:"EnumOfInstanceTypeForCreateDBInstanceInput"`

	MongosNodeNumber *int32 `type:"int32" json:",omitempty"`

	MongosNodeSpec *string `type:"string" json:",omitempty"`

	NodeAvailabilityZone []*NodeAvailabilityZoneForCreateDBInstanceInput `type:"list" json:",omitempty"`

	NodeNumber *int32 `type:"int32" json:",omitempty"`

	// NodeSpec is a required field
	NodeSpec *string `type:"string" json:",omitempty" required:"true"`

	Period *int32 `type:"int32" json:",omitempty"`

	PeriodUnit *string `type:"string" json:",omitempty" enum:"EnumOfPeriodUnitForCreateDBInstanceInput"`

	ProjectName *string `type:"string" json:",omitempty"`

	ShardNumber *int32 `type:"int32" json:",omitempty"`

	// StorageSpaceGB is a required field
	StorageSpaceGB *int32 `type:"int32" json:",omitempty" required:"true"`

	// SubnetId is a required field
	SubnetId *string `type:"string" json:",omitempty" required:"true"`

	SuperAccountName *string `type:"string" json:",omitempty"`

	SuperAccountPassword *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateDBInstanceInput `type:"list" json:",omitempty"`

	// VpcId is a required field
	VpcId *string `type:"string" json:",omitempty" required:"true"`

	// ZoneId is a required field
	ZoneId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.NodeSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeSpec"))
	}
	if s.StorageSpaceGB == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageSpaceGB"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.ZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowListIds sets the AllowListIds field's value.
func (s *CreateDBInstanceInput) SetAllowListIds(v []*string) *CreateDBInstanceInput {
	s.AllowListIds = v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *CreateDBInstanceInput) SetAutoRenew(v bool) *CreateDBInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateDBInstanceInput) SetChargeType(v string) *CreateDBInstanceInput {
	s.ChargeType = &v
	return s
}

// SetConfigServerNodeSpec sets the ConfigServerNodeSpec field's value.
func (s *CreateDBInstanceInput) SetConfigServerNodeSpec(v string) *CreateDBInstanceInput {
	s.ConfigServerNodeSpec = &v
	return s
}

// SetConfigServerStorageSpaceGB sets the ConfigServerStorageSpaceGB field's value.
func (s *CreateDBInstanceInput) SetConfigServerStorageSpaceGB(v int32) *CreateDBInstanceInput {
	s.ConfigServerStorageSpaceGB = &v
	return s
}

// SetCount sets the Count field's value.
func (s *CreateDBInstanceInput) SetCount(v int32) *CreateDBInstanceInput {
	s.Count = &v
	return s
}

// SetDBEngine sets the DBEngine field's value.
func (s *CreateDBInstanceInput) SetDBEngine(v string) *CreateDBInstanceInput {
	s.DBEngine = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *CreateDBInstanceInput) SetDBEngineVersion(v string) *CreateDBInstanceInput {
	s.DBEngineVersion = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateDBInstanceInput) SetInstanceName(v string) *CreateDBInstanceInput {
	s.InstanceName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateDBInstanceInput) SetInstanceType(v string) *CreateDBInstanceInput {
	s.InstanceType = &v
	return s
}

// SetMongosNodeNumber sets the MongosNodeNumber field's value.
func (s *CreateDBInstanceInput) SetMongosNodeNumber(v int32) *CreateDBInstanceInput {
	s.MongosNodeNumber = &v
	return s
}

// SetMongosNodeSpec sets the MongosNodeSpec field's value.
func (s *CreateDBInstanceInput) SetMongosNodeSpec(v string) *CreateDBInstanceInput {
	s.MongosNodeSpec = &v
	return s
}

// SetNodeAvailabilityZone sets the NodeAvailabilityZone field's value.
func (s *CreateDBInstanceInput) SetNodeAvailabilityZone(v []*NodeAvailabilityZoneForCreateDBInstanceInput) *CreateDBInstanceInput {
	s.NodeAvailabilityZone = v
	return s
}

// SetNodeNumber sets the NodeNumber field's value.
func (s *CreateDBInstanceInput) SetNodeNumber(v int32) *CreateDBInstanceInput {
	s.NodeNumber = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *CreateDBInstanceInput) SetNodeSpec(v string) *CreateDBInstanceInput {
	s.NodeSpec = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateDBInstanceInput) SetPeriod(v int32) *CreateDBInstanceInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *CreateDBInstanceInput) SetPeriodUnit(v string) *CreateDBInstanceInput {
	s.PeriodUnit = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateDBInstanceInput) SetProjectName(v string) *CreateDBInstanceInput {
	s.ProjectName = &v
	return s
}

// SetShardNumber sets the ShardNumber field's value.
func (s *CreateDBInstanceInput) SetShardNumber(v int32) *CreateDBInstanceInput {
	s.ShardNumber = &v
	return s
}

// SetStorageSpaceGB sets the StorageSpaceGB field's value.
func (s *CreateDBInstanceInput) SetStorageSpaceGB(v int32) *CreateDBInstanceInput {
	s.StorageSpaceGB = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDBInstanceInput) SetSubnetId(v string) *CreateDBInstanceInput {
	s.SubnetId = &v
	return s
}

// SetSuperAccountName sets the SuperAccountName field's value.
func (s *CreateDBInstanceInput) SetSuperAccountName(v string) *CreateDBInstanceInput {
	s.SuperAccountName = &v
	return s
}

// SetSuperAccountPassword sets the SuperAccountPassword field's value.
func (s *CreateDBInstanceInput) SetSuperAccountPassword(v string) *CreateDBInstanceInput {
	s.SuperAccountPassword = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*TagForCreateDBInstanceInput) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateDBInstanceInput) SetVpcId(v string) *CreateDBInstanceInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateDBInstanceInput) SetZoneId(v string) *CreateDBInstanceInput {
	s.ZoneId = &v
	return s
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	OrderNO *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateDBInstanceOutput) SetInstanceId(v string) *CreateDBInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetOrderNO sets the OrderNO field's value.
func (s *CreateDBInstanceOutput) SetOrderNO(v string) *CreateDBInstanceOutput {
	s.OrderNO = &v
	return s
}

type NodeAvailabilityZoneForCreateDBInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NodeNumber *int32 `type:"int32" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAvailabilityZoneForCreateDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAvailabilityZoneForCreateDBInstanceInput) GoString() string {
	return s.String()
}

// SetNodeNumber sets the NodeNumber field's value.
func (s *NodeAvailabilityZoneForCreateDBInstanceInput) SetNodeNumber(v int32) *NodeAvailabilityZoneForCreateDBInstanceInput {
	s.NodeNumber = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeAvailabilityZoneForCreateDBInstanceInput) SetZoneId(v string) *NodeAvailabilityZoneForCreateDBInstanceInput {
	s.ZoneId = &v
	return s
}

type TagForCreateDBInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateDBInstanceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateDBInstanceInput) SetKey(v string) *TagForCreateDBInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateDBInstanceInput) SetValue(v string) *TagForCreateDBInstanceInput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateDBInstanceInputNotEnabled is a EnumOfChargeTypeForCreateDBInstanceInput enum value
	EnumOfChargeTypeForCreateDBInstanceInputNotEnabled = "NotEnabled"

	// EnumOfChargeTypeForCreateDBInstanceInputPostPaid is a EnumOfChargeTypeForCreateDBInstanceInput enum value
	EnumOfChargeTypeForCreateDBInstanceInputPostPaid = "PostPaid"

	// EnumOfChargeTypeForCreateDBInstanceInputPrepaid is a EnumOfChargeTypeForCreateDBInstanceInput enum value
	EnumOfChargeTypeForCreateDBInstanceInputPrepaid = "Prepaid"
)

const (
	// EnumOfDBEngineForCreateDBInstanceInputMongoDb is a EnumOfDBEngineForCreateDBInstanceInput enum value
	EnumOfDBEngineForCreateDBInstanceInputMongoDb = "MongoDB"
)

const (
	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb40 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb40 = "MongoDB_4_0"

	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb42 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb42 = "MongoDB_4_2"

	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb44 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb44 = "MongoDB_4_4"

	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb50 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb50 = "MongoDB_5_0"

	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb60 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDb60 = "MongoDB_6_0"

	// EnumOfDBEngineVersionForCreateDBInstanceInputMongoDbInner40 is a EnumOfDBEngineVersionForCreateDBInstanceInput enum value
	EnumOfDBEngineVersionForCreateDBInstanceInputMongoDbInner40 = "MongoDB_Inner_4_0"
)

const (
	// EnumOfInstanceTypeForCreateDBInstanceInputReplicaSet is a EnumOfInstanceTypeForCreateDBInstanceInput enum value
	EnumOfInstanceTypeForCreateDBInstanceInputReplicaSet = "ReplicaSet"

	// EnumOfInstanceTypeForCreateDBInstanceInputShardedCluster is a EnumOfInstanceTypeForCreateDBInstanceInput enum value
	EnumOfInstanceTypeForCreateDBInstanceInputShardedCluster = "ShardedCluster"
)

const (
	// EnumOfPeriodUnitForCreateDBInstanceInputYear is a EnumOfPeriodUnitForCreateDBInstanceInput enum value
	EnumOfPeriodUnitForCreateDBInstanceInputYear = "Year"

	// EnumOfPeriodUnitForCreateDBInstanceInputMonth is a EnumOfPeriodUnitForCreateDBInstanceInput enum value
	EnumOfPeriodUnitForCreateDBInstanceInputMonth = "Month"
)
