// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListJobsCommon = "ListJobs"

// ListJobsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListJobsCommon operation. The "output" return
// value will be populated with the ListJobsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListJobsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListJobsCommon Send returns without error.
//
// See ListJobsCommon for more information on using the ListJobsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListJobsCommonRequest method.
//    req, resp := client.ListJobsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListJobsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListJobsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListJobsCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListJobsCommon for usage and error information.
func (c *MLPLATFORM20240701) ListJobsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListJobsCommonRequest(input)
	return out, req.Send()
}

// ListJobsCommonWithContext is the same as ListJobsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListJobsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListJobsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the ListJobsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListJobsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListJobsCommon Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListJobs API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListJobs for usage and error information.
func (c *MLPLATFORM20240701) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListJobsWithContext(ctx volcengine.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FlexibleResourceClaimForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForListJobsOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetCpu(v float64) *FlexibleResourceClaimForListJobsOutput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetFamily(v string) *FlexibleResourceClaimForListJobsOutput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetGpuCount(v float64) *FlexibleResourceClaimForListJobsOutput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetGpuType(v string) *FlexibleResourceClaimForListJobsOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetMemoryGiB(v float64) *FlexibleResourceClaimForListJobsOutput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForListJobsOutput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForListJobsOutput {
	s.RdmaEniCount = &v
	return s
}

type ItemForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	InitialId *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ResourceConfig *ResourceConfigForListJobsOutput `type:"structure" json:",omitempty"`

	Status *StatusForListJobsOutput `type:"structure" json:",omitempty"`

	StopReason *string `type:"string" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListJobsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListJobsOutput) SetCreateTime(v string) *ItemForListJobsOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ItemForListJobsOutput) SetCreatedBy(v string) *ItemForListJobsOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListJobsOutput) SetDescription(v string) *ItemForListJobsOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ItemForListJobsOutput) SetId(v string) *ItemForListJobsOutput {
	s.Id = &v
	return s
}

// SetInitialId sets the InitialId field's value.
func (s *ItemForListJobsOutput) SetInitialId(v string) *ItemForListJobsOutput {
	s.InitialId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListJobsOutput) SetName(v string) *ItemForListJobsOutput {
	s.Name = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *ItemForListJobsOutput) SetResourceConfig(v *ResourceConfigForListJobsOutput) *ItemForListJobsOutput {
	s.ResourceConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListJobsOutput) SetStatus(v *StatusForListJobsOutput) *ItemForListJobsOutput {
	s.Status = v
	return s
}

// SetStopReason sets the StopReason field's value.
func (s *ItemForListJobsOutput) SetStopReason(v string) *ItemForListJobsOutput {
	s.StopReason = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListJobsOutput) SetUpdateTime(v string) *ItemForListJobsOutput {
	s.UpdateTime = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTimeAfter *string `type:"string" json:",omitempty"`

	CreateTimeBefore *string `type:"string" json:",omitempty"`

	DiagnoseState *string `type:"string" json:",omitempty" enum:"EnumOfDiagnoseStateForListJobsInput"`

	NameContains *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"10" max:"100" type:"int32" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceGroupId *string `type:"string" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	ResourceReservationPlanId *string `type:"string" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListJobsInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListJobsInput"`

	State *string `type:"string" json:",omitempty" enum:"EnumOfStateForListJobsInput"`

	UpdateTimeAfter *string `type:"string" json:",omitempty"`

	UpdateTimeBefore *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.PageSize != nil && *s.PageSize < 10 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 10))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateTimeAfter sets the CreateTimeAfter field's value.
func (s *ListJobsInput) SetCreateTimeAfter(v string) *ListJobsInput {
	s.CreateTimeAfter = &v
	return s
}

// SetCreateTimeBefore sets the CreateTimeBefore field's value.
func (s *ListJobsInput) SetCreateTimeBefore(v string) *ListJobsInput {
	s.CreateTimeBefore = &v
	return s
}

// SetDiagnoseState sets the DiagnoseState field's value.
func (s *ListJobsInput) SetDiagnoseState(v string) *ListJobsInput {
	s.DiagnoseState = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListJobsInput) SetNameContains(v string) *ListJobsInput {
	s.NameContains = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListJobsInput) SetPageNumber(v int32) *ListJobsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListJobsInput) SetPageSize(v int32) *ListJobsInput {
	s.PageSize = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ListJobsInput) SetPriority(v int32) *ListJobsInput {
	s.Priority = &v
	return s
}

// SetResourceGroupId sets the ResourceGroupId field's value.
func (s *ListJobsInput) SetResourceGroupId(v string) *ListJobsInput {
	s.ResourceGroupId = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *ListJobsInput) SetResourceQueueId(v string) *ListJobsInput {
	s.ResourceQueueId = &v
	return s
}

// SetResourceReservationPlanId sets the ResourceReservationPlanId field's value.
func (s *ListJobsInput) SetResourceReservationPlanId(v string) *ListJobsInput {
	s.ResourceReservationPlanId = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListJobsInput) SetSortBy(v string) *ListJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListJobsInput) SetSortOrder(v string) *ListJobsInput {
	s.SortOrder = &v
	return s
}

// SetState sets the State field's value.
func (s *ListJobsInput) SetState(v string) *ListJobsInput {
	s.State = &v
	return s
}

// SetUpdateTimeAfter sets the UpdateTimeAfter field's value.
func (s *ListJobsInput) SetUpdateTimeAfter(v string) *ListJobsInput {
	s.UpdateTimeAfter = &v
	return s
}

// SetUpdateTimeBefore sets the UpdateTimeBefore field's value.
func (s *ListJobsInput) SetUpdateTimeBefore(v string) *ListJobsInput {
	s.UpdateTimeBefore = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListJobsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListJobsOutput) SetItems(v []*ItemForListJobsOutput) *ListJobsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListJobsOutput) SetPageNumber(v int32) *ListJobsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListJobsOutput) SetPageSize(v int32) *ListJobsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListJobsOutput) SetTotalCount(v int32) *ListJobsOutput {
	s.TotalCount = &v
	return s
}

type NodeAffinitySpecForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForListJobsOutput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForListJobsOutput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForListJobsOutput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForListJobsOutput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForListJobsOutput) SetStrategyType(v string) *NodeAffinitySpecForListJobsOutput {
	s.StrategyType = &v
	return s
}

type ResourceConfigForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HoldingTimeSeconds *int64 `type:"int64" json:",omitempty"`

	MaxRuntimeSeconds *int64 `type:"int64" json:",omitempty"`

	NumaAffinity *string `type:"string" json:",omitempty"`

	OnlyUseSuspectedNode *bool `type:"boolean" json:",omitempty"`

	Preemptible *bool `type:"boolean" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	ResourceReservation *bool `type:"boolean" json:",omitempty"`

	ResourceReservationPlanId *string `type:"string" json:",omitempty"`

	Roles []*RoleForListJobsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceConfigForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfigForListJobsOutput) GoString() string {
	return s.String()
}

// SetHoldingTimeSeconds sets the HoldingTimeSeconds field's value.
func (s *ResourceConfigForListJobsOutput) SetHoldingTimeSeconds(v int64) *ResourceConfigForListJobsOutput {
	s.HoldingTimeSeconds = &v
	return s
}

// SetMaxRuntimeSeconds sets the MaxRuntimeSeconds field's value.
func (s *ResourceConfigForListJobsOutput) SetMaxRuntimeSeconds(v int64) *ResourceConfigForListJobsOutput {
	s.MaxRuntimeSeconds = &v
	return s
}

// SetNumaAffinity sets the NumaAffinity field's value.
func (s *ResourceConfigForListJobsOutput) SetNumaAffinity(v string) *ResourceConfigForListJobsOutput {
	s.NumaAffinity = &v
	return s
}

// SetOnlyUseSuspectedNode sets the OnlyUseSuspectedNode field's value.
func (s *ResourceConfigForListJobsOutput) SetOnlyUseSuspectedNode(v bool) *ResourceConfigForListJobsOutput {
	s.OnlyUseSuspectedNode = &v
	return s
}

// SetPreemptible sets the Preemptible field's value.
func (s *ResourceConfigForListJobsOutput) SetPreemptible(v bool) *ResourceConfigForListJobsOutput {
	s.Preemptible = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ResourceConfigForListJobsOutput) SetPriority(v int32) *ResourceConfigForListJobsOutput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *ResourceConfigForListJobsOutput) SetResourceQueueId(v string) *ResourceConfigForListJobsOutput {
	s.ResourceQueueId = &v
	return s
}

// SetResourceReservation sets the ResourceReservation field's value.
func (s *ResourceConfigForListJobsOutput) SetResourceReservation(v bool) *ResourceConfigForListJobsOutput {
	s.ResourceReservation = &v
	return s
}

// SetResourceReservationPlanId sets the ResourceReservationPlanId field's value.
func (s *ResourceConfigForListJobsOutput) SetResourceReservationPlanId(v string) *ResourceConfigForListJobsOutput {
	s.ResourceReservationPlanId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *ResourceConfigForListJobsOutput) SetRoles(v []*RoleForListJobsOutput) *ResourceConfigForListJobsOutput {
	s.Roles = v
	return s
}

type ResourceForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForListJobsOutput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForListJobsOutput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForListJobsOutput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForListJobsOutput) *ResourceForListJobsOutput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForListJobsOutput) SetInstanceTypeId(v string) *ResourceForListJobsOutput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForListJobsOutput) SetType(v string) *ResourceForListJobsOutput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForListJobsOutput) SetZoneId(v string) *ResourceForListJobsOutput {
	s.ZoneId = &v
	return s
}

type RoleForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForListJobsOutput `type:"structure" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`

	Resource *ResourceForListJobsOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RoleForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForListJobsOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RoleForListJobsOutput) SetName(v string) *RoleForListJobsOutput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForListJobsOutput) SetNodeAffinitySpec(v *NodeAffinitySpecForListJobsOutput) *RoleForListJobsOutput {
	s.NodeAffinitySpec = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForListJobsOutput) SetReplicas(v int64) *RoleForListJobsOutput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForListJobsOutput) SetResource(v *ResourceForListJobsOutput) *RoleForListJobsOutput {
	s.Resource = v
	return s
}

type StatusForListJobsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsumeRetriedTimes *bool `type:"boolean" json:",omitempty"`

	DiagnoseMessage *string `type:"string" json:",omitempty"`

	DiagnoseState *string `type:"string" json:",omitempty" enum:"EnumOfDiagnoseStateForListJobsOutput"`

	EndTime *string `type:"string" json:",omitempty"`

	HoldingEndTime *string `type:"string" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	RetriedTimes *int64 `type:"int64" json:",omitempty"`

	RetryTrigger *string `type:"string" json:",omitempty" enum:"EnumOfRetryTriggerForListJobsOutput"`

	SecondaryState *string `type:"string" json:",omitempty" enum:"EnumOfSecondaryStateForListJobsOutput"`

	StartTime *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty" enum:"EnumOfStateForListJobsOutput"`
}

// String returns the string representation
func (s StatusForListJobsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListJobsOutput) GoString() string {
	return s.String()
}

// SetConsumeRetriedTimes sets the ConsumeRetriedTimes field's value.
func (s *StatusForListJobsOutput) SetConsumeRetriedTimes(v bool) *StatusForListJobsOutput {
	s.ConsumeRetriedTimes = &v
	return s
}

// SetDiagnoseMessage sets the DiagnoseMessage field's value.
func (s *StatusForListJobsOutput) SetDiagnoseMessage(v string) *StatusForListJobsOutput {
	s.DiagnoseMessage = &v
	return s
}

// SetDiagnoseState sets the DiagnoseState field's value.
func (s *StatusForListJobsOutput) SetDiagnoseState(v string) *StatusForListJobsOutput {
	s.DiagnoseState = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *StatusForListJobsOutput) SetEndTime(v string) *StatusForListJobsOutput {
	s.EndTime = &v
	return s
}

// SetHoldingEndTime sets the HoldingEndTime field's value.
func (s *StatusForListJobsOutput) SetHoldingEndTime(v string) *StatusForListJobsOutput {
	s.HoldingEndTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StatusForListJobsOutput) SetMessage(v string) *StatusForListJobsOutput {
	s.Message = &v
	return s
}

// SetRetriedTimes sets the RetriedTimes field's value.
func (s *StatusForListJobsOutput) SetRetriedTimes(v int64) *StatusForListJobsOutput {
	s.RetriedTimes = &v
	return s
}

// SetRetryTrigger sets the RetryTrigger field's value.
func (s *StatusForListJobsOutput) SetRetryTrigger(v string) *StatusForListJobsOutput {
	s.RetryTrigger = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForListJobsOutput) SetSecondaryState(v string) *StatusForListJobsOutput {
	s.SecondaryState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StatusForListJobsOutput) SetStartTime(v string) *StatusForListJobsOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForListJobsOutput) SetState(v string) *StatusForListJobsOutput {
	s.State = &v
	return s
}

const (
	// EnumOfDiagnoseStateForListJobsInputWaiting is a EnumOfDiagnoseStateForListJobsInput enum value
	EnumOfDiagnoseStateForListJobsInputWaiting = "Waiting"

	// EnumOfDiagnoseStateForListJobsInputRunning is a EnumOfDiagnoseStateForListJobsInput enum value
	EnumOfDiagnoseStateForListJobsInputRunning = "Running"

	// EnumOfDiagnoseStateForListJobsInputPassed is a EnumOfDiagnoseStateForListJobsInput enum value
	EnumOfDiagnoseStateForListJobsInputPassed = "Passed"

	// EnumOfDiagnoseStateForListJobsInputFailed is a EnumOfDiagnoseStateForListJobsInput enum value
	EnumOfDiagnoseStateForListJobsInputFailed = "Failed"

	// EnumOfDiagnoseStateForListJobsInputAbnormal is a EnumOfDiagnoseStateForListJobsInput enum value
	EnumOfDiagnoseStateForListJobsInputAbnormal = "Abnormal"
)

const (
	// EnumOfDiagnoseStateForListJobsOutputWaiting is a EnumOfDiagnoseStateForListJobsOutput enum value
	EnumOfDiagnoseStateForListJobsOutputWaiting = "Waiting"

	// EnumOfDiagnoseStateForListJobsOutputRunning is a EnumOfDiagnoseStateForListJobsOutput enum value
	EnumOfDiagnoseStateForListJobsOutputRunning = "Running"

	// EnumOfDiagnoseStateForListJobsOutputPassed is a EnumOfDiagnoseStateForListJobsOutput enum value
	EnumOfDiagnoseStateForListJobsOutputPassed = "Passed"

	// EnumOfDiagnoseStateForListJobsOutputFailed is a EnumOfDiagnoseStateForListJobsOutput enum value
	EnumOfDiagnoseStateForListJobsOutputFailed = "Failed"

	// EnumOfDiagnoseStateForListJobsOutputAbnormal is a EnumOfDiagnoseStateForListJobsOutput enum value
	EnumOfDiagnoseStateForListJobsOutputAbnormal = "Abnormal"
)

const (
	// EnumOfGPUCPUNodePreferenceForListJobsOutputGpurequired is a EnumOfGPUCPUNodePreferenceForListJobsOutput enum value
	EnumOfGPUCPUNodePreferenceForListJobsOutputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForListJobsOutputGpupreferred is a EnumOfGPUCPUNodePreferenceForListJobsOutput enum value
	EnumOfGPUCPUNodePreferenceForListJobsOutputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForListJobsOutputCpurequired is a EnumOfGPUCPUNodePreferenceForListJobsOutput enum value
	EnumOfGPUCPUNodePreferenceForListJobsOutputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForListJobsOutputCpupreferred is a EnumOfGPUCPUNodePreferenceForListJobsOutput enum value
	EnumOfGPUCPUNodePreferenceForListJobsOutputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfRetryTriggerForListJobsOutputJobFailed is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputJobFailed = "JobFailed"

	// EnumOfRetryTriggerForListJobsOutputMachineFailure is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputMachineFailure = "MachineFailure"

	// EnumOfRetryTriggerForListJobsOutputInstanceReclaimed is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputInstanceReclaimed = "InstanceReclaimed"

	// EnumOfRetryTriggerForListJobsOutputAutoGpucompacted is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputAutoGpucompacted = "AutoGPUCompacted"

	// EnumOfRetryTriggerForListJobsOutputEnvironmentalDiagnosisFailed is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputEnvironmentalDiagnosisFailed = "EnvironmentalDiagnosisFailed"

	// EnumOfRetryTriggerForListJobsOutputPythonDetectionFailed is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputPythonDetectionFailed = "PythonDetectionFailed"

	// EnumOfRetryTriggerForListJobsOutputLogDetectionFailed is a EnumOfRetryTriggerForListJobsOutput enum value
	EnumOfRetryTriggerForListJobsOutputLogDetectionFailed = "LogDetectionFailed"
)

const (
	// EnumOfSecondaryStateForListJobsOutputCompletedHolding is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputCompletedHolding = "CompletedHolding"

	// EnumOfSecondaryStateForListJobsOutputFailedHolding is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputFailedHolding = "FailedHolding"

	// EnumOfSecondaryStateForListJobsOutputNodeWentDown is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputNodeWentDown = "NodeWentDown"

	// EnumOfSecondaryStateForListJobsOutputMachineFault is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputMachineFault = "MachineFault"

	// EnumOfSecondaryStateForListJobsOutputMachineSuspected is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputMachineSuspected = "MachineSuspected"

	// EnumOfSecondaryStateForListJobsOutputMachineRegular is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputMachineRegular = "MachineRegular"

	// EnumOfSecondaryStateForListJobsOutputPodOomkilled is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputPodOomkilled = "PodOOMKilled"

	// EnumOfSecondaryStateForListJobsOutputPodReclaimed is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputPodReclaimed = "PodReclaimed"

	// EnumOfSecondaryStateForListJobsOutputPodAutoGpucompacted is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputPodAutoGpucompacted = "PodAutoGPUCompacted"

	// EnumOfSecondaryStateForListJobsOutputPodEvictByQos is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputPodEvictByQos = "PodEvictByQOS"

	// EnumOfSecondaryStateForListJobsOutputPodEvictByGpupreemptCpu is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputPodEvictByGpupreemptCpu = "PodEvictByGPUPreemptCPU"

	// EnumOfSecondaryStateForListJobsOutputDiagnosisEnvDiagFailed is a EnumOfSecondaryStateForListJobsOutput enum value
	EnumOfSecondaryStateForListJobsOutputDiagnosisEnvDiagFailed = "DiagnosisEnvDiagFailed"
)

const (
	// EnumOfSortByForListJobsInputCreateTime is a EnumOfSortByForListJobsInput enum value
	EnumOfSortByForListJobsInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListJobsInputAscend is a EnumOfSortOrderForListJobsInput enum value
	EnumOfSortOrderForListJobsInputAscend = "Ascend"

	// EnumOfSortOrderForListJobsInputDescend is a EnumOfSortOrderForListJobsInput enum value
	EnumOfSortOrderForListJobsInputDescend = "Descend"
)

const (
	// EnumOfStateForListJobsInputCreating is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputCreating = "Creating"

	// EnumOfStateForListJobsInputWaiting is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputWaiting = "Waiting"

	// EnumOfStateForListJobsInputQueueing is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputQueueing = "Queueing"

	// EnumOfStateForListJobsInputDeploying is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputDeploying = "Deploying"

	// EnumOfStateForListJobsInputRunning is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputRunning = "Running"

	// EnumOfStateForListJobsInputCompleted is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputCompleted = "Completed"

	// EnumOfStateForListJobsInputFailed is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputFailed = "Failed"

	// EnumOfStateForListJobsInputStopping is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputStopping = "Stopping"

	// EnumOfStateForListJobsInputStopped is a EnumOfStateForListJobsInput enum value
	EnumOfStateForListJobsInputStopped = "Stopped"
)

const (
	// EnumOfStateForListJobsOutputCreating is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputCreating = "Creating"

	// EnumOfStateForListJobsOutputWaiting is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputWaiting = "Waiting"

	// EnumOfStateForListJobsOutputQueueing is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputQueueing = "Queueing"

	// EnumOfStateForListJobsOutputDeploying is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputDeploying = "Deploying"

	// EnumOfStateForListJobsOutputRunning is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputRunning = "Running"

	// EnumOfStateForListJobsOutputCompleted is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputCompleted = "Completed"

	// EnumOfStateForListJobsOutputFailed is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputFailed = "Failed"

	// EnumOfStateForListJobsOutputStopping is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputStopping = "Stopping"

	// EnumOfStateForListJobsOutputStopped is a EnumOfStateForListJobsOutput enum value
	EnumOfStateForListJobsOutputStopped = "Stopped"
)
