// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateKeyringCommon = "CreateKeyring"

// CreateKeyringCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKeyringCommon operation. The "output" return
// value will be populated with the CreateKeyringCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyringCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyringCommon Send returns without error.
//
// See CreateKeyringCommon for more information on using the CreateKeyringCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyringCommonRequest method.
//    req, resp := client.CreateKeyringCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateKeyringCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateKeyringCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateKeyringCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateKeyringCommon for usage and error information.
func (c *KMS) CreateKeyringCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateKeyringCommonRequest(input)
	return out, req.Send()
}

// CreateKeyringCommonWithContext is the same as CreateKeyringCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyringCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateKeyringCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateKeyringCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyring = "CreateKeyring"

// CreateKeyringRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateKeyring operation. The "output" return
// value will be populated with the CreateKeyringCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateKeyringCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateKeyringCommon Send returns without error.
//
// See CreateKeyring for more information on using the CreateKeyring
// API call, and error handling.
//
//    // Example sending a request using the CreateKeyringRequest method.
//    req, resp := client.CreateKeyringRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateKeyringRequest(input *CreateKeyringInput) (req *request.Request, output *CreateKeyringOutput) {
	op := &request.Operation{
		Name:       opCreateKeyring,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyringInput{}
	}

	output = &CreateKeyringOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateKeyring API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateKeyring for usage and error information.
func (c *KMS) CreateKeyring(input *CreateKeyringInput) (*CreateKeyringOutput, error) {
	req, out := c.CreateKeyringRequest(input)
	return out, req.Send()
}

// CreateKeyringWithContext is the same as CreateKeyring with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateKeyringWithContext(ctx volcengine.Context, input *CreateKeyringInput, opts ...request.Option) (*CreateKeyringOutput, error) {
	req, out := c.CreateKeyringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateKeyringInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"8192" type:"string" json:",omitempty"`

	// KeyringName is a required field
	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`

	KeyringType *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateKeyringInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyringInput"}
	if s.Description != nil && len(*s.Description) > 8192 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 8192, *s.Description))
	}
	if s.KeyringName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyringName"))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateKeyringInput) SetDescription(v string) *CreateKeyringInput {
	s.Description = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *CreateKeyringInput) SetKeyringName(v string) *CreateKeyringInput {
	s.KeyringName = &v
	return s
}

// SetKeyringType sets the KeyringType field's value.
func (s *CreateKeyringInput) SetKeyringType(v string) *CreateKeyringInput {
	s.KeyringType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateKeyringInput) SetProjectName(v string) *CreateKeyringInput {
	s.ProjectName = &v
	return s
}

type CreateKeyringOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Keyring *KeyringForCreateKeyringOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateKeyringOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyringOutput) GoString() string {
	return s.String()
}

// SetKeyring sets the Keyring field's value.
func (s *CreateKeyringOutput) SetKeyring(v *KeyringForCreateKeyringOutput) *CreateKeyringOutput {
	s.Keyring = v
	return s
}

type KeyringForCreateKeyringOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	KeyringName *string `type:"string" json:",omitempty"`

	KeyringType *string `type:"string" json:",omitempty"`

	TRN *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s KeyringForCreateKeyringOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyringForCreateKeyringOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *KeyringForCreateKeyringOutput) SetCreationDate(v int64) *KeyringForCreateKeyringOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KeyringForCreateKeyringOutput) SetDescription(v string) *KeyringForCreateKeyringOutput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *KeyringForCreateKeyringOutput) SetID(v string) *KeyringForCreateKeyringOutput {
	s.ID = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *KeyringForCreateKeyringOutput) SetKeyringName(v string) *KeyringForCreateKeyringOutput {
	s.KeyringName = &v
	return s
}

// SetKeyringType sets the KeyringType field's value.
func (s *KeyringForCreateKeyringOutput) SetKeyringType(v string) *KeyringForCreateKeyringOutput {
	s.KeyringType = &v
	return s
}

// SetTRN sets the TRN field's value.
func (s *KeyringForCreateKeyringOutput) SetTRN(v string) *KeyringForCreateKeyringOutput {
	s.TRN = &v
	return s
}

// SetUID sets the UID field's value.
func (s *KeyringForCreateKeyringOutput) SetUID(v string) *KeyringForCreateKeyringOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *KeyringForCreateKeyringOutput) SetUpdateDate(v int64) *KeyringForCreateKeyringOutput {
	s.UpdateDate = &v
	return s
}
