// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateCustomKeyStoreCommon = "CreateCustomKeyStore"

// CreateCustomKeyStoreCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomKeyStoreCommon operation. The "output" return
// value will be populated with the CreateCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomKeyStoreCommon Send returns without error.
//
// See CreateCustomKeyStoreCommon for more information on using the CreateCustomKeyStoreCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomKeyStoreCommonRequest method.
//    req, resp := client.CreateCustomKeyStoreCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateCustomKeyStoreCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateCustomKeyStoreCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCustomKeyStoreCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateCustomKeyStoreCommon for usage and error information.
func (c *KMS) CreateCustomKeyStoreCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateCustomKeyStoreCommonRequest(input)
	return out, req.Send()
}

// CreateCustomKeyStoreCommonWithContext is the same as CreateCustomKeyStoreCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomKeyStoreCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateCustomKeyStoreCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateCustomKeyStoreCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomKeyStore = "CreateCustomKeyStore"

// CreateCustomKeyStoreRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCustomKeyStore operation. The "output" return
// value will be populated with the CreateCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateCustomKeyStoreCommon Send returns without error.
//
// See CreateCustomKeyStore for more information on using the CreateCustomKeyStore
// API call, and error handling.
//
//    // Example sending a request using the CreateCustomKeyStoreRequest method.
//    req, resp := client.CreateCustomKeyStoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateCustomKeyStoreRequest(input *CreateCustomKeyStoreInput) (req *request.Request, output *CreateCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opCreateCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomKeyStoreInput{}
	}

	output = &CreateCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCustomKeyStore API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateCustomKeyStore for usage and error information.
func (c *KMS) CreateCustomKeyStore(input *CreateCustomKeyStoreInput) (*CreateCustomKeyStoreOutput, error) {
	req, out := c.CreateCustomKeyStoreRequest(input)
	return out, req.Send()
}

// CreateCustomKeyStoreWithContext is the same as CreateCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateCustomKeyStoreWithContext(ctx volcengine.Context, input *CreateCustomKeyStoreInput, opts ...request.Option) (*CreateCustomKeyStoreOutput, error) {
	req, out := c.CreateCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateCustomKeyStoreInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomKeyStoreName is a required field
	CustomKeyStoreName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`

	// CustomKeyStoreType is a required field
	CustomKeyStoreType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreInput"`

	// TrustAnchorCertificate is a required field
	TrustAnchorCertificate *string `min:"1" max:"5000" type:"string" json:",omitempty" required:"true"`

	XksAccessKey *string `min:"20" max:"30" type:"string" json:",omitempty"`

	XksProxyConnectivity *string `type:"string" json:",omitempty" enum:"EnumOfXksProxyConnectivityForCreateCustomKeyStoreInput"`

	XksProxyUriEndpoint *string `min:"10" max:"128" type:"string" json:",omitempty"`

	XksProxyUriPath *string `min:"10" max:"128" type:"string" json:",omitempty"`

	XksProxyVpcEndpointServiceName *string `min:"20" max:"128" type:"string" json:",omitempty"`

	XksSecretAccessKey *string `min:"43" max:"64" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateCustomKeyStoreInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomKeyStoreInput"}
	if s.CustomKeyStoreName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreName"))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreName", 2))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreName", 31, *s.CustomKeyStoreName))
	}
	if s.CustomKeyStoreType == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreType"))
	}
	if s.TrustAnchorCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorCertificate"))
	}
	if s.TrustAnchorCertificate != nil && len(*s.TrustAnchorCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorCertificate", 1))
	}
	if s.TrustAnchorCertificate != nil && len(*s.TrustAnchorCertificate) > 5000 {
		invalidParams.Add(request.NewErrParamMaxLen("TrustAnchorCertificate", 5000, *s.TrustAnchorCertificate))
	}
	if s.XksAccessKey != nil && len(*s.XksAccessKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksAccessKey", 20))
	}
	if s.XksAccessKey != nil && len(*s.XksAccessKey) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("XksAccessKey", 30, *s.XksAccessKey))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriEndpoint", 10))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyUriEndpoint", 128, *s.XksProxyUriEndpoint))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriPath", 10))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyUriPath", 128, *s.XksProxyUriPath))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyVpcEndpointServiceName", 20))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyVpcEndpointServiceName", 128, *s.XksProxyVpcEndpointServiceName))
	}
	if s.XksSecretAccessKey != nil && len(*s.XksSecretAccessKey) < 43 {
		invalidParams.Add(request.NewErrParamMinLen("XksSecretAccessKey", 43))
	}
	if s.XksSecretAccessKey != nil && len(*s.XksSecretAccessKey) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("XksSecretAccessKey", 64, *s.XksSecretAccessKey))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *CreateCustomKeyStoreInput) SetCustomKeyStoreName(v string) *CreateCustomKeyStoreInput {
	s.CustomKeyStoreName = &v
	return s
}

// SetCustomKeyStoreType sets the CustomKeyStoreType field's value.
func (s *CreateCustomKeyStoreInput) SetCustomKeyStoreType(v string) *CreateCustomKeyStoreInput {
	s.CustomKeyStoreType = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *CreateCustomKeyStoreInput) SetTrustAnchorCertificate(v string) *CreateCustomKeyStoreInput {
	s.TrustAnchorCertificate = &v
	return s
}

// SetXksAccessKey sets the XksAccessKey field's value.
func (s *CreateCustomKeyStoreInput) SetXksAccessKey(v string) *CreateCustomKeyStoreInput {
	s.XksAccessKey = &v
	return s
}

// SetXksProxyConnectivity sets the XksProxyConnectivity field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyConnectivity(v string) *CreateCustomKeyStoreInput {
	s.XksProxyConnectivity = &v
	return s
}

// SetXksProxyUriEndpoint sets the XksProxyUriEndpoint field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyUriEndpoint(v string) *CreateCustomKeyStoreInput {
	s.XksProxyUriEndpoint = &v
	return s
}

// SetXksProxyUriPath sets the XksProxyUriPath field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyUriPath(v string) *CreateCustomKeyStoreInput {
	s.XksProxyUriPath = &v
	return s
}

// SetXksProxyVpcEndpointServiceName sets the XksProxyVpcEndpointServiceName field's value.
func (s *CreateCustomKeyStoreInput) SetXksProxyVpcEndpointServiceName(v string) *CreateCustomKeyStoreInput {
	s.XksProxyVpcEndpointServiceName = &v
	return s
}

// SetXksSecretAccessKey sets the XksSecretAccessKey field's value.
func (s *CreateCustomKeyStoreInput) SetXksSecretAccessKey(v string) *CreateCustomKeyStoreInput {
	s.XksSecretAccessKey = &v
	return s
}

type CreateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CustomKeyStore *CustomKeyStoreForCreateCustomKeyStoreOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

// SetCustomKeyStore sets the CustomKeyStore field's value.
func (s *CreateCustomKeyStoreOutput) SetCustomKeyStore(v *CustomKeyStoreForCreateCustomKeyStoreOutput) *CreateCustomKeyStoreOutput {
	s.CustomKeyStore = v
	return s
}

type CustomKeyStoreForCreateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConnectionErrorCode *string `type:"string" json:",omitempty"`

	ConnectionState *string `type:"string" json:",omitempty" enum:"EnumOfConnectionStateForCreateCustomKeyStoreOutput"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	CustomKeyStoreName *string `type:"string" json:",omitempty"`

	CustomKeyStoreType *string `type:"string" json:",omitempty" enum:"EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreOutput"`

	ID *string `type:"string" json:",omitempty"`

	TrustAnchorCertificate *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`

	XksProxyConfiguration *XksProxyConfigurationForCreateCustomKeyStoreOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CustomKeyStoreForCreateCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomKeyStoreForCreateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

// SetConnectionErrorCode sets the ConnectionErrorCode field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetConnectionErrorCode(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.ConnectionErrorCode = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetConnectionState(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetCreationDate(v int64) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.CreationDate = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetCustomKeyStoreName(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.CustomKeyStoreName = &v
	return s
}

// SetCustomKeyStoreType sets the CustomKeyStoreType field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetCustomKeyStoreType(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.CustomKeyStoreType = &v
	return s
}

// SetID sets the ID field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetID(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.ID = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetTrustAnchorCertificate(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.TrustAnchorCertificate = &v
	return s
}

// SetUID sets the UID field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetUID(v string) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetUpdateDate(v int64) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.UpdateDate = &v
	return s
}

// SetXksProxyConfiguration sets the XksProxyConfiguration field's value.
func (s *CustomKeyStoreForCreateCustomKeyStoreOutput) SetXksProxyConfiguration(v *XksProxyConfigurationForCreateCustomKeyStoreOutput) *CustomKeyStoreForCreateCustomKeyStoreOutput {
	s.XksProxyConfiguration = v
	return s
}

type XksProxyConfigurationForCreateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	Connectivity *string `type:"string" json:",omitempty"`

	UriEndpoint *string `type:"string" json:",omitempty"`

	UriPath *string `type:"string" json:",omitempty"`

	VpcEndpointServiceName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s XksProxyConfigurationForCreateCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s XksProxyConfigurationForCreateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *XksProxyConfigurationForCreateCustomKeyStoreOutput) SetAccessKey(v string) *XksProxyConfigurationForCreateCustomKeyStoreOutput {
	s.AccessKey = &v
	return s
}

// SetConnectivity sets the Connectivity field's value.
func (s *XksProxyConfigurationForCreateCustomKeyStoreOutput) SetConnectivity(v string) *XksProxyConfigurationForCreateCustomKeyStoreOutput {
	s.Connectivity = &v
	return s
}

// SetUriEndpoint sets the UriEndpoint field's value.
func (s *XksProxyConfigurationForCreateCustomKeyStoreOutput) SetUriEndpoint(v string) *XksProxyConfigurationForCreateCustomKeyStoreOutput {
	s.UriEndpoint = &v
	return s
}

// SetUriPath sets the UriPath field's value.
func (s *XksProxyConfigurationForCreateCustomKeyStoreOutput) SetUriPath(v string) *XksProxyConfigurationForCreateCustomKeyStoreOutput {
	s.UriPath = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *XksProxyConfigurationForCreateCustomKeyStoreOutput) SetVpcEndpointServiceName(v string) *XksProxyConfigurationForCreateCustomKeyStoreOutput {
	s.VpcEndpointServiceName = &v
	return s
}

const (
	// EnumOfConnectionStateForCreateCustomKeyStoreOutputConnected is a EnumOfConnectionStateForCreateCustomKeyStoreOutput enum value
	EnumOfConnectionStateForCreateCustomKeyStoreOutputConnected = "CONNECTED"

	// EnumOfConnectionStateForCreateCustomKeyStoreOutputConnecting is a EnumOfConnectionStateForCreateCustomKeyStoreOutput enum value
	EnumOfConnectionStateForCreateCustomKeyStoreOutputConnecting = "CONNECTING"

	// EnumOfConnectionStateForCreateCustomKeyStoreOutputFailed is a EnumOfConnectionStateForCreateCustomKeyStoreOutput enum value
	EnumOfConnectionStateForCreateCustomKeyStoreOutputFailed = "FAILED"

	// EnumOfConnectionStateForCreateCustomKeyStoreOutputDisconnected is a EnumOfConnectionStateForCreateCustomKeyStoreOutput enum value
	EnumOfConnectionStateForCreateCustomKeyStoreOutputDisconnected = "DISCONNECTED"

	// EnumOfConnectionStateForCreateCustomKeyStoreOutputDisconnecting is a EnumOfConnectionStateForCreateCustomKeyStoreOutput enum value
	EnumOfConnectionStateForCreateCustomKeyStoreOutputDisconnecting = "DISCONNECTING"
)

const (
	// EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreInputExternalKeyStore is a EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreInput enum value
	EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreInputExternalKeyStore = "ExternalKeyStore"
)

const (
	// EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreOutputExternalKeyStore is a EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreOutput enum value
	EnumOfCustomKeyStoreTypeForCreateCustomKeyStoreOutputExternalKeyStore = "ExternalKeyStore"
)

const (
	// EnumOfXksProxyConnectivityForCreateCustomKeyStoreInputPublicEndpoint is a EnumOfXksProxyConnectivityForCreateCustomKeyStoreInput enum value
	EnumOfXksProxyConnectivityForCreateCustomKeyStoreInputPublicEndpoint = "PUBLIC_ENDPOINT"

	// EnumOfXksProxyConnectivityForCreateCustomKeyStoreInputVpcEndpointService is a EnumOfXksProxyConnectivityForCreateCustomKeyStoreInput enum value
	EnumOfXksProxyConnectivityForCreateCustomKeyStoreInputVpcEndpointService = "VPC_ENDPOINT_SERVICE"
)
