// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCancelKeyDeletionCommon = "CancelKeyDeletion"

// CancelKeyDeletionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CancelKeyDeletionCommon operation. The "output" return
// value will be populated with the CancelKeyDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CancelKeyDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CancelKeyDeletionCommon Send returns without error.
//
// See CancelKeyDeletionCommon for more information on using the CancelKeyDeletionCommon
// API call, and error handling.
//
//    // Example sending a request using the CancelKeyDeletionCommonRequest method.
//    req, resp := client.CancelKeyDeletionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CancelKeyDeletionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCancelKeyDeletionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CancelKeyDeletionCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CancelKeyDeletionCommon for usage and error information.
func (c *KMS) CancelKeyDeletionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CancelKeyDeletionCommonRequest(input)
	return out, req.Send()
}

// CancelKeyDeletionCommonWithContext is the same as CancelKeyDeletionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CancelKeyDeletionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CancelKeyDeletionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CancelKeyDeletionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelKeyDeletion = "CancelKeyDeletion"

// CancelKeyDeletionRequest generates a "volcengine/request.Request" representing the
// client's request for the CancelKeyDeletion operation. The "output" return
// value will be populated with the CancelKeyDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CancelKeyDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after CancelKeyDeletionCommon Send returns without error.
//
// See CancelKeyDeletion for more information on using the CancelKeyDeletion
// API call, and error handling.
//
//    // Example sending a request using the CancelKeyDeletionRequest method.
//    req, resp := client.CancelKeyDeletionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CancelKeyDeletionRequest(input *CancelKeyDeletionInput) (req *request.Request, output *CancelKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opCancelKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelKeyDeletionInput{}
	}

	output = &CancelKeyDeletionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CancelKeyDeletion API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CancelKeyDeletion for usage and error information.
func (c *KMS) CancelKeyDeletion(input *CancelKeyDeletionInput) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	return out, req.Send()
}

// CancelKeyDeletionWithContext is the same as CancelKeyDeletion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelKeyDeletion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CancelKeyDeletionWithContext(ctx volcengine.Context, input *CancelKeyDeletionInput, opts ...request.Option) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelKeyDeletionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CancelKeyDeletionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelKeyDeletionInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyID sets the KeyID field's value.
func (s *CancelKeyDeletionInput) SetKeyID(v string) *CancelKeyDeletionInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CancelKeyDeletionInput) SetKeyName(v string) *CancelKeyDeletionInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *CancelKeyDeletionInput) SetKeyringName(v string) *CancelKeyDeletionInput {
	s.KeyringName = &v
	return s
}

type CancelKeyDeletionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CancelKeyDeletionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionOutput) GoString() string {
	return s.String()
}
