// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package graph

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAlterTableCommon = "AlterTable"

// AlterTableCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AlterTableCommon operation. The "output" return
// value will be populated with the AlterTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AlterTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after AlterTableCommon Send returns without error.
//
// See AlterTableCommon for more information on using the AlterTableCommon
// API call, and error handling.
//
//    // Example sending a request using the AlterTableCommonRequest method.
//    req, resp := client.AlterTableCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) AlterTableCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAlterTableCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AlterTableCommon API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation AlterTableCommon for usage and error information.
func (c *GRAPH) AlterTableCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AlterTableCommonRequest(input)
	return out, req.Send()
}

// AlterTableCommonWithContext is the same as AlterTableCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AlterTableCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) AlterTableCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AlterTableCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAlterTable = "AlterTable"

// AlterTableRequest generates a "volcengine/request.Request" representing the
// client's request for the AlterTable operation. The "output" return
// value will be populated with the AlterTableCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AlterTableCommon Request to send the API call to the service.
// the "output" return value is not valid until after AlterTableCommon Send returns without error.
//
// See AlterTable for more information on using the AlterTable
// API call, and error handling.
//
//    // Example sending a request using the AlterTableRequest method.
//    req, resp := client.AlterTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) AlterTableRequest(input *AlterTableInput) (req *request.Request, output *AlterTableOutput) {
	op := &request.Operation{
		Name:       opAlterTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AlterTableInput{}
	}

	output = &AlterTableOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AlterTable API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation AlterTable for usage and error information.
func (c *GRAPH) AlterTable(input *AlterTableInput) (*AlterTableOutput, error) {
	req, out := c.AlterTableRequest(input)
	return out, req.Send()
}

// AlterTableWithContext is the same as AlterTable with the addition of
// the ability to pass a context and additional request options.
//
// See AlterTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) AlterTableWithContext(ctx volcengine.Context, input *AlterTableInput, opts ...request.Option) (*AlterTableOutput, error) {
	req, out := c.AlterTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AlterTableInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableRead *bool `type:"boolean" json:",omitempty"`

	EnableWrite *bool `type:"boolean" json:",omitempty"`

	IOQosOptions *IOQosOptionsForAlterTableInput `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	State *int32 `type:"int32" json:",omitempty"`

	// TableName is a required field
	TableName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s AlterTableInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AlterTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlterTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlterTableInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableRead sets the EnableRead field's value.
func (s *AlterTableInput) SetEnableRead(v bool) *AlterTableInput {
	s.EnableRead = &v
	return s
}

// SetEnableWrite sets the EnableWrite field's value.
func (s *AlterTableInput) SetEnableWrite(v bool) *AlterTableInput {
	s.EnableWrite = &v
	return s
}

// SetIOQosOptions sets the IOQosOptions field's value.
func (s *AlterTableInput) SetIOQosOptions(v *IOQosOptionsForAlterTableInput) *AlterTableInput {
	s.IOQosOptions = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AlterTableInput) SetInstanceId(v string) *AlterTableInput {
	s.InstanceId = &v
	return s
}

// SetState sets the State field's value.
func (s *AlterTableInput) SetState(v int32) *AlterTableInput {
	s.State = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *AlterTableInput) SetTableName(v string) *AlterTableInput {
	s.TableName = &v
	return s
}

type AlterTableOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s AlterTableOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AlterTableOutput) GoString() string {
	return s.String()
}

type IOQosOptionsForAlterTableInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Iops_limit *int64 `type:"int64" json:"iops_limit,omitempty"`

	Read_bandwidth_limit_in_bytes *int64 `type:"int64" json:"read_bandwidth_limit_in_bytes,omitempty"`

	Storage_capacity_limit_in_bytes *int64 `type:"int64" json:"storage_capacity_limit_in_bytes,omitempty"`

	Write_bandwidth_limit_in_bytes *int64 `type:"int64" json:"write_bandwidth_limit_in_bytes,omitempty"`
}

// String returns the string representation
func (s IOQosOptionsForAlterTableInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IOQosOptionsForAlterTableInput) GoString() string {
	return s.String()
}

// SetIops_limit sets the Iops_limit field's value.
func (s *IOQosOptionsForAlterTableInput) SetIops_limit(v int64) *IOQosOptionsForAlterTableInput {
	s.Iops_limit = &v
	return s
}

// SetRead_bandwidth_limit_in_bytes sets the Read_bandwidth_limit_in_bytes field's value.
func (s *IOQosOptionsForAlterTableInput) SetRead_bandwidth_limit_in_bytes(v int64) *IOQosOptionsForAlterTableInput {
	s.Read_bandwidth_limit_in_bytes = &v
	return s
}

// SetStorage_capacity_limit_in_bytes sets the Storage_capacity_limit_in_bytes field's value.
func (s *IOQosOptionsForAlterTableInput) SetStorage_capacity_limit_in_bytes(v int64) *IOQosOptionsForAlterTableInput {
	s.Storage_capacity_limit_in_bytes = &v
	return s
}

// SetWrite_bandwidth_limit_in_bytes sets the Write_bandwidth_limit_in_bytes field's value.
func (s *IOQosOptionsForAlterTableInput) SetWrite_bandwidth_limit_in_bytes(v int64) *IOQosOptionsForAlterTableInput {
	s.Write_bandwidth_limit_in_bytes = &v
	return s
}
