// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyAddressBookCommon = "ModifyAddressBook"

// ModifyAddressBookCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyAddressBookCommon operation. The "output" return
// value will be populated with the ModifyAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyAddressBookCommon Send returns without error.
//
// See ModifyAddressBookCommon for more information on using the ModifyAddressBookCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyAddressBookCommonRequest method.
//    req, resp := client.ModifyAddressBookCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) ModifyAddressBookCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyAddressBookCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyAddressBookCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation ModifyAddressBookCommon for usage and error information.
func (c *FWCENTER) ModifyAddressBookCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyAddressBookCommonRequest(input)
	return out, req.Send()
}

// ModifyAddressBookCommonWithContext is the same as ModifyAddressBookCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAddressBookCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) ModifyAddressBookCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyAddressBookCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyAddressBook = "ModifyAddressBook"

// ModifyAddressBookRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyAddressBook operation. The "output" return
// value will be populated with the ModifyAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyAddressBookCommon Send returns without error.
//
// See ModifyAddressBook for more information on using the ModifyAddressBook
// API call, and error handling.
//
//    // Example sending a request using the ModifyAddressBookRequest method.
//    req, resp := client.ModifyAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) ModifyAddressBookRequest(input *ModifyAddressBookInput) (req *request.Request, output *ModifyAddressBookOutput) {
	op := &request.Operation{
		Name:       opModifyAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAddressBookInput{}
	}

	output = &ModifyAddressBookOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyAddressBook API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation ModifyAddressBook for usage and error information.
func (c *FWCENTER) ModifyAddressBook(input *ModifyAddressBookInput) (*ModifyAddressBookOutput, error) {
	req, out := c.ModifyAddressBookRequest(input)
	return out, req.Send()
}

// ModifyAddressBookWithContext is the same as ModifyAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) ModifyAddressBookWithContext(ctx volcengine.Context, input *ModifyAddressBookInput, opts ...request.Option) (*ModifyAddressBookOutput, error) {
	req, out := c.ModifyAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressDetailListForModifyAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	Description *string `max:"32" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AddressDetailListForModifyAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressDetailListForModifyAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddressDetailListForModifyAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddressDetailListForModifyAddressBookInput"}
	if s.Description != nil && len(*s.Description) > 32 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 32, *s.Description))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *AddressDetailListForModifyAddressBookInput) SetAddress(v string) *AddressDetailListForModifyAddressBookInput {
	s.Address = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressDetailListForModifyAddressBookInput) SetDescription(v string) *AddressDetailListForModifyAddressBookInput {
	s.Description = &v
	return s
}

type ModifyAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressDetailList []*AddressDetailListForModifyAddressBookInput `type:"list" json:",omitempty"`

	AddressList []*string `type:"list" json:",omitempty"`

	AutoUpdateType *string `type:"string" json:",omitempty" enum:"EnumOfAutoUpdateTypeForModifyAddressBookInput"`

	CloudFirewallId *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	// GroupName is a required field
	GroupName *string `max:"64" type:"string" json:",omitempty" required:"true"`

	// GroupUuid is a required field
	GroupUuid *string `type:"string" json:",omitempty" required:"true"`

	InstanceTypeList []*string `type:"list" json:",omitempty"`

	ResourceType *string `type:"string" json:",omitempty" enum:"EnumOfResourceTypeForModifyAddressBookInput"`

	TagRelation *string `type:"string" json:",omitempty" enum:"EnumOfTagRelationForModifyAddressBookInput"`

	Tags []*TagForModifyAddressBookInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ModifyAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyAddressBookInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("GroupName", 64, *s.GroupName))
	}
	if s.GroupUuid == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupUuid"))
	}
	if s.AddressDetailList != nil {
		for i, v := range s.AddressDetailList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddressDetailList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressDetailList sets the AddressDetailList field's value.
func (s *ModifyAddressBookInput) SetAddressDetailList(v []*AddressDetailListForModifyAddressBookInput) *ModifyAddressBookInput {
	s.AddressDetailList = v
	return s
}

// SetAddressList sets the AddressList field's value.
func (s *ModifyAddressBookInput) SetAddressList(v []*string) *ModifyAddressBookInput {
	s.AddressList = v
	return s
}

// SetAutoUpdateType sets the AutoUpdateType field's value.
func (s *ModifyAddressBookInput) SetAutoUpdateType(v string) *ModifyAddressBookInput {
	s.AutoUpdateType = &v
	return s
}

// SetCloudFirewallId sets the CloudFirewallId field's value.
func (s *ModifyAddressBookInput) SetCloudFirewallId(v string) *ModifyAddressBookInput {
	s.CloudFirewallId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyAddressBookInput) SetDescription(v string) *ModifyAddressBookInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ModifyAddressBookInput) SetGroupName(v string) *ModifyAddressBookInput {
	s.GroupName = &v
	return s
}

// SetGroupUuid sets the GroupUuid field's value.
func (s *ModifyAddressBookInput) SetGroupUuid(v string) *ModifyAddressBookInput {
	s.GroupUuid = &v
	return s
}

// SetInstanceTypeList sets the InstanceTypeList field's value.
func (s *ModifyAddressBookInput) SetInstanceTypeList(v []*string) *ModifyAddressBookInput {
	s.InstanceTypeList = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ModifyAddressBookInput) SetResourceType(v string) *ModifyAddressBookInput {
	s.ResourceType = &v
	return s
}

// SetTagRelation sets the TagRelation field's value.
func (s *ModifyAddressBookInput) SetTagRelation(v string) *ModifyAddressBookInput {
	s.TagRelation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ModifyAddressBookInput) SetTags(v []*TagForModifyAddressBookInput) *ModifyAddressBookInput {
	s.Tags = v
	return s
}

type ModifyAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	GroupUuid *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModifyAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAddressBookOutput) GoString() string {
	return s.String()
}

// SetGroupUuid sets the GroupUuid field's value.
func (s *ModifyAddressBookOutput) SetGroupUuid(v string) *ModifyAddressBookOutput {
	s.GroupUuid = &v
	return s
}

type TagForModifyAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForModifyAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForModifyAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForModifyAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForModifyAddressBookInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForModifyAddressBookInput) SetKey(v string) *TagForModifyAddressBookInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForModifyAddressBookInput) SetValue(v string) *TagForModifyAddressBookInput {
	s.Value = &v
	return s
}

const (
	// EnumOfAutoUpdateTypeForModifyAddressBookInputManual is a EnumOfAutoUpdateTypeForModifyAddressBookInput enum value
	EnumOfAutoUpdateTypeForModifyAddressBookInputManual = "Manual"

	// EnumOfAutoUpdateTypeForModifyAddressBookInputTag is a EnumOfAutoUpdateTypeForModifyAddressBookInput enum value
	EnumOfAutoUpdateTypeForModifyAddressBookInputTag = "Tag"
)

const (
	// EnumOfResourceTypeForModifyAddressBookInputEip is a EnumOfResourceTypeForModifyAddressBookInput enum value
	EnumOfResourceTypeForModifyAddressBookInputEip = "Eip"

	// EnumOfResourceTypeForModifyAddressBookInputInternetAsset is a EnumOfResourceTypeForModifyAddressBookInput enum value
	EnumOfResourceTypeForModifyAddressBookInputInternetAsset = "InternetAsset"
)

const (
	// EnumOfTagRelationForModifyAddressBookInputAnd is a EnumOfTagRelationForModifyAddressBookInput enum value
	EnumOfTagRelationForModifyAddressBookInputAnd = "And"

	// EnumOfTagRelationForModifyAddressBookInputOr is a EnumOfTagRelationForModifyAddressBookInput enum value
	EnumOfTagRelationForModifyAddressBookInputOr = "Or"
)
